/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.modedit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.crosswire.modedit.About;
import org.crosswire.modedit.MainFrame_contentPane_keyAdapter;
import org.crosswire.modedit.MainFrame_currentVerseText_keyAdapter;
import org.crosswire.modedit.MainFrame_exportRangeButton_actionAdapter;
import org.crosswire.modedit.MainFrame_greekTextEditor_keyAdapter;
import org.crosswire.modedit.MainFrame_greekTextEditor_mouseAdapter;
import org.crosswire.modedit.MainFrame_guessTagButton_actionAdapter;
import org.crosswire.modedit.MainFrame_jButton1_actionAdapter;
import org.crosswire.modedit.MainFrame_jMenuItem1_actionAdapter;
import org.crosswire.modedit.MainFrame_jMenuItem2_actionAdapter;
import org.crosswire.modedit.MainFrame_jMenuItem3_actionAdapter;
import org.crosswire.modedit.MainFrame_loadVerseButton_actionAdapter;
import org.crosswire.modedit.MainFrame_loginButton_actionAdapter;
import org.crosswire.modedit.MainFrame_signSaveButton_actionAdapter;
import org.crosswire.modedit.MainFrame_this_keyAdapter;
import org.crosswire.modedit.MainFrame_translatedTextEditor_keyAdapter;
import org.crosswire.modedit.MainFrame_translatedTextEditor_mouseAdapter;
import org.crosswire.modedit.MainFrame_translatedTextEditor_mouseMotionAdapter;
import org.crosswire.modedit.ProxyDialog;
import org.crosswire.modedit.TagInfo;
import org.crosswire.modedit.TransInfo;

public class MainFrame
extends JFrame {
    JPanel contentPane;
    BorderLayout contentPaneLayout = new BorderLayout();
    JPanel rightPanel = new JPanel();
    JPanel leftPanel = new JPanel();
    JPanel currentTagPanel = new JPanel();
    JPanel textPanel = new JPanel();
    BorderLayout leftPanelLayout = new BorderLayout();
    JEditorPane translatedTextEditor = new JEditorPane(this){

        public boolean isManagingFocus() {
            return true;
        }
    };
    GridLayout textPanelLayout = new GridLayout();
    JTextArea greekTextEditor = new JTextArea(this){

        public boolean isManagingFocus() {
            return true;
        }
    };
    JPanel signSavePanel = new JPanel();
    JPanel tagPanel = new JPanel();
    BorderLayout currentTagPanelLayout = new BorderLayout();
    JLabel currentTagLabel = new JLabel();
    GridLayout tagPanelLayout = new GridLayout();
    JTextField currentTagText = new JTextField();
    JPanel currentActionPanel = new JPanel();
    JLabel currentActionLabel = new JLabel();
    JLabel actionLabel = new JLabel();
    JButton signSaveButton = new JButton();
    JButton guessTagButton = new JButton();
    JPanel loginPanel = new JPanel();
    JLabel userIDLabel = new JLabel();
    JTextField userIDText = new JTextField();
    JButton loginButton = new JButton();
    JLabel loginStatusLabel = new JLabel();
    GridLayout loginPanelLayout = new GridLayout();
    BorderLayout rightPanelLayout = new BorderLayout();
    int currentCaret = -1;
    Object greekHighlight;
    private JEditorPane strongTextEditor = new JEditorPane();
    private TitledBorder translatedTextEditorBorder;
    private TitledBorder greekTextEditorBorder;
    private TitledBorder strongTextEditorBorder;
    private Hashtable tags = new Hashtable();
    private JScrollPane strongTextScroll = new JScrollPane();
    private JScrollPane translatedTextScroll = new JScrollPane();
    private JScrollPane greekTextScroll = new JScrollPane();
    private JPanel aPanel = new JPanel();
    private JPanel currentVersePanel = new JPanel();
    private BorderLayout aPanelLayout = new BorderLayout();
    private JLabel currentVerseLabel = new JLabel();
    private JTextField currentVerseText = new JTextField();
    private GridLayout currentVersePanelLayout = new GridLayout();
    private JButton loadVerseButton = new JButton();
    private TitledBorder currentVersePanelBorder;
    private TitledBorder loginPanelBorder;
    private JPanel bPanel = new JPanel();
    private JPanel strongPanel = new JPanel();
    private JTextField wordText = new JTextField();
    private GridLayout strongPanelLayout = new GridLayout();
    private JTextField morphText = new JTextField();
    private JTextField strongText = new JTextField();
    private BorderLayout bPanelLayout = new BorderLayout();
    private TitledBorder signSavePanelBorder;
    private JPanel cPanel = new JPanel();
    boolean localTR = false;
    boolean localKJV = false;
    boolean localThayer = false;
    boolean localImages = false;
    String util = "./modedit";
    static String startTag1 = "<a href=\"http://SID:";
    static String startTag2 = "\"><img border=0 src=\"http://www.crosswire.org/images/starttag";
    static String startTag3 = ".gif\"></a>";
    static String endTag1 = "<a href=\"http://EID:";
    static String endTag2 = "\"><img border=0 src=\"http://www.crosswire.org/images/endtag";
    static String endTag3 = ".gif\"></a>";
    private String userID = null;
    private String loginToken = null;
    private String proxyHost = null;
    private String proxyPort = null;
    private boolean useProxy = false;
    public String currentKey = null;
    private JPanel currentRangePanel = new JPanel();
    private JLabel currentRangeLabel = new JLabel();
    private JTextField rangeText = new JTextField();
    private GridLayout currentRangePanelLayout = new GridLayout();
    private BorderLayout cPanelLayout = new BorderLayout();
    private TitledBorder currentRangePanelBorder;
    private JButton exportRangeButton = new JButton();
    private TitledBorder leftPanelBorder;
    private JMenuBar jMenuBar1 = new JMenuBar();
    private JMenu jMenu1 = new JMenu();
    private JMenuItem jMenuItem1 = new JMenuItem();
    private JMenu jMenu2 = new JMenu();
    private JMenuItem jMenuItem2 = new JMenuItem();
    private JLabel jLabel1 = new JLabel();
    private JScrollPane jScrollPane1 = new JScrollPane();
    private JTextArea notesText = new JTextArea();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel jPanel1 = new JPanel();
    private BorderLayout borderLayout2 = new BorderLayout();
    private TitledBorder titledBorder1;
    private JMenu jMenu3 = new JMenu();
    private JMenuItem jMenuItem3 = new JMenuItem();
    private JPanel jPanel2 = new JPanel();
    private JButton jButton1 = new JButton();

    public MainFrame() {
        this.enableEvents(64L);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.contentPane = (JPanel)this.getContentPane();
        HTMLEditorKit htmlKit = new HTMLEditorKit();
        this.currentVersePanelBorder = new TitledBorder("");
        this.loginPanelBorder = new TitledBorder("");
        this.signSavePanelBorder = new TitledBorder("");
        this.currentRangePanelBorder = new TitledBorder("");
        this.leftPanelBorder = new TitledBorder("");
        this.titledBorder1 = new TitledBorder("");
        this.translatedTextEditor.setEditable(false);
        this.translatedTextEditor.setEditorKit(htmlKit);
        this.translatedTextEditor.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                MainFrame.this.translatedTextEditor_keyPressed(e);
            }
        });
        HTMLEditorKit htmlKit3 = new HTMLEditorKit();
        this.strongTextEditor.setEditable(false);
        this.strongTextEditor.setEditorKit(htmlKit3);
        HTMLEditorKit htmlKit2 = new HTMLEditorKit();
        this.greekTextEditor.setLineWrap(true);
        this.greekTextEditor.setEditable(false);
        this.greekTextEditor.setWrapStyleWord(true);
        this.greekTextEditor.addKeyListener(new MainFrame_greekTextEditor_keyAdapter(this));
        this.greekTextEditor.addMouseListener(new MainFrame_greekTextEditor_mouseAdapter(this));
        this.translatedTextEditorBorder = new TitledBorder("");
        this.greekTextEditorBorder = new TitledBorder("");
        this.strongTextEditorBorder = new TitledBorder("");
        this.translatedTextEditor.setFont(new Font("Monospaced", 0, 14));
        this.translatedTextEditor.setBorder(this.translatedTextEditorBorder);
        this.translatedTextEditor.addKeyListener(new MainFrame_translatedTextEditor_keyAdapter(this));
        this.translatedTextEditor.addMouseMotionListener(new MainFrame_translatedTextEditor_mouseMotionAdapter(this));
        this.translatedTextEditor.addMouseListener(new MainFrame_translatedTextEditor_mouseAdapter(this));
        this.translatedTextEditor.addHyperlinkListener(new Hyperactive());
        HTMLDocument doc = (HTMLDocument)this.translatedTextEditor.getDocument();
        doc.setPreservesUnknownTags(true);
        this.contentPane.setLayout(this.contentPaneLayout);
        this.setJMenuBar(this.jMenuBar1);
        ((Component)this).setSize(new Dimension(587, 564));
        this.setTitle("Module Editor");
        this.addKeyListener(new MainFrame_this_keyAdapter(this));
        this.leftPanel.setLayout(this.leftPanelLayout);
        this.textPanelLayout.setRows(3);
        this.textPanelLayout.setColumns(1);
        this.textPanel.setLayout(this.textPanelLayout);
        this.greekTextEditor.setBackground(Color.lightGray);
        this.greekTextEditor.setFont(new Font("Dialog", 0, 18));
        this.greekTextEditor.setBorder(this.greekTextEditorBorder);
        this.currentTagPanel.setLayout(this.currentTagPanelLayout);
        this.currentTagLabel.setText("Current Tag");
        this.tagPanel.setLayout(this.tagPanelLayout);
        this.currentTagText.setText("0");
        this.currentActionLabel.setText("Current Action:");
        this.actionLabel.setText("[none]");
        this.signSaveButton.setText("Sign & Save");
        this.signSaveButton.addActionListener(new MainFrame_signSaveButton_actionAdapter(this));
        this.guessTagButton.setText("Guess at all tags");
        this.guessTagButton.addActionListener(new MainFrame_guessTagButton_actionAdapter(this));
        this.rightPanel.setLayout(this.rightPanelLayout);
        this.userIDLabel.setText("UserID");
        this.loginButton.setText("Login");
        this.loginButton.addActionListener(new MainFrame_loginButton_actionAdapter(this));
        this.loginStatusLabel.setBorder(BorderFactory.createLineBorder(Color.black));
        this.loginStatusLabel.setText("Not Logged In");
        this.loginPanel.setLayout(this.loginPanelLayout);
        this.strongTextEditor.setBackground(Color.lightGray);
        this.strongTextEditor.setBorder(this.strongTextEditorBorder);
        this.rightPanel.setBorder(BorderFactory.createEtchedBorder());
        this.loginPanel.setBorder(this.loginPanelBorder);
        this.greekTextScroll.setHorizontalScrollBarPolicy(31);
        this.translatedTextScroll.setHorizontalScrollBarPolicy(31);
        this.aPanel.setLayout(this.aPanelLayout);
        this.currentVerseLabel.setText("Current Verse");
        this.currentVersePanel.setLayout(this.currentVersePanelLayout);
        this.currentVersePanelLayout.setColumns(1);
        this.currentVersePanelLayout.setRows(0);
        this.loadVerseButton.setText("Load");
        this.loadVerseButton.addActionListener(new MainFrame_loadVerseButton_actionAdapter(this));
        this.currentVersePanel.setBorder(this.currentVersePanelBorder);
        this.currentVerseText.addKeyListener(new MainFrame_currentVerseText_keyAdapter(this));
        this.strongPanel.setLayout(this.strongPanelLayout);
        this.strongPanelLayout.setColumns(1);
        this.strongPanelLayout.setRows(0);
        this.bPanel.setLayout(this.bPanelLayout);
        this.signSavePanel.setLayout(this.borderLayout1);
        this.signSavePanel.setBorder(this.signSavePanelBorder);
        this.contentPane.addKeyListener(new MainFrame_contentPane_keyAdapter(this));
        this.currentRangeLabel.setText("Current Range");
        this.currentRangePanel.setLayout(this.currentRangePanelLayout);
        this.cPanel.setLayout(this.cPanelLayout);
        this.currentRangePanelLayout.setColumns(1);
        this.currentRangePanelLayout.setRows(0);
        this.currentRangePanel.setBorder(this.currentRangePanelBorder);
        this.exportRangeButton.setText("Export");
        this.exportRangeButton.addActionListener(new MainFrame_exportRangeButton_actionAdapter(this));
        this.leftPanel.setBorder(this.leftPanelBorder);
        this.jMenu1.setText("File");
        this.jMenuItem1.setText("Exit");
        this.jMenuItem1.addActionListener(new MainFrame_jMenuItem1_actionAdapter(this));
        this.jMenu2.setText("Settings");
        this.jMenuItem2.setText("Proxy");
        this.jMenuItem2.addActionListener(new MainFrame_jMenuItem2_actionAdapter(this));
        this.jLabel1.setText("Notes");
        this.jPanel1.setLayout(this.borderLayout2);
        this.jPanel1.setBorder(this.titledBorder1);
        this.jMenu3.setText("Help");
        this.jMenuItem3.setText("Guidelines");
        this.jMenuItem3.addActionListener(new MainFrame_jMenuItem3_actionAdapter(this));
        this.jButton1.setText("Split");
        this.jButton1.addActionListener(new MainFrame_jButton1_actionAdapter(this));
        this.contentPane.add((Component)this.rightPanel, "East");
        this.rightPanel.add((Component)this.loginPanel, "North");
        this.loginPanel.add((Component)this.userIDLabel, null);
        this.loginPanel.add((Component)this.userIDText, null);
        this.loginPanel.add((Component)this.loginButton, null);
        this.loginPanel.add((Component)this.loginStatusLabel, null);
        this.rightPanel.add((Component)this.aPanel, "Center");
        this.aPanel.add((Component)this.currentRangePanel, "North");
        this.currentVersePanel.add((Component)this.currentVerseLabel, null);
        this.currentVersePanel.add((Component)this.currentVerseText, null);
        this.currentVersePanel.add((Component)this.loadVerseButton, null);
        this.currentVersePanel.add((Component)this.guessTagButton, null);
        this.aPanel.add((Component)this.bPanel, "Center");
        this.bPanel.add((Component)this.signSavePanel, "Center");
        this.strongPanel.add((Component)this.wordText, null);
        this.strongPanel.add((Component)this.strongText, null);
        this.strongPanel.add((Component)this.morphText, null);
        this.currentTagPanel.add((Component)this.jPanel2, "East");
        this.jPanel2.add((Component)this.jButton1, null);
        this.contentPane.add((Component)this.leftPanel, "Center");
        this.leftPanel.add((Component)this.currentTagPanel, "South");
        this.currentTagPanel.add((Component)this.tagPanel, "West");
        this.tagPanelLayout.setRows(3);
        this.tagPanelLayout.setColumns(1);
        this.loginPanelLayout.setRows(4);
        this.loginPanelLayout.setColumns(1);
        this.tagPanel.add((Component)this.currentTagLabel, null);
        this.tagPanel.add((Component)this.currentTagText, null);
        this.tagPanel.add((Component)this.currentActionPanel, null);
        this.currentActionPanel.add((Component)this.currentActionLabel, null);
        this.currentActionPanel.add((Component)this.actionLabel, null);
        this.currentTagPanel.add((Component)this.strongPanel, "Center");
        this.signSavePanel.add((Component)this.signSaveButton, "South");
        this.signSavePanel.add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.jLabel1, "North");
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.notesText, null);
        this.bPanel.add((Component)this.cPanel, "North");
        this.cPanel.add((Component)this.currentVersePanel, "North");
        this.currentRangePanel.add((Component)this.currentRangeLabel, null);
        this.currentRangePanel.add((Component)this.rangeText, null);
        this.currentRangePanel.add((Component)this.exportRangeButton, null);
        this.leftPanel.add((Component)this.textPanel, "Center");
        this.textPanel.add((Component)this.translatedTextScroll, null);
        this.translatedTextScroll.getViewport().add((Component)this.translatedTextEditor, null);
        this.textPanel.add((Component)this.greekTextScroll, null);
        this.greekTextScroll.getViewport().add((Component)this.greekTextEditor, null);
        this.textPanel.add((Component)this.strongTextScroll, null);
        this.strongTextScroll.getViewport().add((Component)this.strongTextEditor, null);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenuBar1.add(this.jMenu2);
        this.jMenuBar1.add(this.jMenu3);
        this.jMenu1.add(this.jMenuItem1);
        this.jMenu2.add(this.jMenuItem2);
        this.jMenu3.add(this.jMenuItem3);
        Highlighter h = this.greekTextEditor.getHighlighter();
        DefaultHighlighter.DefaultHighlightPainter hp = new DefaultHighlighter.DefaultHighlightPainter(Color.yellow);
        this.greekHighlight = h.addHighlight(0, 0, hp);
        this.loadPreferences();
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            this.savePreferences();
            System.exit(0);
        }
    }

    void signSaveButton_actionPerformed(ActionEvent e) {
        if (this.currentKey == null) {
            JOptionPane.showMessageDialog(this, "No key selected");
            return;
        }
        if (this.getUserID() == null) {
            JOptionPane.showMessageDialog(this, "Not logged in");
            return;
        }
        String entry = this.getRawEntry();
        StringBuffer result = new StringBuffer();
        if (!this.localKJV) {
            this.callServer(String.valueOf(String.valueOf(new StringBuffer("action=w&key=").append(URLEncoder.encode(this.currentKey)).append("&uid=").append(this.userID).append("&ltok=").append(this.loginToken).append("&mod=KJV2003&text=").append(URLEncoder.encode(entry)))), result);
        } else {
            try {
                FileOutputStream fos = new FileOutputStream("entry.txt");
                fos.write(entry.getBytes());
                fos.close();
                this.callLocalAgent(new String[]{this.util, "f", "KJV2003", this.currentKey, "entry.txt"}, result, false);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        if (result.length() > 1) {
            this.stripChar(result, '\n');
            this.stripChar(result, '\r');
            this.loadVerse(result.toString());
        } else {
            this.login(null);
            JOptionPane.showMessageDialog(this, "Unable to save edits to the server, try to re-login.");
        }
    }

    void loadPreferences() {
        Properties props = new Properties();
        try {
            props.load(new FileInputStream("ModEdit.properties"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.localKJV = props.getProperty("localKJV", "false").equalsIgnoreCase("true");
        this.localTR = props.getProperty("localTR", "false").equalsIgnoreCase("true");
        this.localThayer = props.getProperty("localThayer", "false").equalsIgnoreCase("true");
        this.localImages = props.getProperty("localImages", "false").equalsIgnoreCase("true");
        if (this.localImages) {
            startTag2 = "\"><img border=0 src=\"file:images/starttag";
            endTag2 = "\"><img border=0 src=\"file:images/endtag";
        }
        this.rangeText.setText(props.getProperty("currentRange", "jn"));
        this.userIDText.setText(props.getProperty("userID", ""));
        this.useProxy = props.getProperty("useProxy", "false").equals("true");
        this.proxyHost = props.getProperty("proxyHost", "[none]");
        this.proxyPort = props.getProperty("proxyPort", "8080");
        this.loadVerse(props.getProperty("lastVerse", "jn 1:1"));
        if (!this.localKJV) {
            this.exportRangeButton.setVisible(false);
        }
    }

    void savePreferences() {
        Properties props = new Properties();
        props.setProperty("localKJV", this.localKJV ? "true" : "false");
        props.setProperty("localTR", this.localTR ? "true" : "false");
        props.setProperty("localThayer", this.localThayer ? "true" : "false");
        props.setProperty("localImages", this.localImages ? "true" : "false");
        props.setProperty("currentRange", this.rangeText.getText());
        props.setProperty("userID", this.userIDText.getText());
        props.setProperty("lastVerse", this.currentKey);
        props.setProperty("proxyHost", this.proxyHost);
        props.setProperty("proxyPort", this.proxyPort);
        props.setProperty("useProxy", this.useProxy ? "true" : "false");
        try {
            props.store(new FileOutputStream("ModEdit.properties"), "ModEdit Properties");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void loadTextArea(JTextArea control, StringBuffer agentResult) {
        try {
            StringBuffer newText = agentResult;
            this.stripTags(newText);
            int pos = newText.toString().indexOf(124);
            if (pos > -1) {
                newText.delete(0, pos + 1);
            }
            control.setText(newText.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void loadHTML(JEditorPane control, StringBuffer agentResult) {
        try {
            StringBuffer newText = agentResult;
            String htmlstr = newText.toString();
            int pos = newText.toString().indexOf(124);
            if (pos > -1) {
                newText.delete(0, pos + 1);
            }
            htmlstr = newText.toString();
            newText.insert(0, "<html>");
            int tagPos = newText.toString().indexOf("<br />");
            while (tagPos > -1) {
                int endPos = newText.toString().indexOf(62, tagPos + 1);
                newText.delete(tagPos, endPos + 1);
                if (tagPos < newText.length()) {
                    newText.insert(tagPos, "<br>");
                }
                tagPos = newText.toString().indexOf("<br />");
            }
            htmlstr = newText.toString();
            this.setHTML(control, newText);
            control.setCaretPosition(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int callLocalAgent(String[] command, StringBuffer result, boolean html) {
        int retVal = -1;
        try {
            int len;
            Process p = Runtime.getRuntime().exec(command);
            InputStream is = p.getInputStream();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            BufferedInputStream bis = new BufferedInputStream(is);
            byte[] inBuf = new byte[8192];
            do {
                if ((len = bis.read(inBuf, 0, 8192)) == -1) continue;
                bos.write(inBuf, 0, len);
            } while (len != -1);
            StringBuffer newText = new StringBuffer(new String(bos.toByteArray(), "UTF-8"));
            result.append(newText.toString());
            StringBuffer crlf = new StringBuffer("  ");
            crlf.setCharAt(0, '\r');
            crlf.setCharAt(1, '\n');
            StringBuffer lf = new StringBuffer(" ");
            lf.setCharAt(0, '\n');
            this.replaceString(result, crlf.toString(), lf.toString());
            this.replaceString(result, "\n", html ? "<br>" : "\n ");
            retVal = p.waitFor();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retVal;
    }

    int callServer(String command, StringBuffer result) {
        try {
            int len;
            String lookupURL = "http://www.crosswire.org/sword/kjv2003/modedit.jsp?".concat(String.valueOf(String.valueOf(command)));
            URLConnection connection = new URL(lookupURL).openConnection();
            InputStream is = connection.getInputStream();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            BufferedInputStream bis = new BufferedInputStream(is);
            byte[] inBuf = new byte[8192];
            do {
                if ((len = bis.read(inBuf, 0, 8192)) == -1) continue;
                bos.write(inBuf, 0, len);
            } while (len != -1);
            StringBuffer newText = new StringBuffer(new String(bos.toByteArray(), "UTF-8"));
            result.append(newText.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    public void exportRange(String key, String fileName) {
        try {
            StringBuffer agentResult = new StringBuffer();
            this.callLocalAgent(new String[]{this.util, "e", "KJV2003", key}, agentResult, false);
            ZipOutputStream zstream = new ZipOutputStream(new FileOutputStream(fileName));
            zstream.putNextEntry(new ZipEntry("key"));
            zstream.write(key.getBytes());
            zstream.putNextEntry(new ZipEntry("nt"));
            this.copyFile(zstream, "nt");
            zstream.putNextEntry(new ZipEntry("nt.vss"));
            this.copyFile(zstream, "nt.vss");
            zstream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void copyFile(OutputStream os, String fileName) {
        try {
            int len;
            FileInputStream fin = new FileInputStream(fileName);
            byte[] buffer = new byte[20000];
            while ((len = fin.read(buffer)) > 0) {
                os.write(buffer, 0, len);
            }
            fin.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void showStrongs() {
        TagInfo tagInfo = (TagInfo)this.tags.get(Integer.toString(this.getCurrentTag()));
        if (tagInfo == null) {
            return;
        }
        try {
            StringBuffer agentResult = new StringBuffer();
            if (tagInfo.thayerCache.length() < 1) {
                if (!this.localThayer) {
                    this.callServer("action=h&mod=Thayer&key=".concat(String.valueOf(String.valueOf(tagInfo.strong))), agentResult);
                } else {
                    this.callLocalAgent(new String[]{this.util, "h", "Thayer", tagInfo.strong}, agentResult, true);
                }
                tagInfo.thayerCache = agentResult.toString();
            }
            agentResult = new StringBuffer(tagInfo.thayerCache);
            this.loadHTML(this.strongTextEditor, agentResult);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.strongText.setText(tagInfo.strong);
        this.morphText.setText(tagInfo.morph);
        this.wordText.setText(tagInfo.word);
        try {
            this.greekTextEditor.getHighlighter().changeHighlight(this.greekHighlight, tagInfo.start, tagInfo.end);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void translatedTextEditor_mouseClicked(MouseEvent e) {
    }

    void translatedTextEditor_mouseDragged(MouseEvent e) {
        Point clickPoint = e.getPoint();
        int position = this.translatedTextEditor.viewToModel(clickPoint);
        boolean sizeTag = false;
        if (!this.getCurrentAction().equals("[none]")) {
            if (this.getCurrentAction().equals("SizeTag")) {
                sizeTag = true;
            }
            if (position != this.currentCaret) {
                this.currentCaret = position;
                this.moveTag(this.getCurrentTag(), position, sizeTag);
            }
        }
    }

    void stripChar(StringBuffer buf, char ch) {
        int pos = buf.toString().indexOf(ch);
        while (pos > -1) {
            buf.deleteCharAt(pos);
            pos = buf.toString().indexOf(ch);
        }
    }

    void replaceString(StringBuffer buf, String ch, String r) {
        int pos = buf.toString().indexOf(ch);
        while (pos > -1) {
            buf.replace(pos, pos + ch.length(), r);
            pos = buf.toString().indexOf(ch, pos + 1);
        }
    }

    void replaceChar(StringBuffer buf, char ch, char r) {
        int pos = buf.toString().indexOf(ch);
        while (pos > -1) {
            buf.setCharAt(pos, r);
            pos = buf.toString().indexOf(ch);
        }
    }

    void stripJunk(StringBuffer html) {
        int pos = html.toString().indexOf(10);
        while (pos > -1) {
            html.deleteCharAt(pos);
            while (pos < html.length() && html.charAt(pos) == ' ') {
                html.deleteCharAt(pos);
            }
            pos = html.toString().indexOf(10);
        }
    }

    StringBuffer getHTML(JEditorPane editor) {
        HTMLDocument doc = (HTMLDocument)editor.getDocument();
        StringWriter writer = new StringWriter();
        try {
            editor.getEditorKit().write(writer, (Document)doc, 0, doc.getLength());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        StringBuffer html = writer.getBuffer();
        this.replaceString(html, "&#8217;", "'");
        this.stripJunk(html);
        return html;
    }

    void setHTML(JEditorPane editor, StringBuffer html) {
        HTMLDocument doc = (HTMLDocument)editor.getDocument();
        try {
            editor.setText("");
            editor.getEditorKit().read(new StringReader(html.toString()), (Document)doc, 0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void slideTag(int offset, boolean sizeTag) {
        this.slideTag(this.getCurrentTag(), offset, sizeTag, "y", "y");
    }

    String getStartTag(TagInfo tag, String color) {
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(startTag1))).append(tag.id).append(startTag2).append(color).append(tag.type).append(startTag3)));
    }

    String getEndTag(TagInfo tag, String color) {
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(endTag1))).append(tag.id).append(endTag2).append(color).append(tag.type).append(endTag3)));
    }

    void slideTag(int tagNum, int offset, boolean sizeTag, String startColor, String endColor) {
        this.slideTag(tagNum, offset, sizeTag, startColor, endColor, false);
    }

    void slideTag(int tagNum, int offset, boolean sizeTag, String startColor, String endColor, boolean delete) {
        this.slideTag(tagNum, offset, sizeTag, startColor, endColor, delete, -1);
    }

    void slideTag(int tagNum, int offset, boolean sizeTag, String startColor, String endColor, boolean delete, int addSplitID) {
        int end;
        String endTag;
        TagInfo tagInfo = (TagInfo)this.tags.get(Integer.toString(tagNum));
        if (tagInfo == null) {
            return;
        }
        String startTag = delete ? "" : this.getStartTag(tagInfo, startColor);
        String string = endTag = delete ? "" : this.getEndTag(tagInfo, endColor);
        if (addSplitID > -1) {
            TagInfo splitInfo = (TagInfo)this.tags.get(Integer.toString(addSplitID));
            endTag = String.valueOf(String.valueOf(endTag)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.getStartTag(splitInfo, "r"))).concat(String.valueOf(String.valueOf(this.getEndTag(splitInfo, "r")))))));
        }
        String startSearch = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(startTag1))).append(Integer.toString(tagNum)).append("\">")));
        String endSearch = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(endTag1))).append(Integer.toString(tagNum)).append("\">")));
        boolean addNewImage = false;
        StringBuffer html = this.getHTML(this.translatedTextEditor);
        String htmlstr = html.toString();
        int tagStart = html.toString().indexOf(startSearch);
        int endStart = html.toString().indexOf(endSearch);
        if (!sizeTag) {
            if (tagStart >= 0) {
                addNewImage = true;
                end = html.toString().indexOf(62, tagStart + 1);
                end = html.toString().indexOf(62, end + 1);
                end = html.toString().indexOf(62, end + 1);
                if (offset != 0) {
                    html.replace(tagStart, end + 1, "$$$");
                } else {
                    html.replace(tagStart, end + 1, startTag);
                }
            } else {
                addNewImage = false;
            }
        }
        htmlstr = html.toString();
        endStart = html.toString().indexOf(endSearch);
        if (addNewImage || sizeTag) {
            if (endStart >= 0) {
                end = html.toString().indexOf(62, endStart + 1);
                end = html.toString().indexOf(62, end + 1);
                end = html.toString().indexOf(62, end + 1);
                if (addNewImage) {
                    if (offset != 0) {
                        html.delete(endStart, end + 1);
                    } else {
                        html.replace(endStart, end + 1, endTag);
                    }
                } else {
                    html.replace(endStart, end + 1, "$$$");
                }
                addNewImage = true;
            } else {
                addNewImage = false;
            }
        }
        htmlstr = html.toString();
        int targetStart = html.toString().indexOf("$$$");
        while (offset != 0 && targetStart > -1) {
            char moveChar;
            if (offset > 0) {
                if (targetStart + 3 >= html.length()) break;
                moveChar = html.charAt(targetStart + 3);
                if (moveChar != '<' && moveChar != '{') {
                    html.deleteCharAt(targetStart + 3);
                    html.insert(targetStart, moveChar);
                } else {
                    if (sizeTag) break;
                    if (moveChar == '<') {
                        int end2;
                        String tagKey = null;
                        int pos = html.toString().indexOf(startTag1, targetStart);
                        if (pos == targetStart + 3 && (end2 = html.toString().indexOf(34, pos + startTag1.length())) > -1) {
                            tagKey = html.substring(pos + startTag1.length(), end2);
                            pos = html.toString().indexOf(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(endTag1))).append(tagKey).append("\""))), pos);
                            if (pos > -1) {
                                end2 = html.toString().indexOf(62, pos);
                                end2 = html.toString().indexOf(62, end2 + 1);
                                end2 = html.toString().indexOf(62, end2 + 1);
                                if (++end2 < html.length()) {
                                    html.insert(end2, "$$$");
                                    html.delete(targetStart, targetStart + 3);
                                }
                            }
                        }
                    } else if (moveChar == '{') {
                        int end3 = html.toString().indexOf(125, targetStart + 3);
                        if (++end3 < html.length()) {
                            html.insert(end3, "$$$");
                            html.delete(targetStart, targetStart + 3);
                        }
                    }
                }
                --offset;
            }
            if (offset >= 0) continue;
            if (targetStart - 1 < 0) break;
            moveChar = html.charAt(targetStart - 1);
            if (moveChar != '>' && moveChar != '}') {
                html.deleteCharAt(targetStart - 1);
                html.insert(targetStart + 2, moveChar);
            } else {
                int pos;
                if (sizeTag) break;
                if (moveChar == '>') {
                    String tagKey = null;
                    int pos2 = html.toString().lastIndexOf(endTag1, targetStart);
                    if (pos2 > -1) {
                        int end4 = html.toString().indexOf(62, pos2);
                        end4 = html.toString().indexOf(62, end4 + 1);
                        end4 = html.toString().indexOf(62, end4 + 1);
                        if (end4 == targetStart - 1 && (end4 = html.toString().indexOf(34, pos2 + endTag1.length())) > -1) {
                            tagKey = html.substring(pos2 + startTag1.length(), end4);
                            pos2 = html.toString().lastIndexOf(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(startTag1))).append(tagKey).append("\""))), pos2);
                            if (pos2 > -1) {
                                html.delete(targetStart, targetStart + 3);
                                html.insert(pos2, "$$$");
                            }
                        }
                    }
                } else if (moveChar == '}' && (pos = html.toString().lastIndexOf(123, targetStart)) > -1) {
                    html.delete(targetStart, targetStart + 3);
                    html.insert(pos, "$$$");
                }
            }
            ++offset;
        }
        htmlstr = html.toString();
        targetStart = html.toString().indexOf("$$$");
        if (targetStart >= 0) {
            if (addNewImage) {
                html.replace(targetStart, targetStart + 3, sizeTag ? endTag : String.valueOf(String.valueOf(startTag)).concat(String.valueOf(String.valueOf(endTag))));
            } else {
                html.delete(targetStart, targetStart + 3);
            }
        }
        htmlstr = html.toString();
        this.setHTML(this.translatedTextEditor, html);
    }

    int getTagFromPosition(int offset) {
        int position = offset;
        int retVal = 0;
        this.translatedTextEditor.setSelectionEnd(this.translatedTextEditor.getSelectionStart());
        if (position != this.currentCaret) {
            int tagStart;
            int endStart;
            this.currentCaret = position;
            String startSearch = startTag1;
            String endSearch = endTag1;
            HTMLDocument doc = (HTMLDocument)this.translatedTextEditor.getDocument();
            try {
                this.translatedTextEditor.getEditorKit().read(new StringReader("$$$"), (Document)doc, position);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            StringBuffer html = this.getHTML(this.translatedTextEditor);
            String htmlstr = html.toString();
            int targetStart = html.toString().indexOf("$$$");
            if (targetStart > -1) {
                html.delete(targetStart, targetStart + 3);
            }
            if ((endStart = html.toString().indexOf(endSearch, targetStart)) < (tagStart = html.toString().indexOf(startSearch, targetStart))) {
                int begin = endStart + endSearch.length();
                int end = html.toString().indexOf(34, begin);
                if (end > endStart) {
                    String tagNum = html.substring(begin, end);
                    retVal = Integer.parseInt(tagNum);
                }
            }
            this.setHTML(this.translatedTextEditor, html);
        }
        return retVal;
    }

    void moveTag(int tagNum, int position, boolean sizeTag) {
        int end;
        this.translatedTextEditor.setSelectionEnd(this.translatedTextEditor.getSelectionStart());
        TagInfo tagInfo = (TagInfo)this.tags.get(Integer.toString(tagNum));
        String startTag = this.getStartTag(tagInfo, "y");
        String endTag = this.getEndTag(tagInfo, "y");
        String startSearch = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(startTag1))).append(Integer.toString(tagNum)).append("\">")));
        String endSearch = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(endTag1))).append(Integer.toString(tagNum)).append("\">")));
        boolean addNewImage = false;
        HTMLDocument doc = (HTMLDocument)this.translatedTextEditor.getDocument();
        try {
            this.translatedTextEditor.getEditorKit().read(new StringReader("$$$"), (Document)doc, position);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        StringBuffer html = this.getHTML(this.translatedTextEditor);
        String htmlstr = html.toString();
        int targetStart = html.toString().indexOf("$$$");
        int tagStart = html.toString().indexOf(startSearch);
        int endStart = html.toString().indexOf(endSearch);
        boolean beforeStart = false;
        if (targetStart < tagStart) {
            beforeStart = true;
        }
        if (!sizeTag) {
            if (tagStart >= 0) {
                addNewImage = true;
                end = html.toString().indexOf(62, tagStart + 1);
                end = html.toString().indexOf(62, end + 1);
                end = html.toString().indexOf(62, end + 1);
                html.delete(tagStart, end + 1);
            } else {
                addNewImage = false;
            }
        }
        endStart = html.toString().indexOf(endSearch);
        if (addNewImage || sizeTag && !beforeStart) {
            if (endStart >= 0) {
                addNewImage = true;
                end = html.toString().indexOf(62, endStart + 1);
                end = html.toString().indexOf(62, end + 1);
                end = html.toString().indexOf(62, end + 1);
                html.delete(endStart, end + 1);
            } else {
                addNewImage = false;
            }
        }
        targetStart = html.toString().indexOf("$$$");
        htmlstr = html.toString();
        if (targetStart >= 0) {
            if (addNewImage) {
                html.replace(targetStart, targetStart + 3, sizeTag ? endTag : String.valueOf(String.valueOf(startTag)).concat(String.valueOf(String.valueOf(endTag))));
            } else {
                html.delete(targetStart, targetStart + 3);
            }
        }
        htmlstr = html.toString();
        this.setHTML(this.translatedTextEditor, html);
    }

    void translatedTextEditor_keyTyped(KeyEvent e) {
    }

    void setCurrentAction(int tag, String action) {
        int lastTag = this.getCurrentTag();
        boolean changedTag = false;
        if (lastTag != tag) {
            changedTag = true;
            this.slideTag(this.getCurrentTag(), 0, false, "g", "g");
            this.slideTag(tag, 0, false, "y", "y");
        }
        this.currentTagText.setText(Integer.toString(tag));
        if ((!this.getCurrentAction().equals("MoveTag") || changedTag) && action.equals("MoveTag")) {
            this.slideTag(this.getCurrentTag(), 0, false, "y", "y");
        } else if ((!this.getCurrentAction().equals("SizeTag") || changedTag) && action.equals("SizeTag")) {
            this.slideTag(this.getCurrentTag(), 0, false, "g", "y");
        } else if ((!this.getCurrentAction().equals("[none]") || changedTag) && action.equals("[none]")) {
            this.slideTag(this.getCurrentTag(), 0, false, "g", "g");
        }
        this.actionLabel.setText(action);
        if (changedTag) {
            this.showStrongs();
        }
    }

    public String getCurrentAction() {
        return this.actionLabel.getText();
    }

    public int getCurrentTag() {
        return Integer.parseInt(this.currentTagText.getText());
    }

    void translatedTextEditor_keyPressed(KeyEvent e) {
        this.handleKeyboard(e);
    }

    void handleKeyboard(KeyEvent e) {
        boolean sizeTag = true;
        if (this.getCurrentAction().equals("MoveTag")) {
            sizeTag = false;
        }
        if (!this.getCurrentAction().equals("[none]")) {
            if (e.getKeyCode() == 37) {
                this.slideTag(-1, sizeTag);
            } else if (e.getKeyCode() == 39) {
                this.slideTag(1, sizeTag);
            }
        }
        if (e.getKeyCode() == 9) {
            if (e.isShiftDown()) {
                this.previousTag();
            } else {
                this.nextTag();
            }
        } else if (e.getKeyCode() == 38) {
            this.previousTag();
        } else if (e.getKeyCode() == 40) {
            this.nextTag();
        } else if (e.getKeyCode() == 32) {
            if (this.getCurrentAction().equals("MoveTag")) {
                this.setCurrentAction(this.getCurrentTag(), "SizeTag");
            } else if (this.getCurrentAction().equals("SizeTag")) {
                this.setCurrentAction(this.getCurrentTag(), "[none]");
            } else if (this.getCurrentAction().equals("[none]")) {
                this.setCurrentAction(this.getCurrentTag(), "MoveTag");
            }
        }
    }

    public void loadStrongsTable(String key) {
        try {
            String line;
            StringBuffer text = new StringBuffer();
            if (!this.localTR) {
                this.callServer(String.valueOf(String.valueOf(new StringBuffer("action=a&key=").append(URLEncoder.encode(key)).append("&mod=TR"))), text);
            } else {
                this.callLocalAgent(new String[]{this.util, "a", "TR", key}, text, false);
            }
            BufferedReader br = new BufferedReader(new StringReader(text.toString()));
            this.tags = new Hashtable();
            while ((line = br.readLine()) != null) {
                StringBuffer sb;
                String[] entry = new String[4];
                int pos = line.indexOf(124);
                int start = 0;
                int type = 0;
                while (pos > -1) {
                    sb = new StringBuffer(line.substring(start, pos));
                    this.stripTags(sb);
                    entry[type] = sb.toString().trim();
                    ++type;
                    start = pos + 1;
                    pos = line.indexOf(124, start);
                }
                sb = new StringBuffer(line.substring(start, line.length()));
                this.stripTags(sb);
                entry[type] = sb.toString().trim();
                if (type < 2) continue;
                entry[1] = new Integer(entry[1]).toString();
                if (!entry[0].equals("Word")) continue;
                TagInfo tag = (TagInfo)this.tags.get(entry[1]);
                if (tag == null) {
                    tag = new TagInfo(entry[1]);
                    this.tags.put(entry[1], tag);
                }
                if (entry[2].equals("Morph")) {
                    tag.morph = entry[3];
                    if (tag.morph.startsWith("V")) {
                        tag.type = "verb";
                    }
                }
                if (entry[2].equals("MorphClass")) {
                    tag.morphClass = entry[3];
                }
                if (entry[2].equals("Strongs")) {
                    tag.strong = entry[3].substring(1, entry[3].length());
                    if (tag.strong.equals("3588")) {
                        tag.type = "art";
                    }
                }
                if (!entry[2].equals("Text")) continue;
                tag.word = entry[3];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadTranslationFrequencies(TagInfo tag) {
        try {
            String line;
            StringBuffer text = new StringBuffer();
            if (!this.localThayer) {
                this.callServer(String.valueOf(String.valueOf(new StringBuffer("action=a&key=").append(URLEncoder.encode(tag.strong)).append("&mod=Thayer"))), text);
            } else {
                this.callLocalAgent(new String[]{this.util, "a", "Thayer", tag.strong}, text, false);
            }
            BufferedReader br = new BufferedReader(new StringReader(text.toString()));
            tag.translations = new Hashtable();
            while ((line = br.readLine()) != null) {
                try {
                    StringBuffer sb;
                    String[] entry = new String[4];
                    int pos = line.indexOf(124);
                    int start = 0;
                    int type = 0;
                    while (pos > -1) {
                        sb = new StringBuffer(line.substring(start, pos));
                        this.stripTags(sb);
                        entry[type] = sb.toString().trim();
                        ++type;
                        start = pos + 1;
                        pos = line.indexOf(124, start);
                    }
                    sb = new StringBuffer(line.substring(start, line.length()));
                    this.stripTags(sb);
                    entry[type] = sb.toString().trim();
                    if (type < 2) continue;
                    entry[1] = new Integer(entry[1]).toString();
                    if (!entry[0].equals("AVPhrase")) continue;
                    TransInfo trans = (TransInfo)tag.translations.get(entry[1]);
                    if (trans == null) {
                        trans = new TransInfo(entry[1]);
                        tag.translations.put(entry[1], trans);
                    }
                    if (entry[2].equals("Phrase")) {
                        trans.english = entry[3];
                    }
                    if (entry[2].equals("Alt")) {
                        trans.english2 = entry[3];
                    }
                    if (entry[2].equals("CompoundedWith")) {
                        trans.compoundedWith = entry[3];
                    }
                    if (!entry[2].equals("Frequency")) continue;
                    trans.frequency = Integer.parseInt(entry[3]);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void computeTagOffsets() {
        Object[] tagKeys = this.tags.keySet().toArray();
        Arrays.sort(tagKeys, new Comparator(){

            public int compare(Object o1, Object o2) {
                return Integer.parseInt((String)o1) - Integer.parseInt((String)o2);
            }
        });
        String greek = this.greekTextEditor.getText();
        int pos = 0;
        for (int i = 0; i < tagKeys.length; ++i) {
            TagInfo tag = (TagInfo)this.tags.get(tagKeys[i]);
            int start = greek.indexOf(tag.word, pos);
            if (start <= -1) continue;
            tag.start = start;
            pos = tag.end = start + tag.word.length();
        }
    }

    public void confirmAllStrongs(StringBuffer text) {
        Object[] tagKeys = this.tags.keySet().toArray();
        Arrays.sort(tagKeys, new Comparator(){

            public int compare(Object o1, Object o2) {
                return Integer.parseInt((String)o1) - Integer.parseInt((String)o2);
            }
        });
        for (int i = 0; i < tagKeys.length; ++i) {
            TagInfo tagInfo = (TagInfo)this.tags.get(tagKeys[i]);
            boolean found = false;
            int pos = text.toString().indexOf(String.valueOf(String.valueOf(new StringBuffer("<w_src=\"").append(tagKeys[i]).append("\""))));
            boolean splitHandled = false;
            while (pos > -1) {
                tagInfo = (TagInfo)this.tags.get(tagKeys[i]);
                int end = text.toString().indexOf(">", pos);
                if (end > -1) {
                    String tagText = text.substring(pos, end + 1);
                    int split = tagText.indexOf("splitID=\"");
                    if (split > -1 && !splitHandled) {
                        tagInfo = this.addSplitTag(Integer.parseInt(tagInfo.id), false);
                        int pos1 = text.toString().indexOf("\"", pos + 1);
                        int end1 = text.toString().indexOf("\"", pos1 + 1);
                        text.replace(pos1 + 1, end1, tagInfo.id);
                        splitHandled = true;
                    }
                    int endWord = text.toString().indexOf("</w>", end);
                    end = text.toString().indexOf(">", pos);
                    if (endWord > -1) {
                        text.replace(endWord, endWord + 4, this.getEndTag(tagInfo, "r"));
                        text.replace(pos, end + 1, this.getStartTag(tagInfo, "r"));
                        found = true;
                    }
                }
                pos = text.toString().indexOf(String.valueOf(String.valueOf(new StringBuffer("<w_src=\"").append(tagKeys[i]).append("\""))), pos + 1);
            }
            if (found) continue;
            text.append(this.getStartTag(tagInfo, "r"));
            text.append(this.getEndTag(tagInfo, "r"));
        }
    }

    public void loadVerse(String key) {
        try {
            int end;
            StringBuffer text = new StringBuffer();
            if (!this.localKJV) {
                this.callServer(String.valueOf(String.valueOf(new StringBuffer("action=r&key=").append(URLEncoder.encode(key)).append("&mod=KJV2003"))), text);
            } else {
                this.callLocalAgent(new String[]{this.util, "r", "KJV2003", key}, text, false);
            }
            String htmlstr = text.toString();
            this.stripChar(text, '\n');
            this.stripChar(text, '\r');
            if (text.charAt(text.length() - 1) == ' ') {
                text.setLength(text.length() - 1);
            }
            htmlstr = text.toString();
            int pos = text.toString().indexOf(124);
            if (pos > -1) {
                key = text.substring(0, pos);
                text.delete(0, pos + 1);
            }
            this.notesText.setText("");
            pos = text.toString().indexOf("<note type=\"strongsMarkup\"");
            while (pos > -1) {
                end = text.toString().indexOf(62, pos + 1);
                if (end > -1) {
                    text.delete(pos, end + 1);
                }
                if ((end = text.toString().indexOf("</note>", pos)) > -1) {
                    String note = text.substring(pos, end);
                    note = URLDecoder.decode(note);
                    this.notesText.setText(String.valueOf(String.valueOf(this.notesText.getText())).concat(String.valueOf(String.valueOf(note))));
                    text.delete(pos, end + 7);
                }
                pos = text.toString().indexOf("<resp ");
            }
            pos = text.toString().indexOf("<resp ");
            while (pos > -1) {
                end = text.toString().indexOf(62, pos + 1);
                if (end > -1) {
                    text.delete(pos, end + 1);
                }
                pos = text.toString().indexOf("<resp ");
            }
            htmlstr = text.toString();
            this.replaceChar(text, ' ', '_');
            htmlstr = text.toString();
            this.loadStrongsTable(key);
            StringBuffer agentResult = new StringBuffer();
            if (!this.localTR) {
                this.callServer(String.valueOf(String.valueOf(new StringBuffer("action=h&key=").append(URLEncoder.encode(key)).append("&mod=TR"))), agentResult);
            } else {
                this.callLocalAgent(new String[]{this.util, "h", "TR", key}, agentResult, true);
            }
            this.loadTextArea(this.greekTextEditor, agentResult);
            this.computeTagOffsets();
            text.insert(0, "<HTML><BODY>");
            this.confirmAllStrongs(text);
            htmlstr = text.toString();
            text.append("</BODY></HTML>");
            this.setHTML(this.translatedTextEditor, text);
            this.translatedTextEditor.setCaretPosition(0);
            this.currentKey = key;
            this.currentVerseText.setText(this.currentKey);
            this.setCurrentAction(0, "[none]");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void replaceTagsWithHolders(StringBuffer newText) {
        int endPos;
        String startSearch = startTag1;
        String endSearch = endTag1;
        int tagPos = newText.toString().indexOf(endSearch);
        while (tagPos > -1) {
            endPos = newText.toString().indexOf(62, tagPos + endSearch.length() + 1);
            newText.delete(tagPos, endPos + 1);
            newText.insert(tagPos, '|');
            tagPos = newText.toString().indexOf(endSearch);
        }
        tagPos = newText.toString().indexOf(startSearch);
        while (tagPos > -1) {
            endPos = newText.toString().indexOf(62, tagPos + startSearch.length() + 1);
            newText.delete(tagPos, endPos + 1);
            newText.insert(tagPos, '|');
            tagPos = newText.toString().indexOf(startSearch);
        }
    }

    void stripTags(StringBuffer newText) {
        int tagPos = newText.toString().indexOf(60);
        while (tagPos > -1) {
            int endPos = newText.toString().indexOf(62, tagPos + 1);
            newText.delete(tagPos, endPos + 1);
            if (tagPos < newText.length()) {
                newText.insert(tagPos, ' ');
            }
            tagPos = newText.toString().indexOf(60);
        }
    }

    void loadVerseButton_actionPerformed(ActionEvent e) {
        this.loadVerse(this.currentVerseText.getText());
    }

    void currentVerseText_keyTyped(KeyEvent e) {
    }

    void this_keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.loadVerse(this.currentVerseText.getText());
        } else if (e.getKeyCode() == 9) {
            this.nextTag();
        }
    }

    void guessTagButton_actionPerformed(ActionEvent e) {
        this.guessTagPositions();
    }

    public void guessTagPositions() {
        int i;
        Object[] tagKeys = this.tags.keySet().toArray();
        Arrays.sort(tagKeys, new Comparator(){

            public int compare(Object o1, Object o2) {
                return Integer.parseInt((String)o1) - Integer.parseInt((String)o2);
            }
        });
        for (i = 0; i < tagKeys.length; ++i) {
            this.moveTag(Integer.parseInt((String)tagKeys[i]), 1, false);
        }
        for (i = 0; i < tagKeys.length; ++i) {
            TagInfo tagInfo = (TagInfo)this.tags.get(tagKeys[i]);
            if (tagInfo.strong.equals("3588")) continue;
            String text = this.translatedTextEditor.getText();
            StringBuffer sb = new StringBuffer(text);
            this.replaceTagsWithHolders(sb);
            this.stripTags(sb);
            this.stripJunk(sb);
            this.stripChar(sb, ' ');
            this.replaceChar(sb, '_', ' ');
            text = sb.toString().trim().toUpperCase();
            this.loadTranslationFrequencies(tagInfo);
            Object[] transKeys = tagInfo.translations.keySet().toArray();
            Arrays.sort(transKeys, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return Integer.parseInt((String)o1) - Integer.parseInt((String)o2);
                }
            });
            TransInfo best = null;
            for (int j = 0; j < transKeys.length; ++j) {
                TransInfo ti = (TransInfo)tagInfo.translations.get(transKeys[j]);
                if (ti.compoundedWith != null) continue;
                for (int k = 0; k < 2; ++k) {
                    String english;
                    String string = english = k > 0 ? ti.english2 : ti.english;
                    if (english == null || (english = english.toUpperCase()).equalsIgnoreCase("MISC")) continue;
                    int attempt = text.indexOf(english);
                    while (attempt > -1) {
                        if (this.getTagFromPosition(attempt + 1) == 0) {
                            if (attempt > 0 && Character.isLetter(text.charAt(attempt - 1))) {
                                attempt = text.indexOf(english, attempt + 1);
                                continue;
                            }
                            if (best != null) {
                                if (english.length() <= best.english.length()) {
                                    attempt = text.indexOf(english, attempt + 1);
                                    continue;
                                }
                                if (attempt > best.start + 7) {
                                    attempt = text.indexOf(english, attempt + 1);
                                    continue;
                                }
                                ti.wholeWord = true;
                                try {
                                    if (Character.isLetter(text.charAt(attempt + best.english.length()))) {
                                        ti.wholeWord = false;
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (!ti.wholeWord && best.wholeWord) {
                                    attempt = text.indexOf(english, attempt + 1);
                                    continue;
                                }
                            }
                            best = ti;
                            best.english = english;
                            best.start = attempt;
                            best.wholeWord = true;
                            try {
                                if (Character.isLetter(text.charAt(attempt + best.english.length()))) {
                                    best.wholeWord = false;
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        attempt = text.indexOf(english, attempt + 1);
                    }
                }
            }
            if (best == null) continue;
            int end = best.start + best.english.length();
            if (best.start >= 4 && text.substring(best.start - 4, best.start).equalsIgnoreCase("the ") && best.start - 5 > -1 && !Character.isLetter(text.charAt(best.start - 5))) {
                best.start -= 4;
            }
            if (best.start >= 2 && text.substring(best.start - 2, best.start).equalsIgnoreCase("a ") && best.start - 3 > -1 && !Character.isLetter(text.charAt(best.start - 3))) {
                best.start -= 2;
            }
            if (best.start >= 3 && tagInfo.morph.indexOf(71) > -1 && text.substring(best.start - 3, best.start).equalsIgnoreCase("of ") && best.start - 4 > -1 && !Character.isLetter(text.charAt(best.start - 4))) {
                best.start -= 3;
            }
            while (end < text.length() && Character.isLetter(text.charAt(end))) {
                ++end;
            }
            this.moveTag(Integer.parseInt((String)tagKeys[i]), best.start + 1, false);
            this.moveTag(Integer.parseInt((String)tagKeys[i]), end + 1, true);
        }
        for (i = 0; i < tagKeys.length; ++i) {
            this.slideTag(Integer.parseInt((String)tagKeys[i]), 0, false, "r", "r");
        }
    }

    void exportRangeButton_actionPerformed(ActionEvent e) {
        this.exportRange(this.rangeText.getText(), "export.zip");
        JOptionPane.showMessageDialog(this, "File [export.zip] written.");
    }

    void previousTag() {
        int i;
        Object[] tagKeys = this.tags.keySet().toArray();
        Arrays.sort(tagKeys, new Comparator(){

            public int compare(Object o1, Object o2) {
                return Integer.parseInt((String)o2) - Integer.parseInt((String)o1);
            }
        });
        int tag = this.getCurrentTag();
        boolean found = false;
        for (i = 0; i < tagKeys.length; ++i) {
            if (found) {
                this.setCurrentAction(Integer.parseInt((String)tagKeys[i]), "MoveTag");
                break;
            }
            if (tag != Integer.parseInt((String)tagKeys[i])) continue;
            found = true;
        }
        if (found && i == tagKeys.length) {
            this.setCurrentAction(Integer.parseInt((String)tagKeys[0]), "MoveTag");
        }
    }

    void nextTag() {
        int i;
        Object[] tagKeys = this.tags.keySet().toArray();
        Arrays.sort(tagKeys, new Comparator(){

            public int compare(Object o1, Object o2) {
                return Integer.parseInt((String)o1) - Integer.parseInt((String)o2);
            }
        });
        int tag = this.getCurrentTag();
        boolean found = false;
        for (i = 0; i < tagKeys.length; ++i) {
            if (found) {
                this.setCurrentAction(Integer.parseInt((String)tagKeys[i]), "MoveTag");
                break;
            }
            if (tag != Integer.parseInt((String)tagKeys[i])) continue;
            found = true;
        }
        if (found && i == tagKeys.length) {
            this.setCurrentAction(Integer.parseInt((String)tagKeys[0]), "MoveTag");
        }
    }

    void greekTextEditor_mouseClicked(MouseEvent e) {
        Point clickPoint = e.getPoint();
        int position = this.greekTextEditor.viewToModel(clickPoint);
        Object[] tagKeys = this.tags.keySet().toArray();
        Arrays.sort(tagKeys, new Comparator(){

            public int compare(Object o1, Object o2) {
                return Integer.parseInt((String)o1) - Integer.parseInt((String)o2);
            }
        });
        for (int i = 0; i < tagKeys.length; ++i) {
            TagInfo ti = (TagInfo)this.tags.get(tagKeys[i]);
            if (position < ti.start || position > ti.end + 1) continue;
            this.setCurrentAction(Integer.parseInt((String)tagKeys[i]), "MoveTag");
            break;
        }
    }

    public String getUserID() {
        return this.userID;
    }

    public int login(String userID) {
        if (userID != null && userID.length() > 0) {
            if (this.localKJV) {
                this.userID = userID;
                this.loginStatusLabel.setText(String.valueOf(String.valueOf(new StringBuffer("[").append(userID).append("] logged in."))));
                return 0;
            }
            String passwd = JOptionPane.showInputDialog(this, "Please enter your password", "Password", 3);
            if (passwd != null) {
                StringBuffer result = new StringBuffer();
                this.callServer(String.valueOf(String.valueOf(new StringBuffer("action=l&uid=").append(URLEncoder.encode(userID)).append("&passwd=").append(URLEncoder.encode(passwd)))), result);
                this.stripChar(result, '\n');
                String ltok = result.toString().trim();
                if (ltok.length() > 1) {
                    this.loginToken = ltok;
                    this.userID = userID;
                    this.loginStatusLabel.setText(String.valueOf(String.valueOf(new StringBuffer("[").append(userID).append("] logged in."))));
                    return 0;
                }
                JOptionPane.showMessageDialog(this, "Incorrect Login");
            }
        }
        this.loginStatusLabel.setText("Not Logged In");
        this.userID = null;
        return -1;
    }

    public String getRawEntry() {
        int endPos;
        StringBuffer text = this.getHTML(this.translatedTextEditor);
        this.replaceChar(text, '_', ' ');
        int pos = text.toString().indexOf("<body>");
        if (pos > -1) {
            text.delete(0, pos + 6);
        }
        String htmlstr = text.toString();
        String startSearch = startTag1;
        String endSearch = endTag1;
        int tagPos = text.toString().indexOf(endSearch);
        while (tagPos > -1) {
            endPos = text.toString().indexOf(62, tagPos + endSearch.length() + 1);
            endPos = text.toString().indexOf(62, endPos + 1);
            endPos = text.toString().indexOf(62, endPos + 1);
            text.delete(tagPos, endPos + 1);
            text.insert(tagPos, "</w>");
            tagPos = text.toString().indexOf(endSearch);
        }
        tagPos = text.toString().indexOf(startSearch);
        while (tagPos > -1) {
            endPos = text.toString().indexOf(34, tagPos + startSearch.length() + 1);
            String tagKey = text.substring(tagPos + startSearch.length(), endPos);
            TagInfo ti = (TagInfo)this.tags.get(tagKey);
            String src = ti.splitID == null ? ti.id : ti.splitID;
            String wordTag = String.valueOf(String.valueOf(new StringBuffer("<w src=\"").append(src).append("\"")));
            if (ti.strong != null) {
                wordTag = String.valueOf(String.valueOf(wordTag)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(" lemma=\"x-Strongs:G").append(ti.strong).append("\""))))));
            }
            if (ti.morph != null) {
                wordTag = String.valueOf(String.valueOf(wordTag)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(" morph=\"x-Robinson:").append(ti.morph).append("\""))))));
            }
            if (ti.splitID != null) {
                wordTag = String.valueOf(String.valueOf(wordTag)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(" splitID=\"").append(ti.id).append("\""))))));
            }
            wordTag = String.valueOf(String.valueOf(wordTag)).concat(">");
            endPos = text.toString().indexOf(62, tagPos + startSearch.length() + 1);
            endPos = text.toString().indexOf(62, endPos + 1);
            endPos = text.toString().indexOf(62, endPos + 1);
            text.delete(tagPos, endPos + 1);
            text.insert(tagPos, wordTag);
            tagPos = text.toString().indexOf(startSearch);
        }
        pos = text.toString().indexOf("</body>");
        if (pos > -1) {
            text.delete(pos, text.length());
        }
        String notes = this.notesText.getText().trim();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd-HH:mm");
        String currentDate = formatter.format(new Date());
        if (notes.length() > 0) {
            text.append(String.valueOf(String.valueOf(new StringBuffer("<note type=\"strongsMarkup\" name=\"").append(this.getUserID()).append("\" date=\"").append(currentDate).append("\"/>").append(URLEncoder.encode(notes)).append("</note>"))));
        }
        text.append(String.valueOf(String.valueOf(new StringBuffer("<resp type=\"strongsMarkup\" name=\"").append(this.getUserID()).append("\" date=\"").append(currentDate).append("\"/>"))));
        return text.toString();
    }

    void contentPane_keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 9) {
            this.nextTag();
        }
    }

    void greekTextEditor_keyPressed(KeyEvent e) {
        this.handleKeyboard(e);
    }

    void jToggleButton1_actionPerformed(ActionEvent e) {
        this.exportRange(this.rangeText.getText(), "export.zip");
    }

    void loginButton_actionPerformed(ActionEvent e) {
        this.login(this.userIDText.getText());
    }

    void jMenuItem1_actionPerformed(ActionEvent e) {
        this.processWindowEvent(new WindowEvent(this, 201));
    }

    void jMenuItem2_actionPerformed(ActionEvent e) {
        block1: {
            String proxy;
            ProxyDialog pd = new ProxyDialog(this.useProxy, this.proxyHost, this.proxyPort);
            pd.validate();
            pd.show();
            if (!pd.isOK() || (proxy = pd.getProxy()) == null) break block1;
            String port = pd.getPort();
            if (pd.isKeepSettings()) {
                this.proxyHost = proxy;
                this.proxyPort = port;
            }
            Properties prop = System.getProperties();
            ((Hashtable)prop).put("http.proxyHost", proxy);
            ((Hashtable)prop).put("http.proxyPort", port);
        }
    }

    public void deleteTag(int tag) {
        this.slideTag(tag, 0, false, "y", "y", true);
        this.tags.remove(Integer.toString(tag));
    }

    public TagInfo addSplitTag(int tag) {
        return this.addSplitTag(tag, true);
    }

    public TagInfo addSplitTag(int tag, boolean createMarkup) {
        Object[] tagKeys = this.tags.keySet().toArray();
        Arrays.sort(tagKeys, new Comparator(){

            public int compare(Object o1, Object o2) {
                return Integer.parseInt((String)o1) - Integer.parseInt((String)o2);
            }
        });
        int highest = Integer.parseInt((String)tagKeys[tagKeys.length - 1]);
        TagInfo tagInfo = (TagInfo)this.tags.get(Integer.toString(tag));
        TagInfo newTag = (TagInfo)tagInfo.clone();
        newTag.id = Integer.toString(++highest);
        this.tags.put(Integer.toString(highest), newTag);
        newTag.splitID = Integer.toString(tag);
        newTag.type = "split";
        if (createMarkup) {
            this.slideTag(tag, 0, false, "y", "y", false, highest);
        }
        return newTag;
    }

    public void toggleSplitTag(int tag) {
        TagInfo tagInfo = (TagInfo)this.tags.get(Integer.toString(tag));
        if (tagInfo == null) {
            return;
        }
        String tagKey = tagInfo.splitID == null ? tagInfo.id : tagInfo.splitID;
        Object[] tagKeys = this.tags.keySet().toArray();
        Arrays.sort(tagKeys, new Comparator(){

            public int compare(Object o1, Object o2) {
                return Integer.parseInt((String)o1) - Integer.parseInt((String)o2);
            }
        });
        boolean split = true;
        for (int i = 0; i < tagKeys.length; ++i) {
            TagInfo ti = (TagInfo)this.tags.get(tagKeys[i]);
            if (!tagKey.equals(ti.splitID)) continue;
            this.deleteTag(Integer.parseInt(ti.id));
            split = false;
        }
        if (split) {
            this.addSplitTag(Integer.parseInt(tagInfo.id));
        }
    }

    void jMenuItem3_actionPerformed(ActionEvent e) {
        About aboutBox = new About();
        aboutBox.validate();
        aboutBox.show();
    }

    void jButton1_actionPerformed(ActionEvent e) {
        this.toggleSplitTag(this.getCurrentTag());
    }

    class Hyperactive
    implements HyperlinkListener {
        Hyperactive() {
        }

        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                JEditorPane pane = (JEditorPane)e.getSource();
                try {
                    String url = e.getURL().toString();
                    int id = e.getURL().getPort();
                    if (url.indexOf("SID") > -1) {
                        MainFrame.this.setCurrentAction(id, "MoveTag");
                    } else if (url.indexOf("EID") > -1) {
                        MainFrame.this.setCurrentAction(id, "SizeTag");
                    } else {
                        MainFrame.this.setCurrentAction(id, "[none]");
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }
}

