/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.util;

import java.io.IOException;
import java.net.URI;
import java.util.Properties;
import org.crosswire.common.util.CWProject;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.NetUtil;
import org.crosswire.common.util.ResourceUtil;
import org.crosswire.jsword.util.UserMsg;

public class WebWarning {
    private static WebWarning instance = new WebWarning();
    private static final String SHOWN_KEY = "shown";
    private static final boolean DEFAULT_SHOWN = true;
    private boolean shown;
    private static final Logger log = Logger.getLogger((Class)WebWarning.class);

    private WebWarning() {
        try {
            Properties props = ResourceUtil.getProperties((String)this.getClass().getName());
            this.shown = Boolean.valueOf(props.getProperty(SHOWN_KEY, Boolean.valueOf(true).toString()));
        }
        catch (IOException e) {
            this.shown = true;
        }
    }

    public static WebWarning instance() {
        return instance;
    }

    public void setShown(boolean newShown) {
        try {
            this.shown = newShown;
            Properties props = new Properties();
            props.put(SHOWN_KEY, Boolean.valueOf(this.shown).toString());
            URI outputURI = CWProject.instance().getWritablePropertiesURI(this.getClass().getName());
            NetUtil.storeProperties((Properties)props, (URI)outputURI, (String)"JSword WebWarning");
        }
        catch (IOException ex) {
            log.error("Failed to save JSword WebWarning", (Throwable)ex);
        }
    }

    public boolean isShown() {
        return this.shown;
    }

    public static void setWarningShown(boolean newShown) {
        WebWarning.instance().setShown(newShown);
    }

    public static boolean isWarningShown() {
        return WebWarning.instance().isShown();
    }

    public String getWarning() {
        return UserMsg.WEB_WARNING.toString();
    }

    public String getShownWarningLabel() {
        return UserMsg.WEB_SHOW_WARNING.toString();
    }
}

