/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import org.crosswire.common.crypt.Sapphire;
import org.crosswire.jsword.book.DataPolice;
import org.crosswire.jsword.book.sword.DataIndex;
import org.crosswire.jsword.book.sword.SwordUtil;

public class DataEntry {
    private static final byte SEPARATOR = 10;
    private String name;
    private byte[] data;
    private String charset;
    private String key;
    private int keyEnd;
    private int linkEnd;

    public DataEntry(String name, byte[] data, String charset) {
        this.name = name;
        this.data = data;
        this.charset = charset;
    }

    public String getName() {
        return this.name;
    }

    public String getKey() {
        if (this.key == null) {
            this.keyEnd = SwordUtil.findByte(this.data, (byte)10);
            if (this.keyEnd < 0) {
                DataPolice.report("Failed to find key. name='" + this.name + "' data='" + this.data + "'");
                return "";
            }
            this.key = SwordUtil.decode(this.name, this.data, this.keyEnd, this.charset).trim();
            if (this.key.endsWith("\\")) {
                this.key = this.key.substring(0, this.key.length() - 1);
            }
        }
        return this.key;
    }

    public boolean isLinkEntry() {
        String linkCheck = SwordUtil.decode(this.name, this.data, this.getKeyEnd() + 1, 5, this.charset);
        return "@LINK".equals(linkCheck);
    }

    public String getLinkTarget() {
        return SwordUtil.decode(this.name, this.data, this.getKeyEnd() + 6, this.data.length - (this.getLinkEnd() + 1), this.charset).trim();
    }

    public String getRawText(byte[] cipherKey) {
        int textStart = this.getKeyEnd() + 1;
        this.cipher(cipherKey, textStart);
        return SwordUtil.decode(this.name, this.data, textStart, this.data.length - textStart, this.charset).trim();
    }

    public DataIndex getBlockIndex() {
        int start = this.getKeyEnd() + 1;
        return new DataIndex(SwordUtil.decodeLittleEndian32(this.data, start), SwordUtil.decodeLittleEndian32(this.data, start + 4));
    }

    private int getKeyEnd() {
        if (this.keyEnd == 0) {
            this.keyEnd = SwordUtil.findByte(this.data, (byte)10);
        }
        return this.keyEnd;
    }

    private int getLinkEnd() {
        if (this.linkEnd == 0) {
            this.linkEnd = SwordUtil.findByte(this.data, this.getKeyEnd() + 1, (byte)10);
        }
        return this.linkEnd;
    }

    public void cipher(byte[] cipherKey, int offset) {
        if (cipherKey != null && cipherKey.length > 0) {
            Sapphire cipherEngine = new Sapphire(cipherKey);
            for (int i = offset; i < this.data.length; ++i) {
                this.data[i] = cipherEngine.cipher(this.data[i]);
            }
            cipherEngine.burn();
        }
    }
}

