/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book;

import java.io.Serializable;
import java.util.Locale;

public abstract class CaseType
implements Serializable {
    public static final CaseType LOWER;
    public static final CaseType SENTENCE;
    public static final CaseType UPPER;
    private String name;
    private static int nextObj;
    private final int obj = nextObj++;
    private static final CaseType[] VALUES;
    static final /* synthetic */ boolean $assertionsDisabled;

    public abstract String setCase(String var1);

    public CaseType(String name) {
        this.name = name;
    }

    protected static String toSentenceCase(String word) {
        if (!$assertionsDisabled && word == null) {
            throw new AssertionError();
        }
        if (word.length() == 0) {
            return "";
        }
        return Character.toUpperCase(word.charAt(0)) + word.substring(1).toLowerCase(Locale.getDefault());
    }

    public static CaseType getCase(String word) {
        if (!$assertionsDisabled && word == null) {
            throw new AssertionError();
        }
        if (word.length() == 0) {
            return LOWER;
        }
        if (word.equals(word.toLowerCase(Locale.getDefault()))) {
            return LOWER;
        }
        if (word.equals(word.toUpperCase(Locale.getDefault())) && word.length() != 1) {
            return UPPER;
        }
        return SENTENCE;
    }

    public int toInteger() {
        for (int i = 0; i < VALUES.length; ++i) {
            if (!this.equals(VALUES[i])) continue;
            return i;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return -1;
    }

    public static CaseType fromString(String name) {
        for (int i = 0; i < VALUES.length; ++i) {
            CaseType o = VALUES[i];
            if (!o.name.equalsIgnoreCase(name)) continue;
            return o;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    public static CaseType fromInteger(int i) {
        return VALUES[i];
    }

    public final boolean equals(Object o) {
        return super.equals(o);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return this.name;
    }

    Object readResolve() {
        return VALUES[this.obj];
    }

    static {
        $assertionsDisabled = !CaseType.class.desiredAssertionStatus();
        LOWER = new CaseType("LOWER"){
            private static final long serialVersionUID = 3546637707360286256L;

            public String setCase(String word) {
                return word.toLowerCase(Locale.getDefault());
            }
        };
        SENTENCE = new CaseType("SENTENCE"){
            private static final long serialVersionUID = 3905520510312985138L;

            public String setCase(String word) {
                int index = word.indexOf(45);
                if (index == -1) {
                    return 2.toSentenceCase(word);
                }
                if ("maher-shalal-hash-baz".equalsIgnoreCase(word)) {
                    return "Maher-Shalal-Hash-Baz";
                }
                if ("no-one".equalsIgnoreCase(word)) {
                    return "No-one";
                }
                if (word.substring(0, 4).equalsIgnoreCase("god-")) {
                    return 2.toSentenceCase(word);
                }
                return 2.toSentenceCase(word.substring(0, index)) + "-" + 2.toSentenceCase(word.substring(index + 1));
            }
        };
        UPPER = new CaseType("UPPER"){
            private static final long serialVersionUID = 3257002163871035698L;

            public String setCase(String word) {
                return word.toUpperCase(Locale.getDefault());
            }
        };
        VALUES = new CaseType[]{LOWER, SENTENCE, UPPER};
    }
}

