/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.xml;

import java.io.Serializable;

public final class FormatType
implements Serializable {
    public static final FormatType AS_IS;
    public static final FormatType ANALYSIS;
    public static final FormatType CLASSIC;
    public static final FormatType ANALYSIS_INDENT;
    public static final FormatType CLASSIC_INDENT;
    private String name;
    private boolean indented;
    private boolean multiline;
    private boolean analytic;
    private boolean classic;
    private static int nextObj;
    private final int obj = nextObj++;
    private static final FormatType[] VALUES;
    private static final long serialVersionUID = 3544385916136142129L;
    static final /* synthetic */ boolean $assertionsDisabled;

    public FormatType(String aName, boolean displayNewlines, boolean doIndenting, boolean classicLines) {
        this.name = aName;
        this.multiline = displayNewlines;
        this.indented = doIndenting && this.multiline;
        this.classic = classicLines && this.multiline;
        this.analytic = !classicLines && this.multiline;
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public boolean isIndented() {
        return this.indented;
    }

    public boolean isAnalytic() {
        return this.analytic;
    }

    public boolean isClassic() {
        return this.classic;
    }

    public int toInteger() {
        for (int i = 0; i < VALUES.length; ++i) {
            if (!this.equals(VALUES[i])) continue;
            return i;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return -1;
    }

    public static FormatType fromString(String name) {
        for (int i = 0; i < VALUES.length; ++i) {
            FormatType obj = VALUES[i];
            if (!obj.name.equalsIgnoreCase(name)) continue;
            return obj;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    public static FormatType fromInteger(int i) {
        return VALUES[i];
    }

    public String toString() {
        return this.name;
    }

    Object readResolve() {
        return VALUES[this.obj];
    }

    static {
        $assertionsDisabled = !FormatType.class.desiredAssertionStatus();
        AS_IS = new FormatType("AS_IS", false, false, false);
        ANALYSIS = new FormatType("ANALYSIS", true, false, false);
        CLASSIC = new FormatType("CLASSIC", true, false, true);
        ANALYSIS_INDENT = new FormatType("ANALYSIS_INDENT", true, true, false);
        CLASSIC_INDENT = new FormatType("CLASSIC_INDENT", true, true, true);
        VALUES = new FormatType[]{AS_IS, ANALYSIS, CLASSIC, ANALYSIS_INDENT, CLASSIC_INDENT};
    }
}

