/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Date;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpHost;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.ProxyHost;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.util.HttpURLConnection;
import org.crosswire.common.util.IOUtil;
import org.crosswire.common.util.LucidException;
import org.crosswire.common.util.MsgBase;
import org.crosswire.common.util.NetUtil;
import org.crosswire.common.util.Reporter;
import org.crosswire.common.util.UserMsg;

public class WebResource {
    private URI uri;
    private HttpClient client;

    public WebResource(URI theURI) {
        this(theURI, null);
    }

    public WebResource(URI theURI, String theProxyHost) {
        this(theURI, theProxyHost, null);
    }

    public WebResource(URI theURI, String theProxyHost, Integer theProxyPort) {
        this.uri = theURI;
        this.client = new HttpClient();
        HostConfiguration config = this.client.getHostConfiguration();
        config.setHost(new HttpHost(theURI.getHost(), theURI.getPort()));
        if (theProxyHost != null && theProxyHost.length() > 0) {
            config.setProxyHost(new ProxyHost(theProxyHost, theProxyPort == null ? -1 : theProxyPort));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        HeadMethod method = new HeadMethod(this.uri.getPath());
        try {
            int status = this.client.executeMethod((HttpMethod)method);
            if (status == 200) {
                int n = new HttpURLConnection((HttpMethod)method, NetUtil.toURL(this.uri)).getContentLength();
                return n;
            }
            String reason = HttpStatus.getStatusText((int)status);
            Reporter.informUser((Object)this, (MsgBase)UserMsg.MISSING_FILE, new Object[]{reason + ':' + this.uri.getPath()});
        }
        catch (IOException e) {
            int n = 0;
            return n;
        }
        finally {
            method.releaseConnection();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastModified() {
        HeadMethod method = new HeadMethod(this.uri.getPath());
        try {
            if (this.client.executeMethod((HttpMethod)method) == 200) {
                long l = new HttpURLConnection((HttpMethod)method, NetUtil.toURL(this.uri)).getLastModified();
                return l;
            }
        }
        catch (IOException e) {
            long l = new Date().getTime();
            return l;
        }
        finally {
            method.releaseConnection();
        }
        return new Date().getTime();
    }

    public void copy(URI dest) throws LucidException {
        GetMethod method;
        OutputStream out;
        InputStream in;
        block6: {
            in = null;
            out = null;
            method = new GetMethod(this.uri.getPath());
            try {
                int status = this.client.executeMethod((HttpMethod)method);
                if (status == 200) {
                    in = method.getResponseBodyAsStream();
                    out = NetUtil.getOutputStream(dest);
                    byte[] buf = new byte[4096];
                    int count = in.read(buf);
                    while (-1 != count) {
                        out.write(buf, 0, count);
                        count = in.read(buf);
                    }
                    break block6;
                }
                String reason = HttpStatus.getStatusText((int)status);
                Reporter.informUser((Object)this, (MsgBase)UserMsg.MISSING_FILE, new Object[]{reason + ':' + this.uri.getPath()});
            }
            catch (IOException e) {
                try {
                    throw new LucidException(UserMsg.MISSING_FILE, e, new Object[]{this.uri.toString()});
                }
                catch (Throwable throwable) {
                    method.releaseConnection();
                    IOUtil.close(in);
                    IOUtil.close(out);
                    throw throwable;
                }
            }
        }
        method.releaseConnection();
        IOUtil.close(in);
        IOUtil.close(out);
    }
}

