/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import org.crosswire.common.util.Languages;

public class Language
implements Comparable {
    public static final Language DEFAULT_LANG = new Language(null);
    private String code;
    private String name;
    private boolean knowsDirection;
    private boolean ltor;

    public Language(String iso639Code) {
        this.code = Languages.getLanguageCode(iso639Code);
    }

    public boolean isValidLanguage() {
        return Languages.isValidLanguage(this.code);
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        if (this.name == null) {
            this.name = Languages.getLanguageName(this.code);
        }
        return this.name;
    }

    public boolean isLeftToRight() {
        if (!this.knowsDirection) {
            this.ltor = !"he".equals(this.code) && !"ar".equals(this.code) && !"fa".equals(this.code) && !"ur".equals(this.code) && !"uig".equals(this.code) && !"syr".equals(this.code) && !"iw".equals(this.code);
            this.knowsDirection = true;
        }
        return this.ltor;
    }

    public int hashCode() {
        return this.code.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Language other = (Language)obj;
        return this.code.equals(other.code);
    }

    public String toString() {
        return this.getName();
    }

    public int compareTo(Object o) {
        return this.getName().compareTo(o.toString());
    }
}

