/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import java.util.Properties;
import org.crosswire.common.util.EventListenerList;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.LucidException;
import org.crosswire.common.util.LucidRuntimeException;
import org.crosswire.common.util.MsgBase;
import org.crosswire.common.util.ReporterEvent;
import org.crosswire.common.util.ReporterListener;
import org.crosswire.common.util.TimeGate;
import org.crosswire.common.util.UserMsg;

public final class Reporter {
    private static final String AWT_HANDLER_PROPERTY = "sun.awt.exception.handler";
    private static final String OUR_NAME = CustomAWTExceptionHandler.class.getName();
    private static final Logger log = Logger.getLogger(Reporter.class);
    private static final EventListenerList LISTENERS = new EventListenerList();

    private Reporter() {
    }

    public static void informUser(Object source, Throwable prob) {
        Class cat = source != null ? source.getClass() : Reporter.class;
        Logger templog = Logger.getLogger(cat);
        templog.warn(prob.getMessage(), prob);
        Reporter.fireCapture(new ReporterEvent(source, prob));
    }

    public static void informUser(Object source, LucidException prob) {
        Class cat = source != null ? source.getClass() : Reporter.class;
        Logger templog = Logger.getLogger(cat);
        templog.warn(prob.getMessage(), prob);
        Reporter.fireCapture(new ReporterEvent(source, prob));
    }

    public static void informUser(Object source, LucidRuntimeException prob) {
        Class cat = source != null ? source.getClass() : Reporter.class;
        Logger templog = Logger.getLogger(cat);
        templog.warn(prob.getMessage(), prob);
        Reporter.fireCapture(new ReporterEvent(source, prob));
    }

    public static void informUser(Object source, String message) {
        log.debug(message);
        Reporter.fireCapture(new ReporterEvent(source, message));
    }

    public static void informUser(Object source, MsgBase message) {
        String msg = message.toString();
        log.debug(msg);
        Reporter.fireCapture(new ReporterEvent(source, msg));
    }

    public static void informUser(Object source, MsgBase message, Object param) {
        String msg = message.toString(param);
        log.debug(msg);
        Reporter.fireCapture(new ReporterEvent(source, msg));
    }

    public static void informUser(Object source, MsgBase message, Object[] params) {
        String msg = message.toString(params);
        log.debug(msg);
        Reporter.fireCapture(new ReporterEvent(source, msg));
    }

    public static void addReporterListener(ReporterListener li) {
        LISTENERS.add(ReporterListener.class, li);
    }

    public static void removeReporterListener(ReporterListener li) {
        LISTENERS.remove(ReporterListener.class, li);
    }

    protected static void fireCapture(ReporterEvent ev) {
        Object[] liArr = LISTENERS.getListenerList();
        if (liArr.length == 0) {
            log.warn("Nothing to listen to report: message=" + ev.getMessage(), ev.getException());
        }
        for (int i = liArr.length - 2; i >= 0; i -= 2) {
            if (liArr[i] != (class$org$crosswire$common$util$ReporterListener == null ? Reporter.class$("org.crosswire.common.util.ReporterListener") : class$org$crosswire$common$util$ReporterListener)) continue;
            ReporterListener li = (ReporterListener)liArr[i + 1];
            if (ev.getException() != null) {
                li.reportException(ev);
                continue;
            }
            li.reportMessage(ev);
        }
    }

    public static void grabAWTExecptions(boolean grab) {
        if (grab) {
            System.setProperty(AWT_HANDLER_PROPERTY, OUR_NAME);
        } else {
            String current = System.getProperty(AWT_HANDLER_PROPERTY);
            if (current != null && current.equals(OUR_NAME)) {
                Properties prop = System.getProperties();
                prop.remove(AWT_HANDLER_PROPERTY);
            }
        }
    }

    public static final class CustomAWTExceptionHandler {
        private static TimeGate gate = new TimeGate(2000);

        public void handle(Throwable ex) {
            if (gate.open()) {
                Reporter.informUser((Object)this, new LucidException((MsgBase)UserMsg.UNEXPECTED_ERROR, ex));
            }
        }
    }
}

