/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.icu;

import java.util.Locale;

public class NumberShaper {
    private Locale locale;
    private char nineShape;

    public NumberShaper() {
        this(Locale.getDefault());
    }

    public NumberShaper(Locale locale) {
        this.locale = locale;
        this.nineShape = '\u0000';
    }

    public boolean canShape() {
        return this.getNine() != '9';
    }

    public String shape(String input) {
        if (input == null) {
            return input;
        }
        char[] src = input.toCharArray();
        boolean[] transformed = new boolean[]{false};
        char[] dest = this.shaped(src, transformed);
        if (transformed[0]) {
            return new String(dest);
        }
        return input;
    }

    public boolean canUnshape() {
        return this.getNine() != '9';
    }

    public String unshape(String input) {
        char[] src = input.toCharArray();
        boolean[] transformed = new boolean[]{false};
        char[] dest = this.unshaped(src, transformed);
        if (transformed[0]) {
            return new String(dest);
        }
        return input;
    }

    private char[] unshaped(char[] src, boolean[] transformed) {
        char nine = this.getNine();
        if (nine == '9') {
            return src;
        }
        int zero = nine - 9;
        return this.transform(src, zero, nine, 57 - nine, transformed);
    }

    private char[] shaped(char[] src, boolean[] transformed) {
        char nine = this.getNine();
        if (nine == '9') {
            return src;
        }
        return this.transform(src, 48, 57, nine - 57, transformed);
    }

    private char[] transform(char[] src, int zero, int nine, int offset, boolean[] transformed) {
        char[] text = src;
        int len = src.length;
        for (int i = 0; i < len; ++i) {
            char c = text[i];
            if (c < zero || c > nine) continue;
            text[i] = (char)(c + offset);
            transformed[0] = true;
        }
        return text;
    }

    private char getNine() {
        if (this.nineShape == '\u0000') {
            this.nineShape = (char)57;
            if ("fa".equals(this.locale.getLanguage())) {
                this.nineShape = (char)1785;
            } else if ("ar".equals(this.locale.getLanguage())) {
                this.nineShape = (char)1641;
            }
        }
        return this.nineShape;
    }
}

