/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.diff;

public class Distance {
    private Distance() {
    }

    public static int getLevenshteinDistance(String source, String target) {
        int i;
        if (source == null || target == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int sourceLength = source.length();
        int targetLength = target.length();
        if (sourceLength == 0) {
            return targetLength;
        }
        if (targetLength == 0) {
            return sourceLength;
        }
        int[] prevDist = new int[sourceLength + 1];
        int[] dist = new int[sourceLength + 1];
        for (i = 0; i <= sourceLength; ++i) {
            prevDist[i] = i;
        }
        for (int j = 1; j <= targetLength; ++j) {
            char targetJ = target.charAt(j - 1);
            dist[0] = j;
            for (i = 1; i <= sourceLength; ++i) {
                int cost = source.charAt(i - 1) == targetJ ? 0 : 1;
                dist[i] = Math.min(Math.min(dist[i - 1] + 1, prevDist[i] + 1), prevDist[i - 1] + cost);
            }
            int[] swap = prevDist;
            prevDist = dist;
            dist = swap;
        }
        return prevDist[sourceLength];
    }
}

