/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.versification;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.crosswire.common.util.CWClassLoader;
import org.crosswire.common.util.MsgBase;
import org.crosswire.jsword.book.CaseType;
import org.crosswire.jsword.passage.NoSuchVerseException;
import org.crosswire.jsword.versification.BibleInfo;
import org.crosswire.jsword.versification.Msg;

public final class SectionNames {
    private static final String SECTION_KEY = "Sections.";
    public static final byte PENTATEUCH = 1;
    public static final byte HISTORY = 2;
    public static final byte POETRY = 3;
    public static final byte MAJOR_PROPHETS = 4;
    public static final byte MINOR_PROPHETS = 5;
    public static final byte GOSPELS_AND_ACTS = 6;
    public static final byte LETTERS = 7;
    public static final byte REVELATION = 8;
    private String[] sections;
    private static final int SECTIONS_IN_BIBLE = 8;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SectionNames() {
        this.initialize();
    }

    public static boolean isPentateuch(int book) {
        return book >= 1 && book <= 5;
    }

    public static boolean isHistory(int book) {
        return book >= 6 && book <= 17;
    }

    public static boolean isPoetry(int book) {
        return book >= 18 && book <= 22;
    }

    public static boolean isMajorProphet(int book) {
        return book >= 23 && book <= 27;
    }

    public static boolean isMinorProphet(int book) {
        return book >= 28 && book <= 39;
    }

    public static boolean isGospel(int book) {
        return book >= 40 && book <= 43;
    }

    public static boolean isGospelOrActs(int book) {
        return book >= 40 && book <= 44;
    }

    public static boolean isLetter(int book) {
        return book >= 45 && book <= 65;
    }

    public static int getSection(int book) {
        if (SectionNames.isLetter(book)) {
            return 7;
        }
        if (SectionNames.isHistory(book)) {
            return 2;
        }
        if (SectionNames.isMinorProphet(book)) {
            return 5;
        }
        if (SectionNames.isGospelOrActs(book)) {
            return 6;
        }
        if (SectionNames.isPentateuch(book)) {
            return 1;
        }
        if (SectionNames.isPoetry(book)) {
            return 3;
        }
        if (SectionNames.isMajorProphet(book)) {
            return 4;
        }
        return 8;
    }

    public String getSectionName(int section) throws NoSuchVerseException {
        if (section == 0) {
            throw new NoSuchVerseException((MsgBase)Msg.BOOKS_SECTION, new Object[]{new Integer(section)});
        }
        try {
            CaseType bookCase = BibleInfo.getDefaultCase();
            if (bookCase.equals(CaseType.LOWER)) {
                return this.sections[section - 1].toLowerCase(Locale.getDefault());
            }
            if (bookCase.equals(CaseType.UPPER)) {
                return this.sections[section - 1].toUpperCase(Locale.getDefault());
            }
            return this.sections[section - 1];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new NoSuchVerseException((MsgBase)Msg.BOOKS_SECTION, new Object[]{new Integer(section)});
        }
    }

    private void initialize() {
        ResourceBundle resources = ResourceBundle.getBundle(SectionNames.class.getName(), Locale.getDefault(), (ClassLoader)CWClassLoader.instance((Class)SectionNames.class));
        this.sections = new String[8];
        for (int i = 0; i < 8; ++i) {
            String section;
            this.sections[i] = section = this.getString(resources, SECTION_KEY + (i + 1));
        }
    }

    private String getString(ResourceBundle resources, String key) {
        try {
            return resources.getString(key);
        }
        catch (MissingResourceException e) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }
    }

    static {
        $assertionsDisabled = !SectionNames.class.desiredAssertionStatus();
    }
}

