/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.passage;

import java.io.Serializable;
import org.crosswire.jsword.passage.BitwisePassage;
import org.crosswire.jsword.passage.DistinctPassage;
import org.crosswire.jsword.passage.NoSuchVerseException;
import org.crosswire.jsword.passage.Passage;
import org.crosswire.jsword.passage.PassageTally;
import org.crosswire.jsword.passage.RocketPassage;

public abstract class PassageType
implements Serializable {
    public static final PassageType SPEED;
    public static final PassageType WRITE_SPEED;
    public static final PassageType SIZE;
    public static final PassageType MIX;
    public static final PassageType TALLY;
    private String name;
    private static int nextObj;
    private final int obj = nextObj++;
    private static final PassageType[] VALUES;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PassageType(String name) {
        this.name = name;
    }

    public abstract Passage createPassage(String var1) throws NoSuchVerseException;

    public abstract Passage createEmptyPassage();

    public static PassageType fromString(String name) {
        for (int i = 0; i < VALUES.length; ++i) {
            PassageType o = VALUES[i];
            if (!o.name.equalsIgnoreCase(name)) continue;
            return o;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    public static PassageType fromInteger(int i) {
        if (i < 0 || i >= VALUES.length) {
            return SPEED;
        }
        return VALUES[i];
    }

    public static int toInteger(PassageType type) {
        for (int i = 0; i < VALUES.length; ++i) {
            PassageType o = VALUES[i];
            if (!o.equals(type)) continue;
            return i;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return 0;
    }

    public final boolean equals(Object o) {
        return super.equals(o);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return this.name;
    }

    Object readResolve() {
        return VALUES[this.obj];
    }

    static {
        $assertionsDisabled = !PassageType.class.desiredAssertionStatus();
        SPEED = new PassageType("SPEED"){
            private static final long serialVersionUID = -5432599732858220775L;

            public Passage createPassage(String passage) throws NoSuchVerseException {
                if (passage == null || passage.length() == 0) {
                    return this.createEmptyPassage();
                }
                return new RocketPassage(passage);
            }

            public Passage createEmptyPassage() {
                return new RocketPassage();
            }
        };
        WRITE_SPEED = new PassageType("WRITE_SPEED"){
            private static final long serialVersionUID = -8808127396341614058L;

            public Passage createPassage(String passage) throws NoSuchVerseException {
                if (passage == null || passage.length() == 0) {
                    return this.createEmptyPassage();
                }
                return new BitwisePassage(passage);
            }

            public Passage createEmptyPassage() {
                return new BitwisePassage();
            }
        };
        SIZE = new PassageType("SIZE"){
            private static final long serialVersionUID = -1959355535575121168L;

            public Passage createPassage(String passage) throws NoSuchVerseException {
                if (passage == null || passage.length() == 0) {
                    return this.createEmptyPassage();
                }
                return new DistinctPassage(passage);
            }

            public Passage createEmptyPassage() {
                return new DistinctPassage();
            }
        };
        MIX = new PassageType("MIX"){
            private static final long serialVersionUID = -8426713571411491868L;

            public Passage createPassage(String passage) throws NoSuchVerseException {
                if (passage == null || passage.length() == 0) {
                    return this.createEmptyPassage();
                }
                return new PassageTally(passage);
            }

            public Passage createEmptyPassage() {
                return new PassageTally();
            }
        };
        TALLY = new PassageType("TALLY"){
            private static final long serialVersionUID = -4148688085074351220L;

            public Passage createPassage(String passage) throws NoSuchVerseException {
                if (passage == null || passage.length() == 0) {
                    return this.createEmptyPassage();
                }
                return new PassageTally(passage);
            }

            public Passage createEmptyPassage() {
                return new PassageTally();
            }
        };
        VALUES = new PassageType[]{SPEED, WRITE_SPEED, SIZE, MIX, TALLY};
    }
}

