/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.passage;

import java.io.Serializable;
import org.crosswire.jsword.passage.Passage;
import org.crosswire.jsword.passage.RestrictionType;

public abstract class PassageListType
implements Serializable {
    public static final PassageListType VERSES;
    public static final PassageListType RANGES;
    private String name;
    private static int nextObj;
    private final int obj = nextObj++;
    private static final PassageListType[] VALUES;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PassageListType(String name) {
        this.name = name;
    }

    public abstract Object getElementAt(Passage var1, int var2, RestrictionType var3);

    public abstract int count(Passage var1, RestrictionType var2);

    public static PassageListType fromString(String name) {
        for (int i = 0; i < VALUES.length; ++i) {
            PassageListType o = VALUES[i];
            if (!o.name.equalsIgnoreCase(name)) continue;
            return o;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    public static PassageListType fromInteger(int i) {
        return VALUES[i];
    }

    public final boolean equals(Object o) {
        return super.equals(o);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return this.name;
    }

    Object readResolve() {
        return VALUES[this.obj];
    }

    static {
        $assertionsDisabled = !PassageListType.class.desiredAssertionStatus();
        VERSES = new PassageListType("VERSES"){
            private static final long serialVersionUID = 4050199730607109682L;

            public Object getElementAt(Passage ref, int index, RestrictionType restrict) {
                if (ref == null) {
                    return null;
                }
                return ref.getVerseAt(index);
            }

            public int count(Passage ref, RestrictionType restrict) {
                if (ref == null) {
                    return 0;
                }
                return ref.countVerses();
            }
        };
        RANGES = new PassageListType("RANGES"){
            private static final long serialVersionUID = 3834030242750083129L;

            public Object getElementAt(Passage ref, int index, RestrictionType restrict) {
                if (ref == null) {
                    return null;
                }
                return ref.getRangeAt(index, restrict);
            }

            public int count(Passage ref, RestrictionType restrict) {
                if (ref == null) {
                    return 0;
                }
                return ref.countRanges(restrict);
            }
        };
        VALUES = new PassageListType[]{VERSES, RANGES};
    }
}

