/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book;

import java.io.Serializable;

public final class FeatureType
implements Serializable {
    public static final FeatureType GREEK_DEFINITIONS;
    public static final FeatureType GREEK_PARSE;
    public static final FeatureType HEBREW_DEFINITIONS;
    public static final FeatureType HEBREW_PARSE;
    public static final FeatureType DAILY_DEVOTIONS;
    public static final FeatureType GLOSSARY;
    public static final FeatureType STRONGS_NUMBERS;
    public static final FeatureType FOOTNOTES;
    public static final FeatureType SCRIPTURE_REFERENCES;
    public static final FeatureType WORDS_OF_CHRIST;
    public static final FeatureType MORPHOLOGY;
    public static final FeatureType HEADINGS;
    private String name;
    private static int nextObj;
    private final int obj = nextObj++;
    private static final FeatureType[] VALUES;
    private static final long serialVersionUID = 3256727260177708345L;
    static final /* synthetic */ boolean $assertionsDisabled;

    private FeatureType(String name) {
        this.name = name;
    }

    public static FeatureType fromString(String name) {
        for (int i = 0; i < VALUES.length; ++i) {
            FeatureType o = VALUES[i];
            if (!o.name.equalsIgnoreCase(name)) continue;
            return o;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    public static FeatureType fromInteger(int i) {
        return VALUES[i];
    }

    public String toString() {
        return this.name;
    }

    Object readResolve() {
        return VALUES[this.obj];
    }

    static {
        $assertionsDisabled = !FeatureType.class.desiredAssertionStatus();
        GREEK_DEFINITIONS = new FeatureType("GreekDef");
        GREEK_PARSE = new FeatureType("GreekParse");
        HEBREW_DEFINITIONS = new FeatureType("HebrewDef");
        HEBREW_PARSE = new FeatureType("HebrewParse");
        DAILY_DEVOTIONS = new FeatureType("DailyDevotions");
        GLOSSARY = new FeatureType("Glossary");
        STRONGS_NUMBERS = new FeatureType("StrongsNumbers");
        FOOTNOTES = new FeatureType("Footnotes");
        SCRIPTURE_REFERENCES = new FeatureType("Scripref");
        WORDS_OF_CHRIST = new FeatureType("RedLetterText");
        MORPHOLOGY = new FeatureType("Morph");
        HEADINGS = new FeatureType("Headings");
        VALUES = new FeatureType[]{GREEK_DEFINITIONS, GREEK_PARSE, HEBREW_DEFINITIONS, HEBREW_PARSE, DAILY_DEVOTIONS, GLOSSARY, STRONGS_NUMBERS, FOOTNOTES, SCRIPTURE_REFERENCES, WORDS_OF_CHRIST, MORPHOLOGY, HEADINGS};
    }
}

