/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.display.basic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.crosswire.bibledesktop.display.BookDataDisplay;
import org.crosswire.bibledesktop.display.BookDataDisplayFactory;
import org.crosswire.bibledesktop.display.URIEventListener;
import org.crosswire.bibledesktop.display.basic.Msg;
import org.crosswire.bibledesktop.passage.KeyChangeListener;
import org.crosswire.common.swing.CWScrollPane;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.KeyUtil;
import org.crosswire.jsword.passage.Passage;

public class TabbedBookDataDisplay
implements BookDataDisplay {
    private static final int TITLE_LENGTH = 25;
    private static int pageSize = 50;
    private List uriEventListeners;
    private List keyEventListeners;
    private Passage key;
    private Passage waiting;
    private Book[] books;
    private boolean tabs;
    private JTabbedPane tabMain;
    private BookDataDisplay bookDataDisplay;
    private Map views = new HashMap();
    private List displays = new ArrayList();
    private Component center;
    private JPanel pnlMore = new JPanel();
    private JPanel pnlMain = new JPanel();
    private JScrollPane scrMain;

    public TabbedBookDataDisplay() {
        this.bookDataDisplay = this.createInnerDisplayPane();
        this.tabMain = new JTabbedPane();
        this.tabMain.setTabPlacement(3);
        this.tabMain.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ev) {
                TabbedBookDataDisplay.this.tabChanged();
            }
        });
        this.pnlMain.setLayout(new BorderLayout());
        this.center = this.bookDataDisplay.getComponent();
        this.scrMain = new CWScrollPane(this.center);
        this.pnlMain.add((Component)this.scrMain, "Center");
    }

    public Component getComponent() {
        return this.pnlMain;
    }

    public void clearBookData() {
        this.setBookData(null, null);
    }

    public void setBookData(Book[] books, Key newkey) {
        this.books = books == null ? null : (Book[])books.clone();
        this.key = KeyUtil.getPassage((Key)newkey);
        this.tabMain.removeAll();
        this.views.clear();
        this.displays.clear();
        this.displays.add(this.bookDataDisplay);
        boolean bl = this.tabs = this.key != null && this.key.countVerses() > pageSize;
        if (this.tabs) {
            Passage first = (Passage)this.key.clone();
            this.waiting = first.trimVerses(pageSize);
            BookDataDisplay pnlNew = this.createInnerDisplayPane();
            pnlNew.setBookData(books, (Key)first);
            Component display = pnlNew.getComponent();
            CWScrollPane scrView = new CWScrollPane(display);
            this.views.put(scrView, pnlNew);
            this.tabMain.add(TabbedBookDataDisplay.getTabName((Key)first), (Component)scrView);
            this.tabMain.add(Msg.MORE.toString(), this.pnlMore);
            this.setCenterComponent(this.tabMain);
        } else {
            this.bookDataDisplay.setBookData(books, (Key)this.key);
            this.setCenterComponent(this.bookDataDisplay.getComponent());
        }
        GuiUtil.refresh((Component)this.pnlMain);
    }

    public void setCompareBooks(boolean compare) {
        Iterator iter = this.displays.iterator();
        while (iter.hasNext()) {
            BookDataDisplay bdd = (BookDataDisplay)iter.next();
            bdd.setCompareBooks(compare);
        }
    }

    public void refresh() {
        Iterator iter = this.displays.iterator();
        while (iter.hasNext()) {
            BookDataDisplay bdd = (BookDataDisplay)iter.next();
            bdd.refresh();
        }
    }

    public Key getKey() {
        return this.key;
    }

    public Book[] getBooks() {
        return this.books == null ? null : (Book[])this.books.clone();
    }

    public Book getFirstBook() {
        return this.books != null && this.books.length > 0 ? this.books[0] : null;
    }

    public void copy() {
        this.getInnerDisplayPane().copy();
    }

    public void addKeyChangeListener(KeyChangeListener listener) {
        ArrayList<KeyChangeListener> temp = new ArrayList<KeyChangeListener>();
        if (this.keyEventListeners == null) {
            temp.add(listener);
            this.keyEventListeners = temp;
        } else {
            temp.addAll(this.keyEventListeners);
            if (!temp.contains(listener)) {
                temp.add(listener);
                this.keyEventListeners = temp;
            }
        }
        Iterator iter = this.displays.iterator();
        while (iter.hasNext()) {
            BookDataDisplay bdd = (BookDataDisplay)iter.next();
            bdd.addKeyChangeListener(listener);
        }
    }

    public void removeKeyChangeListener(KeyChangeListener listener) {
        if (this.keyEventListeners != null && this.keyEventListeners.contains(listener)) {
            ArrayList temp = new ArrayList();
            temp.addAll(this.keyEventListeners);
            temp.remove(listener);
            this.keyEventListeners = temp;
        }
        Iterator iter = this.displays.iterator();
        while (iter.hasNext()) {
            BookDataDisplay bdd = (BookDataDisplay)iter.next();
            bdd.removeKeyChangeListener(listener);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Iterator iter = this.displays.iterator();
        while (iter.hasNext()) {
            BookDataDisplay bdd = (BookDataDisplay)iter.next();
            bdd.propertyChange(evt);
        }
    }

    public synchronized void addURIEventListener(URIEventListener listener) {
        ArrayList<URIEventListener> temp = new ArrayList<URIEventListener>();
        if (this.uriEventListeners == null) {
            temp.add(listener);
            this.uriEventListeners = temp;
        } else {
            temp.addAll(this.uriEventListeners);
            if (!temp.contains(listener)) {
                temp.add(listener);
                this.uriEventListeners = temp;
            }
        }
        Iterator iter = this.displays.iterator();
        while (iter.hasNext()) {
            BookDataDisplay bdd = (BookDataDisplay)iter.next();
            bdd.addURIEventListener(listener);
        }
    }

    public synchronized void removeURIEventListener(URIEventListener listener) {
        if (this.uriEventListeners != null && this.uriEventListeners.contains(listener)) {
            ArrayList temp = new ArrayList();
            temp.addAll(this.uriEventListeners);
            temp.remove(listener);
            this.uriEventListeners = temp;
        }
        Iterator iter = this.displays.iterator();
        while (iter.hasNext()) {
            BookDataDisplay bdd = (BookDataDisplay)iter.next();
            bdd.removeURIEventListener(listener);
        }
    }

    private void setCenterComponent(Component comp) {
        if (this.center != comp) {
            this.pnlMain.removeAll();
            this.center = comp;
            if (this.center == this.tabMain) {
                this.pnlMain.add((Component)this.tabMain, "Center");
            } else {
                this.pnlMain.add((Component)this.scrMain, "Center");
            }
        }
    }

    final void tabChanged() {
        if (this.tabMain.getSelectedComponent() != this.pnlMore) {
            return;
        }
        this.tabMain.remove(this.pnlMore);
        Passage next = this.waiting;
        this.waiting = next.trimVerses(pageSize);
        BookDataDisplay pnlNew = this.createInnerDisplayPane();
        pnlNew.setBookData(this.books, (Key)next);
        CWScrollPane scrView = new CWScrollPane(pnlNew.getComponent());
        this.views.put(scrView, pnlNew);
        this.tabMain.add(TabbedBookDataDisplay.getTabName((Key)next), (Component)scrView);
        if (this.waiting != null) {
            this.tabMain.add(Msg.MORE.toString(), this.pnlMore);
        }
        this.tabMain.setSelectedComponent((Component)scrView);
    }

    public BookDataDisplay getInnerDisplayPane() {
        if (this.tabs) {
            Component o = this.tabMain.getSelectedComponent();
            JScrollPane sp = (JScrollPane)o;
            return (BookDataDisplay)this.views.get(sp);
        }
        return this.bookDataDisplay;
    }

    private synchronized BookDataDisplay createInnerDisplayPane() {
        EventListener li;
        Iterator iter;
        BookDataDisplay display = BookDataDisplayFactory.createBookDataDisplay();
        this.displays.add(display);
        if (this.uriEventListeners != null) {
            iter = this.uriEventListeners.iterator();
            while (iter.hasNext()) {
                li = (URIEventListener)iter.next();
                display.addURIEventListener((URIEventListener)li);
            }
        }
        if (this.keyEventListeners != null) {
            iter = this.keyEventListeners.iterator();
            while (iter.hasNext()) {
                li = (KeyChangeListener)iter.next();
                display.addKeyChangeListener((KeyChangeListener)li);
            }
        }
        return display;
    }

    public static void setPageSize(int pageSize) {
        TabbedBookDataDisplay.pageSize = pageSize;
    }

    public static int getPageSize() {
        return pageSize;
    }

    private static String getTabName(Key key) {
        String tabname = key.getName();
        int len = tabname.length();
        if (len > 25) {
            tabname = tabname.substring(0, 9) + " ... " + tabname.substring(len - 9, len);
        }
        return tabname;
    }
}

