/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.desktop;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.SwingPropertyChangeSupport;
import org.crosswire.bibledesktop.book.BibleViewPane;
import org.crosswire.bibledesktop.book.DisplaySelectEvent;
import org.crosswire.bibledesktop.book.DisplaySelectListener;
import org.crosswire.bibledesktop.book.DisplaySelectPane;
import org.crosswire.bibledesktop.book.MultiBookPane;
import org.crosswire.bibledesktop.desktop.DesktopActions;
import org.crosswire.bibledesktop.desktop.Msg;
import org.crosswire.bibledesktop.desktop.Splash;
import org.crosswire.bibledesktop.desktop.StatusBar;
import org.crosswire.bibledesktop.desktop.XSLTProperty;
import org.crosswire.bibledesktop.display.BookDataDisplay;
import org.crosswire.bibledesktop.display.URIEvent;
import org.crosswire.bibledesktop.display.URIEventListener;
import org.crosswire.bibledesktop.display.basic.SplitBookDataDisplay;
import org.crosswire.bibledesktop.util.ConfigurableSwingConverter;
import org.crosswire.common.config.ChoiceFactory;
import org.crosswire.common.config.Config;
import org.crosswire.common.history.History;
import org.crosswire.common.progress.JobManager;
import org.crosswire.common.progress.Progress;
import org.crosswire.common.swing.CWOptionPane;
import org.crosswire.common.swing.CatchingThreadGroup;
import org.crosswire.common.swing.ExceptionPane;
import org.crosswire.common.swing.FixedSplitPane;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.common.swing.LookAndFeelUtil;
import org.crosswire.common.swing.desktop.LayoutType;
import org.crosswire.common.swing.desktop.TDIViewLayout;
import org.crosswire.common.swing.desktop.ToolBar;
import org.crosswire.common.swing.desktop.ViewGenerator;
import org.crosswire.common.swing.desktop.ViewManager;
import org.crosswire.common.swing.desktop.event.ViewEvent;
import org.crosswire.common.swing.desktop.event.ViewEventListener;
import org.crosswire.common.util.CWClassLoader;
import org.crosswire.common.util.CWProject;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.LucidException;
import org.crosswire.common.util.OSType;
import org.crosswire.common.util.Reporter;
import org.crosswire.common.util.ResourceUtil;
import org.crosswire.common.util.Translations;
import org.crosswire.common.xml.XMLUtil;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookFilters;
import org.crosswire.jsword.book.Books;
import org.crosswire.jsword.book.BooksEvent;
import org.crosswire.jsword.book.BooksListener;
import org.crosswire.jsword.book.Defaults;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.NoSuchKeyException;
import org.crosswire.jsword.util.ConverterFactory;
import org.jdom.Document;
import org.jdom.JDOMException;

public class Desktop
extends JFrame
implements URIEventListener,
ViewEventListener,
DisplaySelectListener,
ViewGenerator {
    private static final CWProject PROJECT = CWProject.instance();
    private boolean hasRefBooks;
    private static final String SPLASH_PROPS = "splash";
    private static final String BIBLE_PROTOCOL = "bible";
    private static final String DICTIONARY_PROTOCOL = "dict";
    private static final String GREEK_DEF_PROTOCOL = "gdef";
    private static final String HEBREW_DEF_PROTOCOL = "hdef";
    private static final String GREEK_MORPH_PROTOCOL = "gmorph";
    private static final String HEBREW_MORPH_PROTOCOL = "hmorph";
    private static final String COMMENTARY_PROTOCOL = "comment";
    private static final String EMPTY_STRING = "";
    private static final String CONFIG_KEY = "config";
    private static final String DESKTOP_KEY = "desktop";
    private static final String CONV_KEY = "converters";
    private static final String CSWING_KEY = "cswing-styles";
    private transient Config config;
    private static boolean sidebarShowing;
    private static boolean viewSourceShowing;
    private static boolean compareShowing;
    private static boolean webJournalShowing;
    private static boolean reuseBibleView;
    private static Dimension defaultSize;
    protected static final Logger log;
    protected transient DesktopActions actions;
    private static final ImageIcon ICON_APP;
    private transient ViewManager views;
    private JPanel corePanel;
    private JSplitPane sptBlog;
    private JCheckBoxMenuItem sidebarToggle;
    private StatusBar barStatus;
    protected MultiBookPane reference;
    private JSplitPane sptBooks;
    private JPanel mainPanel;
    private transient History history;
    private PropertyChangeSupport changeSupport;
    private static final long serialVersionUID = 3977014029116191800L;

    public static void main(String[] args) {
        try {
            CatchingThreadGroup group = new CatchingThreadGroup("BibleDesktopUIGroup");
            DesktopThread t = new DesktopThread((ThreadGroup)group);
            t.start();
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            ExceptionPane.showExceptionDialog(null, (Throwable)ex);
        }
    }

    public Desktop() {
        Translations.instance().setLocale();
        this.generateConfig();
        JOptionPane.setRootFrame(this);
        Reporter.grabAWTExecptions((boolean)true);
        URI predictURI = PROJECT.getWritablePropertiesURI(SPLASH_PROPS);
        Progress startJob = JobManager.createJob((String)Msg.STARTUP_TITLE.toString(), (URI)predictURI, (boolean)true);
        this.actions = new DesktopActions(this);
        startJob.setSectionName(Msg.STARTUP_GENERATE.toString());
        this.createComponents();
        this.debug();
        startJob.setSectionName(Msg.STARTUP_GENERAL_CONFIG.toString());
        this.createLayout();
        BooksListener cbl = new BooksListener(){

            public void bookAdded(BooksEvent ev) {
                Desktop.this.generateConfig();
            }

            public void bookRemoved(BooksEvent ev) {
                Desktop.this.generateConfig();
            }
        };
        Books.installed().addBooksListener(cbl);
        GuiUtil.applyDefaultOrientation((Component)this);
        startJob.done();
    }

    private void debug() {
    }

    private void createComponents() {
        this.barStatus = new StatusBar();
        this.reference = new MultiBookPane();
        this.sptBooks = new FixedSplitPane(false);
        this.sptBlog = new FixedSplitPane(false);
        this.changeSupport = new SwingPropertyChangeSupport(this);
        this.views = new ViewManager((ViewGenerator)this);
        this.views.addViewEventListener((ViewEventListener)this);
        this.history = new History();
    }

    private void createLayout() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent ev) {
                Desktop.this.actions.getAction("Exit").actionPerformed(new ActionEvent(this, 0, Desktop.EMPTY_STRING));
            }
        });
        this.setDefaultCloseOperation(2);
        TDIViewLayout tdi = (TDIViewLayout)LayoutType.TDI.getLayout();
        tdi.addPopup(this.createPopupMenu());
        this.reference.addURIEventListener(this);
        this.sptBooks.setOrientation(1);
        this.sptBooks.setRightComponent(this.reference);
        this.sptBooks.setLeftComponent(this.views.getDesktop());
        this.sptBooks.setResizeWeight(0.8);
        this.sptBooks.setOpaque(true);
        this.sptBooks.setBorder(null);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        ToolBar toolbar = this.createToolBar();
        contentPane.add((Component)toolbar, "North");
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(1, 5, 1, 5));
        this.mainPanel.add((Component)this.sptBooks, "Center");
        this.corePanel = new JPanel(new BorderLayout());
        this.corePanel.add((Component)this.mainPanel, "Center");
        this.corePanel.add((Component)this.barStatus, "South");
        contentPane.add((Component)this.corePanel, "Center");
        this.setJMenuBar(this.createMenuBar(toolbar));
        this.setIconImage(ICON_APP.getImage());
        this.setEnabled(true);
        this.setTitle(Msg.getApplicationTitle());
    }

    private JMenuBar createMenuBar(ToolBar toolbar) {
        JMenuBar barMenu = new JMenuBar();
        barMenu.add(this.createFileMenu());
        barMenu.add(this.createEditMenu());
        barMenu.add(this.createViewMenu(toolbar));
        barMenu.add(this.createGoMenu());
        barMenu.add(this.createToolsMenu());
        barMenu.add(this.createHelpMenu());
        return barMenu;
    }

    private JPopupMenu createPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        popup.add(this.views.getContextAction("NewTab")).addMouseListener(this.barStatus);
        popup.add(this.views.getContextAction("CloseView")).addMouseListener(this.barStatus);
        popup.add(this.views.getContextAction("ClearView")).addMouseListener(this.barStatus);
        popup.add(this.views.getContextAction("CloseOtherViews")).addMouseListener(this.barStatus);
        popup.add(this.views.getContextAction("CloseAllViews")).addMouseListener(this.barStatus);
        popup.addSeparator();
        popup.add(this.actions.getAction("Open")).addMouseListener(this.barStatus);
        popup.add(this.actions.getAction("Save")).addMouseListener(this.barStatus);
        popup.add(this.actions.getAction("SaveAs")).addMouseListener(this.barStatus);
        popup.add(this.actions.getAction("SaveAll")).addMouseListener(this.barStatus);
        return popup;
    }

    private ToolBar createToolBar() {
        ToolBar toolbar = new ToolBar((JFrame)this);
        toolbar.add(this.views.getContextAction("NewTab")).addMouseListener(this.barStatus);
        toolbar.add(this.actions.getAction("Open")).addMouseListener(this.barStatus);
        toolbar.add(this.actions.getAction("Save")).addMouseListener(this.barStatus);
        toolbar.addSeparator();
        toolbar.add(this.actions.getAction("Copy")).addMouseListener(this.barStatus);
        toolbar.addSeparator();
        toolbar.add(this.actions.getAction("Back")).addMouseListener(this.barStatus);
        toolbar.add(this.actions.getAction("Forward")).addMouseListener(this.barStatus);
        toolbar.addSeparator();
        toolbar.add(this.actions.getAction("Contents")).addMouseListener(this.barStatus);
        toolbar.setRollover(true);
        if (!this.actions.isOSXRegistered()) {
            toolbar.add(this.actions.getAction("About")).addMouseListener(this.barStatus);
        }
        return toolbar;
    }

    private JMenu createFileMenu() {
        JMenu menuFile = new JMenu(this.actions.getAction("File"));
        menuFile.add(this.views.getContextAction("NewTab")).addMouseListener(this.barStatus);
        menuFile.add(this.actions.getAction("Open")).addMouseListener(this.barStatus);
        menuFile.addSeparator();
        menuFile.add(this.views.getContextAction("CloseView")).addMouseListener(this.barStatus);
        menuFile.add(this.views.getContextAction("ClearView")).addMouseListener(this.barStatus);
        menuFile.add(this.views.getContextAction("CloseOtherViews")).addMouseListener(this.barStatus);
        menuFile.add(this.views.getContextAction("CloseAllViews")).addMouseListener(this.barStatus);
        menuFile.addSeparator();
        menuFile.add(this.actions.getAction("Save")).addMouseListener(this.barStatus);
        menuFile.add(this.actions.getAction("SaveAs")).addMouseListener(this.barStatus);
        menuFile.add(this.actions.getAction("SaveAll")).addMouseListener(this.barStatus);
        if (!this.actions.isOSXRegistered()) {
            menuFile.addSeparator();
            menuFile.add(this.actions.getAction("Exit")).addMouseListener(this.barStatus);
        }
        menuFile.setToolTipText(null);
        return menuFile;
    }

    private JMenu createEditMenu() {
        JMenu menuEdit = new JMenu(this.actions.getAction("Edit"));
        menuEdit.add(this.actions.getAction("Copy")).addMouseListener(this.barStatus);
        menuEdit.setToolTipText(null);
        return menuEdit;
    }

    private JMenu createGoMenu() {
        JMenu menuGo = new JMenu(this.actions.getAction("Go"));
        menuGo.add(this.actions.getAction("Back")).addMouseListener(this.barStatus);
        menuGo.add(this.actions.getAction("Forward")).addMouseListener(this.barStatus);
        return menuGo;
    }

    private JMenu createViewMenu(ToolBar toolbar) {
        JMenu menuView = new JMenu(this.actions.getAction("View"));
        JCheckBoxMenuItem toggle = new JCheckBoxMenuItem(this.actions.getAction(XSLTProperty.TINY_VERSE_NUMBERS.getName()));
        toggle.setSelected(XSLTProperty.TINY_VERSE_NUMBERS.getDefaultState());
        menuView.add(toggle).addMouseListener(this.barStatus);
        toggle = new JCheckBoxMenuItem(this.actions.getAction(XSLTProperty.START_VERSE_ON_NEWLINE.getName()));
        toggle.setSelected(XSLTProperty.START_VERSE_ON_NEWLINE.getDefaultState());
        menuView.add(toggle).addMouseListener(this.barStatus);
        JMenu verseMenu = new JMenu(this.actions.getAction("Verse"));
        menuView.add(verseMenu);
        ButtonGroup grpNumbering = new ButtonGroup();
        JRadioButtonMenuItem radio = new JRadioButtonMenuItem(this.actions.getAction(XSLTProperty.VERSE_NUMBERS.getName()));
        grpNumbering.add(radio);
        radio.setSelected(XSLTProperty.VERSE_NUMBERS.getDefaultState());
        verseMenu.add(radio).addMouseListener(this.barStatus);
        radio = new JRadioButtonMenuItem(this.actions.getAction(XSLTProperty.CV.getName()));
        grpNumbering.add(radio);
        radio.setSelected(XSLTProperty.CV.getDefaultState());
        verseMenu.add(radio).addMouseListener(this.barStatus);
        radio = new JRadioButtonMenuItem(this.actions.getAction(XSLTProperty.BCV.getName()));
        grpNumbering.add(radio);
        radio.setSelected(XSLTProperty.BCV.getDefaultState());
        verseMenu.add(radio).addMouseListener(this.barStatus);
        radio = new JRadioButtonMenuItem(this.actions.getAction(XSLTProperty.NO_VERSE_NUMBERS.getName()));
        grpNumbering.add(radio);
        radio.setSelected(XSLTProperty.NO_VERSE_NUMBERS.getDefaultState());
        verseMenu.add(radio).addMouseListener(this.barStatus);
        menuView.addSeparator();
        toggle = new JCheckBoxMenuItem(this.actions.getAction("CompareToggle"));
        menuView.add(toggle).addMouseListener(this.barStatus);
        toggle = new JCheckBoxMenuItem(this.actions.getAction(XSLTProperty.HEADINGS.getName()));
        toggle.setSelected(XSLTProperty.HEADINGS.getDefaultState());
        menuView.add(toggle).addMouseListener(this.barStatus);
        toggle = new JCheckBoxMenuItem(this.actions.getAction(XSLTProperty.NOTES.getName()));
        toggle.setSelected(XSLTProperty.NOTES.getDefaultState());
        menuView.add(toggle).addMouseListener(this.barStatus);
        toggle = new JCheckBoxMenuItem(this.actions.getAction(XSLTProperty.XREF.getName()));
        toggle.setSelected(XSLTProperty.XREF.getDefaultState());
        menuView.add(toggle).addMouseListener(this.barStatus);
        toggle = new JCheckBoxMenuItem(this.actions.getAction(XSLTProperty.STRONGS_NUMBERS.getName()));
        toggle.setSelected(XSLTProperty.STRONGS_NUMBERS.getDefaultState());
        menuView.add(toggle).addMouseListener(this.barStatus);
        toggle = new JCheckBoxMenuItem(this.actions.getAction(XSLTProperty.MORPH.getName()));
        toggle.setSelected(XSLTProperty.MORPH.getDefaultState());
        menuView.add(toggle).addMouseListener(this.barStatus);
        menuView.addSeparator();
        menuView.add(this.views.getTdiView()).addMouseListener(this.barStatus);
        menuView.add(this.views.getMdiView()).addMouseListener(this.barStatus);
        menuView.addSeparator();
        menuView.add(toolbar.getShowToggle()).addMouseListener(this.barStatus);
        menuView.add(toolbar.getTextToggle()).addMouseListener(this.barStatus);
        menuView.add(toolbar.getIconSizeToggle()).addMouseListener(this.barStatus);
        toggle = new JCheckBoxMenuItem(this.actions.getAction("ToolTipToggle"));
        toggle.setSelected(true);
        menuView.add(toggle).addMouseListener(this.barStatus);
        toggle = new JCheckBoxMenuItem(this.actions.getAction("StatusToggle"));
        toggle.setSelected(true);
        menuView.add(toggle).addMouseListener(this.barStatus);
        this.sidebarToggle = new JCheckBoxMenuItem(this.actions.getAction("SidebarToggle"));
        this.sidebarToggle.setSelected(Desktop.isSidebarShowing());
        menuView.add(this.sidebarToggle).addMouseListener(this.barStatus);
        if (viewSourceShowing) {
            menuView.addSeparator();
            menuView.add(this.actions.getAction("ViewSource")).addMouseListener(this.barStatus);
            menuView.setToolTipText(null);
        }
        return menuView;
    }

    private JMenu createToolsMenu() {
        JMenu menuTools = new JMenu(this.actions.getAction("Tools"));
        menuTools.add(this.actions.getAction("Books")).addMouseListener(this.barStatus);
        if (!this.actions.isOSXRegistered()) {
            menuTools.add(this.actions.getAction("Options")).addMouseListener(this.barStatus);
        }
        menuTools.setToolTipText(null);
        return menuTools;
    }

    private JMenu createHelpMenu() {
        JMenu menuHelp = new JMenu(this.actions.getAction("Help"));
        menuHelp.add(this.actions.getAction("Contents")).addMouseListener(this.barStatus);
        if (!this.actions.isOSXRegistered()) {
            menuHelp.addSeparator();
            menuHelp.add(this.actions.getAction("About")).addMouseListener(this.barStatus);
        }
        menuHelp.setToolTipText(null);
        return menuHelp;
    }

    public void establishPreferredSize() {
        Container contentPane = this.getContentPane();
        if (contentPane instanceof JComponent) {
            ((JComponent)contentPane).setPreferredSize(contentPane.getSize());
            log.warn("The size of the contentpane is: " + contentPane.getSize());
        }
    }

    public ViewManager getViews() {
        return this.views;
    }

    public Component createView() {
        boolean show = this.sidebarToggle == null ? Desktop.isSidebarShowing() : this.sidebarToggle.isSelected();
        BibleViewPane view = new BibleViewPane(show);
        BookDataDisplay display = view.getPassagePane().getBookDataDisplay();
        display.addURIEventListener(this);
        display.addURIEventListener(this.barStatus);
        display.setCompareBooks(compareShowing);
        this.changeSupport.addPropertyChangeListener("ComparingBooks", display);
        DisplaySelectPane dsp = view.getSelectPane();
        dsp.addCommandListener(this);
        return view;
    }

    public void viewRemoved(ViewEvent event) {
        BibleViewPane view = (BibleViewPane)((Object)event.getSource());
        BookDataDisplay display = view.getPassagePane().getBookDataDisplay();
        display.removeURIEventListener(this);
        display.removeURIEventListener(this.barStatus);
        this.changeSupport.removePropertyChangeListener("ComparingBooks", display);
        DisplaySelectPane dsp = view.getSelectPane();
        dsp.removeCommandListener(this);
    }

    public void bookChosen(DisplaySelectEvent ev) {
    }

    public void passageSelected(DisplaySelectEvent ev) {
        Key key = ev.getKey();
        if (key != null && !key.isEmpty()) {
            this.history.add((Object)key.getName());
        }
    }

    public void selectHistory(int i) {
        Object obj = this.history.go(i);
        if (obj != null) {
            this.activateURI(new URIEvent(this, BIBLE_PROTOCOL, (String)obj));
        }
    }

    public void activateURI(URIEvent ev) {
        this.barStatus.activateURI(ev);
        String protocol = ev.getScheme();
        String data = ev.getURI();
        try {
            if (protocol.equals(BIBLE_PROTOCOL)) {
                BibleViewPane view;
                BibleViewPane clearView = null;
                Iterator iter = this.views.iterator();
                while (iter.hasNext()) {
                    Component comp = (Component)iter.next();
                    BibleViewPane view2 = (BibleViewPane)((Object)comp);
                    if (view2.isClear()) {
                        clearView = view2;
                        continue;
                    }
                    Book book = view2.getSelectPane().getFirstBook();
                    if (book == null) continue;
                    Key key = book.getKey(data);
                    String dataPassage = key.getName();
                    if (!view2.getTitle().equals(dataPassage)) continue;
                    this.views.select((Component)((Object)view2));
                    return;
                }
                if (Desktop.isBibleViewReused() && (view = (BibleViewPane)((Object)this.views.getSelected())) != null) {
                    clearView = view;
                }
                if (clearView != null) {
                    Book book = clearView.getSelectPane().getFirstBook();
                    if (book != null) {
                        Key key = book.getKey(data);
                        clearView.setKey(book.createEmptyKeyList());
                        clearView.setKey(key);
                        this.views.select((Component)((Object)clearView));
                    }
                    return;
                }
                view = (BibleViewPane)((Object)this.views.addView());
                Book book = view.getSelectPane().getFirstBook();
                if (book != null) {
                    Key key = book.getKey(data);
                    view.setKey(key);
                }
            } else if (protocol.equals(COMMENTARY_PROTOCOL)) {
                Book book = Defaults.getCommentary();
                if (book != null && Books.installed().getBook(book.getName()) != null) {
                    this.reference.selectBook(book);
                    Book[] books = this.reference.getBooks();
                    Key key = books[0].getKey(data);
                    this.reference.setKey(key);
                }
            } else if (protocol.equals(GREEK_DEF_PROTOCOL)) {
                this.jump(Defaults.getGreekDefinitions(), data);
            } else if (protocol.equals(HEBREW_DEF_PROTOCOL)) {
                this.jump(Defaults.getHebrewDefinitions(), data);
            } else if (protocol.equals(GREEK_MORPH_PROTOCOL)) {
                this.jump(Defaults.getGreekParse(), data);
            } else if (protocol.equals(HEBREW_MORPH_PROTOCOL)) {
                this.jump(Defaults.getHebrewParse(), data);
            } else if (protocol.equals(DICTIONARY_PROTOCOL)) {
                this.jump(Defaults.getDictionary(), data);
            } else {
                Reporter.informUser((Object)this, (Throwable)new MalformedURLException(Msg.UNKNOWN_PROTOCOL.toString(protocol)));
            }
        }
        catch (NoSuchKeyException ex) {
            Reporter.informUser((Object)this, (LucidException)ex);
        }
    }

    private void jump(Book book, String data) {
        if (book != null && Books.installed().getBook(book.getName()) != null) {
            this.reference.selectBook(book);
            this.reference.setWord(data);
        }
    }

    public void enterURI(URIEvent ev) {
    }

    public void leaveURI(URIEvent ev) {
    }

    public void showStatusBar(boolean show) {
        if (show) {
            this.corePanel.add((Component)this.barStatus, "South");
        } else {
            this.corePanel.remove(this.barStatus);
        }
        this.validate();
    }

    public void showWebJournal(boolean show) {
        if (show) {
            this.mainPanel.remove(this.sptBooks);
            this.sptBlog.setTopComponent(this.sptBooks);
            this.mainPanel.add((Component)this.sptBlog, "Center");
        } else {
            this.mainPanel.remove(this.sptBlog);
            this.mainPanel.add((Component)this.sptBooks, "Center");
        }
        this.validate();
    }

    public void setCloseEnabled(boolean enabled) {
        this.views.getContextAction("ClearView").setEnabled(enabled);
        this.views.getContextAction("CloseOtherViews").setEnabled(enabled);
    }

    public final void generateConfig() {
        this.fillChoiceFactory();
        this.config = new Config(Msg.CONFIG_TITLE.toString());
        try {
            Document xmlconfig = XMLUtil.getDocument((String)CONFIG_KEY);
            Locale defaultLocale = Locale.getDefault();
            ResourceBundle configResources = ResourceBundle.getBundle(CONFIG_KEY, defaultLocale, (ClassLoader)CWClassLoader.instance((Class)Desktop.class));
            this.config.add(xmlconfig, configResources);
            try {
                this.config.setProperties(ResourceUtil.getProperties((String)DESKTOP_KEY));
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
                ExceptionPane.showExceptionDialog(null, (Throwable)ex);
            }
            this.config.localToApplication();
            this.config.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    BibleViewPane view;
                    if (evt.getPropertyName().equals("BibleDisplay.ConfigurableFont")) {
                        view = (BibleViewPane)((Object)Desktop.this.getViews().getSelected());
                        SplitBookDataDisplay da = view.getPassagePane();
                        da.getBookDataDisplay().refresh();
                        Desktop.this.reference.refresh();
                    }
                    if (evt.getPropertyName().equals("BibleDisplay.MaxPickers")) {
                        view = (BibleViewPane)((Object)Desktop.this.getViews().getSelected());
                        DisplaySelectPane selector = view.getSelectPane();
                        selector.getBiblePicker().enableButtons();
                    }
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            ExceptionPane.showExceptionDialog(null, (Throwable)e);
        }
        catch (JDOMException e) {
            e.printStackTrace(System.err);
            ExceptionPane.showExceptionDialog(null, (Throwable)e);
        }
    }

    public void checkForBooks() {
        int reply;
        List bibles = Books.installed().getBooks(BookFilters.getBibles());
        if (bibles.size() == 0 && (reply = CWOptionPane.showConfirmDialog((Component)this, (Object)((Object)Msg.NO_BIBLES_MESSAGE), (String)Msg.NO_BIBLES_TITLE.toString(), (int)2, (int)3)) == 0) {
            this.actions.doBooks();
        }
    }

    public static void setSidebarShowing(boolean show) {
        sidebarShowing = show;
    }

    public static boolean isSidebarShowing() {
        return sidebarShowing;
    }

    public static void setViewSourceShowing(boolean show) {
        viewSourceShowing = show;
    }

    public static boolean isViewSourceShowing() {
        return viewSourceShowing;
    }

    public void setCompareShowing(boolean show) {
        boolean old = compareShowing;
        compareShowing = show;
        this.changeSupport.firePropertyChange("ComparingBooks", old, compareShowing);
    }

    public boolean isCompareShowing() {
        return compareShowing;
    }

    public static void setWebJournalShowing(boolean show) {
        webJournalShowing = show;
    }

    public static boolean isWebJournalShowing() {
        return webJournalShowing;
    }

    public static void setBibleViewReused(boolean reuse) {
        reuseBibleView = reuse;
    }

    public static boolean isBibleViewReused() {
        return reuseBibleView;
    }

    public static void setCSSOverride(String override) {
        XSLTProperty.CSS.setState(override);
    }

    public static String getCSSOverride() {
        return XSLTProperty.CSS.getStringState();
    }

    public static void setMaxHeight(int maxHeight) {
        Desktop.defaultSize.height = maxHeight;
    }

    public static int getMaxHeight() {
        return Desktop.defaultSize.height;
    }

    public static int getMaxWidth() {
        return Desktop.defaultSize.width;
    }

    public static void setMaxWidth(int maxWidth) {
        Desktop.defaultSize.width = maxWidth;
    }

    public static Dimension getDefaultSize() {
        return defaultSize;
    }

    public static void setDefaultSize(Dimension newDefaultSize) {
        defaultSize = newDefaultSize;
    }

    final void fillChoiceFactory() {
        this.refreshBooks();
        Translations.instance().register();
        Map converters = ConverterFactory.getKnownConverters();
        Set keys = converters.keySet();
        String[] names = keys.toArray(new String[keys.size()]);
        ChoiceFactory.getDataMap().put(CONV_KEY, names);
        ConfigurableSwingConverter cstyle = new ConfigurableSwingConverter();
        String[] cstyles = cstyle.getStyles();
        ChoiceFactory.getDataMap().put(CSWING_KEY, cstyles);
    }

    protected final void refreshBooks() {
        boolean newRefBooks;
        Defaults.refreshBooks();
        boolean hasDictionaries = Defaults.getDictionary() != null;
        boolean hasCommentaries = Defaults.getCommentary() != null;
        boolean bl = newRefBooks = hasDictionaries || hasCommentaries;
        if (newRefBooks != this.hasRefBooks) {
            if (this.reference != null) {
                if (!newRefBooks) {
                    this.sptBooks.setDividerLocation(8000);
                } else {
                    int norm = (int)((double)this.sptBooks.getMaximumDividerLocation() * 0.8);
                    this.sptBooks.setDividerLocation(norm);
                }
            }
            this.hasRefBooks = newRefBooks;
        }
    }

    public Config getConfig() {
        return this.config;
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        this.actions = new DesktopActions(this);
        this.views = new ViewManager((ViewGenerator)this);
        this.views.addViewEventListener((ViewEventListener)this);
        is.defaultReadObject();
    }

    static {
        PROJECT.setHome("jsword.home", ".jsword", "JSword");
        webJournalShowing = true;
        reuseBibleView = true;
        defaultSize = new Dimension(1280, 960);
        log = Logger.getLogger((Class)Desktop.class);
        ICON_APP = GuiUtil.getIcon((String)"images/BibleDesktop16.png");
    }

    private static class DesktopRunner
    implements Runnable {
        private Desktop desktop;
        private Splash splash;

        public DesktopRunner(Desktop aDesktop, Splash aSplash) {
            this.desktop = aDesktop;
            this.splash = aSplash;
        }

        public void run() {
            this.splash.close();
            this.desktop.setVisible(true);
            this.desktop.establishPreferredSize();
            this.desktop.pack();
            this.desktop.checkForBooks();
        }
    }

    private static final class DesktopThread
    extends Thread {
        DesktopThread(ThreadGroup group) {
            super(group, "BibleDesktopUIThread");
        }

        public void run() {
            Translations.instance().setLocale();
            if (OSType.MAC.equals((Object)OSType.getOSType())) {
                System.setProperty("apple.laf.useScreenMenuBar", "true");
                System.setProperty("com.apple.mrj.application.apple.menu.about.name", Msg.getApplicationTitle());
                System.setProperty("com.apple.mrj.application.live-resize", "true");
            }
            ExceptionPane.setHelpDeskListener((boolean)true);
            LookAndFeelUtil.initialize();
            Splash splash = new Splash();
            Desktop desktop = new Desktop();
            GuiUtil.setSize((Window)desktop, (Dimension)Desktop.getDefaultSize());
            GuiUtil.centerWindow((Window)desktop);
            SwingUtilities.invokeLater(new DesktopRunner(desktop, splash));
        }
    }
}

