/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.versification;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.crosswire.common.util.CWClassLoader;
import org.crosswire.common.util.MsgBase;
import org.crosswire.common.util.StringUtil;
import org.crosswire.jsword.passage.NoSuchVerseException;
import org.crosswire.jsword.versification.BibleInfo;
import org.crosswire.jsword.versification.BookName;
import org.crosswire.jsword.versification.Msg;
import org.crosswire.jsword.versification.OSISNames;

public final class BibleNames {
    private static final String FULL_KEY = ".Full";
    private static final String SHORT_KEY = ".Short";
    private static final String ALT_KEY = ".Alt";
    public static final byte GENESIS = 1;
    public static final byte EXODUS = 2;
    public static final byte LEVITICUS = 3;
    public static final byte NUMBERS = 4;
    public static final byte DEUTERONOMY = 5;
    public static final byte JOSHUA = 6;
    public static final byte JUDGES = 7;
    public static final byte RUTH = 8;
    public static final byte SAMUEL1 = 9;
    public static final byte SAMUEL2 = 10;
    public static final byte KINGS1 = 11;
    public static final byte KINGS2 = 12;
    public static final byte CHRONICLES1 = 13;
    public static final byte CHRONICLES2 = 14;
    public static final byte EZRA = 15;
    public static final byte NEHEMIAH = 16;
    public static final byte ESTHER = 17;
    public static final byte JOB = 18;
    public static final byte PSALMS = 19;
    public static final byte PROVERBS = 20;
    public static final byte ECCLESIASTES = 21;
    public static final byte SONGOFSOLOMON = 22;
    public static final byte ISAIAH = 23;
    public static final byte JEREMIAH = 24;
    public static final byte LAMENTATIONS = 25;
    public static final byte EZEKIEL = 26;
    public static final byte DANIEL = 27;
    public static final byte HOSEA = 28;
    public static final byte JOEL = 29;
    public static final byte AMOS = 30;
    public static final byte OBADIAH = 31;
    public static final byte JONAH = 32;
    public static final byte MICAH = 33;
    public static final byte NAHUM = 34;
    public static final byte HABAKKUK = 35;
    public static final byte ZEPHANIAH = 36;
    public static final byte HAGGAI = 37;
    public static final byte ZECHARIAH = 38;
    public static final byte MALACHI = 39;
    public static final byte MATTHEW = 40;
    public static final byte MARK = 41;
    public static final byte LUKE = 42;
    public static final byte JOHN = 43;
    public static final byte ACTS = 44;
    public static final byte ROMANS = 45;
    public static final byte CORINTHIANS1 = 46;
    public static final byte CORINTHIANS2 = 47;
    public static final byte GALATIANS = 48;
    public static final byte EPHESIANS = 49;
    public static final byte PHILIPPIANS = 50;
    public static final byte COLOSSIANS = 51;
    public static final byte THESSALONIANS1 = 52;
    public static final byte THESSALONIANS2 = 53;
    public static final byte TIMOTHY1 = 54;
    public static final byte TIMOTHY2 = 55;
    public static final byte TITUS = 56;
    public static final byte PHILEMON = 57;
    public static final byte HEBREWS = 58;
    public static final byte JAMES = 59;
    public static final byte PETER1 = 60;
    public static final byte PETER2 = 61;
    public static final byte JOHN1 = 62;
    public static final byte JOHN2 = 63;
    public static final byte JOHN3 = 64;
    public static final byte JUDE = 65;
    public static final byte REVELATION = 66;
    private BookName[] books;
    private Locale locale;
    private Map fullBooksMap;
    private Map shortBooksMap;
    private Map altBooksMap;
    static final /* synthetic */ boolean $assertionsDisabled;

    public BibleNames(Locale locale) {
        this.locale = locale;
        this.initialize();
    }

    public BookName getName(int book) throws NoSuchVerseException {
        try {
            return this.books[book - 1];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new NoSuchVerseException((MsgBase)Msg.BOOKS_BOOK, new Object[]{new Integer(book)});
        }
    }

    public String getPreferredName(int book) throws NoSuchVerseException {
        return this.getName(book).getPreferredName();
    }

    public String getLongName(int book) throws NoSuchVerseException {
        return this.getName(book).getLongName();
    }

    public String getShortName(int book) throws NoSuchVerseException {
        return this.getName(book).getShortName();
    }

    public int getNumber(String find) {
        String match = BookName.normalize(find, this.locale);
        BookName bookName = (BookName)this.fullBooksMap.get(match);
        if (bookName != null) {
            return bookName.getNumber();
        }
        bookName = (BookName)this.shortBooksMap.get(match);
        if (bookName != null) {
            return bookName.getNumber();
        }
        bookName = (BookName)this.altBooksMap.get(match);
        if (bookName != null) {
            return bookName.getNumber();
        }
        for (int i = 0; i < this.books.length; ++i) {
            bookName = this.books[i];
            if (!bookName.match(match)) continue;
            return bookName.getNumber();
        }
        return -1;
    }

    public boolean isBookName(String find) {
        return this.getNumber(find) != -1;
    }

    private void initialize() {
        int booksInBible = BibleInfo.booksInBible();
        this.books = new BookName[booksInBible];
        this.fullBooksMap = new HashMap(booksInBible);
        this.shortBooksMap = new HashMap(booksInBible);
        this.altBooksMap = new HashMap(booksInBible);
        ResourceBundle resources = ResourceBundle.getBundle(BibleNames.class.getName(), this.locale, (ClassLoader)CWClassLoader.instance((Class)BibleNames.class));
        for (int i = 0; i < booksInBible; ++i) {
            BookName bookName;
            String osisName;
            block5: {
                osisName = "";
                try {
                    osisName = OSISNames.getName(i + 1);
                }
                catch (NoSuchVerseException e) {
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError();
                }
            }
            String fullBook = this.getString(resources, osisName + FULL_KEY);
            String shortBook = this.getString(resources, osisName + SHORT_KEY);
            if (shortBook.length() == 0) {
                shortBook = fullBook;
            }
            String altBook = this.getString(resources, osisName + ALT_KEY);
            this.books[i] = bookName = new BookName(this.locale, i + 1, fullBook, shortBook, altBook);
            this.fullBooksMap.put(bookName.getNormalizedLongName(), bookName);
            this.shortBooksMap.put(bookName.getNormalizedShortName(), bookName);
            String[] alternates = StringUtil.split((String)altBook, (char)',');
            for (int j = 0; j < alternates.length; ++j) {
                this.altBooksMap.put(alternates[j], bookName);
            }
        }
    }

    private String getString(ResourceBundle resources, String key) {
        try {
            return resources.getString(key);
        }
        catch (MissingResourceException e) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }
    }

    static {
        $assertionsDisabled = !BibleNames.class.desiredAssertionStatus();
    }
}

