/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.passage;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;
import org.crosswire.jsword.passage.AbstractPassage;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.KeyUtil;
import org.crosswire.jsword.passage.NoSuchVerseException;
import org.crosswire.jsword.passage.Passage;
import org.crosswire.jsword.passage.RestrictionType;
import org.crosswire.jsword.passage.Verse;
import org.crosswire.jsword.passage.VerseRange;

public class RangedPassage
extends AbstractPassage {
    static final long serialVersionUID = 955115811339960826L;
    private transient SortedSet store = new TreeSet();
    static /* synthetic */ Class class$org$crosswire$jsword$passage$RangedPassage;

    protected RangedPassage() {
    }

    protected RangedPassage(String refs) throws NoSuchVerseException {
        super(refs);
        this.addVerses(refs);
        this.normalize();
    }

    public Object clone() {
        RangedPassage copy = (RangedPassage)super.clone();
        copy.store = new TreeSet();
        copy.store.addAll(this.store);
        return copy;
    }

    public int countRanges(RestrictionType restrict) {
        if (restrict.equals(RestrictionType.NONE)) {
            return this.store.size();
        }
        return super.countRanges(restrict);
    }

    public int countVerses() {
        Iterator it = this.rangeIterator(RestrictionType.NONE);
        int count = 0;
        while (it.hasNext()) {
            VerseRange range = (VerseRange)it.next();
            count += range.getCardinality();
        }
        return count;
    }

    public Iterator iterator() {
        return new VerseIterator(this.rangeIterator(RestrictionType.NONE));
    }

    public final Iterator rangeIterator(RestrictionType restrict) {
        if (restrict.equals(RestrictionType.NONE)) {
            return this.store.iterator();
        }
        return new VerseRangeIterator(this.store.iterator(), restrict);
    }

    public boolean isEmpty() {
        return this.store.isEmpty();
    }

    public boolean contains(Key obj) {
        VerseRange that_range = RangedPassage.toVerseRange(obj);
        Iterator it = this.rangeIterator(RestrictionType.NONE);
        while (it.hasNext()) {
            VerseRange this_range = (VerseRange)it.next();
            if (!this_range.contains(that_range)) continue;
            return true;
        }
        return false;
    }

    public void add(Key obj) {
        this.optimizeWrites();
        VerseRange that_range = RangedPassage.toVerseRange(obj);
        this.store.add(that_range);
        this.normalize();
        if (this.suppressEvents == 0) {
            this.fireIntervalAdded(this, that_range.getStart(), that_range.getEnd());
        }
    }

    public void clear() {
        this.optimizeWrites();
        this.store.clear();
        this.fireIntervalRemoved(this, null, null);
    }

    public void remove(Key obj) {
        this.optimizeWrites();
        VerseRange that_range = RangedPassage.toVerseRange(obj);
        boolean removed = false;
        TreeSet new_store = new TreeSet();
        new_store.addAll(this.store);
        Iterator iter = new_store.iterator();
        while (iter.hasNext()) {
            VerseRange this_range = (VerseRange)iter.next();
            if (!this_range.overlaps(that_range)) continue;
            this.store.remove(this_range);
            VerseRange[] vra = VerseRange.remainder(this_range, that_range);
            for (int i = 0; i < vra.length; ++i) {
                this.store.add(vra[i]);
            }
            removed = true;
        }
        if (removed) {
            this.normalize();
        }
        if (this.suppressEvents == 0) {
            this.fireIntervalRemoved(this, that_range.getStart(), that_range.getEnd());
        }
    }

    public void retainAll(Key key) {
        Passage that = KeyUtil.getPassage(key);
        this.optimizeWrites();
        TreeSet<VerseRange> new_store = new TreeSet<VerseRange>();
        Iterator that_it = null;
        that_it = that instanceof RangedPassage ? that.rangeIterator(RestrictionType.CHAPTER) : that.iterator();
        while (that_it.hasNext()) {
            VerseRange that_range = RangedPassage.toVerseRange(that_it.next());
            Iterator this_it = this.rangeIterator(RestrictionType.NONE);
            while (this_it.hasNext()) {
                VerseRange interstect;
                VerseRange this_range = (VerseRange)this_it.next();
                if (!this_range.overlaps(that_range) || (interstect = VerseRange.intersection(this_range, that_range)) == null) continue;
                new_store.add(interstect);
            }
        }
        this.store = new_store;
        this.normalize();
        this.fireIntervalRemoved(this, null, null);
    }

    final void normalize() {
        if (this.skipNormalization != 0) {
            return;
        }
        VerseRange last = null;
        VerseRange next = null;
        TreeSet<VerseRange> new_store = new TreeSet<VerseRange>();
        Iterator it = this.rangeIterator(RestrictionType.NONE);
        while (it.hasNext()) {
            next = (VerseRange)it.next();
            if (last != null && next.adjacentTo(last)) {
                VerseRange merge = new VerseRange(last, next);
                new_store.remove(last);
                new_store.add(merge);
                last = merge;
                continue;
            }
            new_store.add(next);
            last = next;
        }
        this.store = new_store;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.writeObjectSupport(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.optimizeWrites();
        this.store = new TreeSet();
        in.defaultReadObject();
        this.readObjectSupport(in);
    }

    private static final class VerseRangeIterator
    implements Iterator {
        private VerseRange next;
        private RestrictionType restrict;
        private Iterator real;
        static final /* synthetic */ boolean $assertionsDisabled;

        public VerseRangeIterator(Iterator it, RestrictionType restrict) {
            this.restrict = restrict;
            this.real = it;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            return this.next != null || this.real.hasNext();
        }

        public Object next() {
            if (this.next == null) {
                this.next = (VerseRange)this.real.next();
            }
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            if (this.restrict.isSameScope(this.next.getStart(), this.next.getEnd())) {
                return this.replyNext();
            }
            return this.splitNext();
        }

        private Key replyNext() {
            VerseRange reply = this.next;
            this.next = null;
            return reply;
        }

        private Key splitNext() {
            Iterator chop = this.next.rangeIterator(this.restrict);
            VerseRange first = (VerseRange)chop.next();
            VerseRange[] ranges = VerseRange.remainder(this.next, first);
            if (!$assertionsDisabled && ranges.length != 1) {
                throw new AssertionError();
            }
            this.next = ranges[0];
            return first;
        }

        static {
            $assertionsDisabled = !(class$org$crosswire$jsword$passage$RangedPassage == null ? (class$org$crosswire$jsword$passage$RangedPassage = RangedPassage.class$("org.crosswire.jsword.passage.RangedPassage")) : class$org$crosswire$jsword$passage$RangedPassage).desiredAssertionStatus();
        }
    }

    private static final class VerseIterator
    implements Iterator {
        private Iterator real;
        static final /* synthetic */ boolean $assertionsDisabled;

        public VerseIterator(Iterator it) {
            block4: {
                try {
                    TreeSet<Verse> temp = new TreeSet<Verse>();
                    while (it.hasNext()) {
                        VerseRange range = (VerseRange)it.next();
                        for (int i = 0; i < range.getCardinality(); ++i) {
                            temp.add(new Verse(range.getStart().getOrdinal() + i));
                        }
                    }
                    this.real = temp.iterator();
                }
                catch (NoSuchVerseException ex) {
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError((Object)ex);
                }
            }
        }

        public boolean hasNext() {
            return this.real.hasNext();
        }

        public Object next() throws NoSuchElementException {
            return this.real.next();
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        static {
            $assertionsDisabled = !(class$org$crosswire$jsword$passage$RangedPassage == null ? (class$org$crosswire$jsword$passage$RangedPassage = RangedPassage.class$("org.crosswire.jsword.passage.RangedPassage")) : class$org$crosswire$jsword$passage$RangedPassage).desiredAssertionStatus();
        }
    }
}

