/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.index.lucene;

import java.io.IOException;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.DataPolice;
import org.crosswire.jsword.book.study.StrongsNumber;

public class StrongsNumberFilter
extends TokenFilter {
    public StrongsNumberFilter(TokenStream in) {
        super(in);
    }

    public final Token next() throws IOException {
        Token token = this.input.next();
        if (token == null) {
            return null;
        }
        try {
            String s = new StrongsNumber(token.termText()).getStrongsNumber();
            if (!s.equals(token.termText())) {
                token.setTermText(s);
            }
        }
        catch (BookException e) {
            DataPolice.report(e.getDetailedMessage());
        }
        return token;
    }
}

