/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.passage;

import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import org.crosswire.jsword.passage.AbstractPassage;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.KeyFactory;
import org.crosswire.jsword.passage.Msg;
import org.crosswire.jsword.passage.NoSuchKeyException;
import org.crosswire.jsword.passage.NoSuchVerseException;
import org.crosswire.jsword.passage.Passage;
import org.crosswire.jsword.passage.PassageType;
import org.crosswire.jsword.passage.ReadOnlyPassage;
import org.crosswire.jsword.passage.RestrictionType;
import org.crosswire.jsword.passage.SynchronizedPassage;
import org.crosswire.jsword.passage.Verse;
import org.crosswire.jsword.passage.VerseRange;
import org.crosswire.jsword.versification.BibleInfo;

public final class PassageKeyFactory
implements KeyFactory {
    private static KeyFactory keyf;
    private static Passage whole;
    private static PassageType defaultType;
    static final /* synthetic */ boolean $assertionsDisabled;

    private PassageKeyFactory() {
    }

    public static KeyFactory instance() {
        return keyf;
    }

    public Key createEmptyKeyList() {
        return defaultType.createEmptyPassage();
    }

    public Key getValidKey(String name) {
        try {
            return this.getKey(name);
        }
        catch (NoSuchKeyException e) {
            return this.createEmptyKeyList();
        }
    }

    public Key getKey(String name) throws NoSuchKeyException {
        try {
            return defaultType.createPassage(name);
        }
        catch (Exception e) {
            try {
                return defaultType.createPassage(this.normalize(name));
            }
            catch (Exception e1) {
                return defaultType.createPassage(this.mungOsisRef(name));
            }
        }
    }

    public Key getGlobalKeyList() {
        try {
            if (whole == null) {
                whole = new ReadOnlyPassage(defaultType.createPassage("Gen 1:1-Rev 22:21"), true);
            }
            return whole;
        }
        catch (NoSuchKeyException ex) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)ex);
            }
            return defaultType.createEmptyPassage();
        }
    }

    public static void setDefaultPassage(int newDefaultType) {
        defaultType = PassageType.fromInteger(newDefaultType);
    }

    public static int getDefaultPassage() {
        return PassageType.toInteger(defaultType);
    }

    public static Passage getSynchronizedPassage(Passage ref) {
        return new SynchronizedPassage(ref);
    }

    public static Passage getReadOnlyPassage(Passage ref, boolean ignore) {
        return new ReadOnlyPassage(ref, ignore);
    }

    public static byte[] toBinaryRepresentation(Passage ref) {
        int verses = ref.countVerses();
        int ranges = ref.countRanges(RestrictionType.NONE);
        int bitwise_size = BibleInfo.versesInBible() / 8;
        int ranged_size = ranges * 4 + 1;
        int distinct_size = verses * 2 + 1;
        if (bitwise_size <= ranged_size && bitwise_size <= distinct_size) {
            int array_size = PassageKeyFactory.binarySize(3) + BibleInfo.versesInBible() / 8 + 1;
            byte[] buffer = new byte[array_size];
            int index = 0;
            index += PassageKeyFactory.toBinary(buffer, index, 0, 3);
            Iterator it = ref.iterator();
            while (it.hasNext()) {
                Verse verse = (Verse)it.next();
                int ord = verse.getOrdinal();
                int idx0 = ord / 8 + index;
                int bit = ord % 8 - 1;
                int n = idx0;
                buffer[n] = (byte)(buffer[n] | 1 << bit);
            }
            return buffer;
        }
        if (distinct_size <= ranged_size) {
            int array_size = PassageKeyFactory.binarySize(3) + PassageKeyFactory.binarySize(BibleInfo.versesInBible()) + verses * PassageKeyFactory.binarySize(BibleInfo.versesInBible());
            byte[] buffer = new byte[array_size];
            int index = 0;
            index += PassageKeyFactory.toBinary(buffer, index, 1, 3);
            index += PassageKeyFactory.toBinary(buffer, index, verses, BibleInfo.versesInBible());
            Iterator it = ref.iterator();
            while (it.hasNext()) {
                Verse verse = (Verse)it.next();
                int ord = verse.getOrdinal();
                index += PassageKeyFactory.toBinary(buffer, index, ord, BibleInfo.versesInBible());
            }
            return buffer;
        }
        int array_size = PassageKeyFactory.binarySize(3) + PassageKeyFactory.binarySize(BibleInfo.versesInBible() / 2) + 2 * ranges * PassageKeyFactory.binarySize(BibleInfo.versesInBible());
        byte[] buffer = new byte[array_size];
        int index = 0;
        index += PassageKeyFactory.toBinary(buffer, index, 2, 3);
        index += PassageKeyFactory.toBinary(buffer, index, ranges, BibleInfo.versesInBible() / 2);
        Iterator it = ref.rangeIterator(RestrictionType.NONE);
        while (it.hasNext()) {
            VerseRange range = (VerseRange)it.next();
            index += PassageKeyFactory.toBinary(buffer, index, range.getStart().getOrdinal(), BibleInfo.versesInBible());
            index += PassageKeyFactory.toBinary(buffer, index, range.getCardinality(), BibleInfo.versesInBible());
        }
        return buffer;
    }

    public static Passage fromBinaryRepresentation(byte[] buffer) throws NoSuchVerseException {
        Passage ref = (Passage)keyf.createEmptyKeyList();
        AbstractPassage aref = null;
        if (ref instanceof AbstractPassage) {
            aref = (AbstractPassage)ref;
            aref.raiseEventSuppresion();
            aref.raiseNormalizeProtection();
        }
        int[] index = new int[]{0};
        int type = PassageKeyFactory.fromBinary(buffer, index, 3);
        switch (type) {
            case 0: {
                for (int ord = 1; ord <= BibleInfo.versesInBible(); ++ord) {
                    int idx0 = ord / 8 + index[0];
                    int bit = ord % 8 - 1;
                    if ((buffer[idx0] & 1 << bit) == 0) continue;
                    ref.add(new Verse(ord));
                }
                break;
            }
            case 1: {
                int verses = PassageKeyFactory.fromBinary(buffer, index, BibleInfo.versesInBible());
                for (int i = 0; i < verses; ++i) {
                    int ord = PassageKeyFactory.fromBinary(buffer, index, BibleInfo.versesInBible());
                    ref.add(new Verse(ord));
                }
                break;
            }
            case 2: {
                int ranges = PassageKeyFactory.fromBinary(buffer, index, BibleInfo.versesInBible() / 2);
                for (int i = 0; i < ranges; ++i) {
                    int ord = PassageKeyFactory.fromBinary(buffer, index, BibleInfo.versesInBible());
                    int len = PassageKeyFactory.fromBinary(buffer, index, BibleInfo.versesInBible());
                    ref.add(RestrictionType.NONE.toRange(new Verse(ord), len));
                }
                break;
            }
            default: {
                throw new NoSuchVerseException(Msg.PASSAGE_UNKNOWN);
            }
        }
        if (aref != null) {
            aref.lowerEventSuppresionAndTest();
            aref.lowerNormalizeProtection();
        }
        return ref;
    }

    public static Passage readPassage(Reader in) throws IOException, NoSuchVerseException {
        Passage ref = (Passage)keyf.createEmptyKeyList();
        ref.readDescription(in);
        return ref;
    }

    protected static int binarySize(int max) {
        if (max < 256) {
            return 1;
        }
        if (max < 65536) {
            return 2;
        }
        if (max < 0x1000000) {
            return 3;
        }
        return 4;
    }

    protected static int toBinary(byte[] buffer, int index, int number, int max) {
        if (!$assertionsDisabled && number < 0) {
            throw new AssertionError((Object)("No -ve output " + number));
        }
        if (!$assertionsDisabled && number > max) {
            throw new AssertionError((Object)("number " + number + " > max " + max));
        }
        if (max < 256) {
            buffer[index] = (byte)number;
            return 1;
        }
        if (max < 65536) {
            buffer[index + 0] = (byte)(number >>> 8);
            buffer[index + 1] = (byte)(number >>> 0);
            return 2;
        }
        if (max < 0x1000000) {
            buffer[index + 0] = (byte)(number >>> 16);
            buffer[index + 1] = (byte)(number >>> 8);
            buffer[index + 2] = (byte)(number >>> 0);
            return 3;
        }
        buffer[index + 0] = (byte)(number >>> 24);
        buffer[index + 1] = (byte)(number >>> 16);
        buffer[index + 2] = (byte)(number >>> 8);
        buffer[index + 3] = (byte)(number >>> 0);
        return 4;
    }

    protected static int fromBinary(byte[] buffer, int[] index, int max) {
        int n = index[0];
        index[0] = n + 1;
        int b0 = buffer[n] & 0xFF;
        if (max < 256) {
            return b0;
        }
        int n2 = index[0];
        index[0] = n2 + 1;
        int b1 = buffer[n2] & 0xFF;
        if (max < 65536) {
            return (b0 << 8) + (b1 << 0);
        }
        int n3 = index[0];
        index[0] = n3 + 1;
        int b2 = buffer[n3] & 0xFF;
        if (max < 0x1000000) {
            return (b0 << 16) + (b1 << 8) + (b2 << 0);
        }
        int n4 = index[0];
        index[0] = n4 + 1;
        int b3 = buffer[n4] & 0xFF;
        return (b0 << 24) + (b1 << 16) + (b2 << 8) + (b3 << 0);
    }

    private String mungOsisRef(String name) {
        return name.replace(' ', ';');
    }

    private String normalize(String name) {
        if (name == null) {
            return null;
        }
        int size = name.length();
        StringBuffer buf = new StringBuffer(size * 2);
        char curChar = ' ';
        boolean isNumber = false;
        boolean wasNumber = false;
        int i = 0;
        while (i < size) {
            curChar = name.charAt(i);
            boolean bl = curChar == '$' || Character.isDigit(curChar) || curChar == 'f' && (i + 1 < size ? (int)name.charAt(i + 1) : 32) == 102 ? true : (isNumber = false);
            if (wasNumber) {
                if (isNumber) {
                    buf.append(", ");
                } else if (Character.isLetter(curChar)) {
                    buf.append(' ');
                }
                wasNumber = false;
            }
            if (isNumber) {
                wasNumber = true;
                buf.append(curChar);
                ++i;
                if (curChar == 'f') {
                    buf.append('f');
                    ++i;
                } else if (curChar != '$') {
                    while (i < size && Character.isDigit(curChar = name.charAt(i))) {
                        buf.append(curChar);
                        ++i;
                    }
                }
                while (i < size && Character.isWhitespace(name.charAt(i))) {
                    ++i;
                }
                continue;
            }
            buf.append(curChar);
            ++i;
        }
        return buf.toString();
    }

    static {
        $assertionsDisabled = !PassageKeyFactory.class.desiredAssertionStatus();
        keyf = new PassageKeyFactory();
        defaultType = PassageType.SPEED;
    }
}

