/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URI;
import org.crosswire.common.activate.Activatable;
import org.crosswire.common.activate.Activator;
import org.crosswire.common.activate.Lock;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.LucidException;
import org.crosswire.common.util.MsgBase;
import org.crosswire.common.util.NetUtil;
import org.crosswire.common.util.Reporter;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.sword.AbstractBackend;
import org.crosswire.jsword.book.sword.DataIndex;
import org.crosswire.jsword.book.sword.Msg;
import org.crosswire.jsword.book.sword.SwordBookMetaData;
import org.crosswire.jsword.book.sword.SwordConstants;
import org.crosswire.jsword.book.sword.SwordUtil;
import org.crosswire.jsword.book.sword.UserMsg;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.KeyUtil;
import org.crosswire.jsword.passage.Verse;

public class RawBackend
extends AbstractBackend {
    private boolean active;
    private int datasize;
    private int entrysize;
    private static final Logger log;
    private RandomAccessFile[] idxRaf = new RandomAccessFile[3];
    private RandomAccessFile[] txtRaf = new RandomAccessFile[3];
    private File[] idxFile = new File[3];
    private File[] txtFile = new File[3];
    private static final int OFFSETSIZE = 4;
    static final /* synthetic */ boolean $assertionsDisabled;

    public RawBackend(SwordBookMetaData sbmd, int datasize) {
        super(sbmd);
        this.datasize = datasize;
        this.entrysize = 4 + datasize;
        if (!$assertionsDisabled && datasize != 2 && datasize != 4) {
            throw new AssertionError();
        }
    }

    public boolean contains(Key key) {
        this.checkActive();
        Verse verse = KeyUtil.getVerse(key);
        try {
            int testament = SwordConstants.getTestament(verse);
            long index = SwordConstants.getIndex(verse);
            if (this.idxRaf[testament] == null) {
                return false;
            }
            DataIndex dataIndex = this.getIndex(this.idxRaf[testament], index);
            return dataIndex.getSize() > 0;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public String getRawText(Key key) throws BookException {
        this.checkActive();
        Verse verse = KeyUtil.getVerse(key);
        try {
            int testament = SwordConstants.getTestament(verse);
            long index = SwordConstants.getIndex(verse);
            if (this.idxRaf[testament] == null) {
                return "";
            }
            return this.getEntry(key.getName(), testament, index);
        }
        catch (IOException ex) {
            throw new BookException(UserMsg.READ_FAIL, ex, new Object[]{verse.getName()});
        }
    }

    public boolean isWritable() {
        if (this.idxFile[1].canRead() && (this.idxFile[1].canWrite() || !this.txtFile[1].canWrite())) {
            return false;
        }
        if (this.idxFile[2].canRead() && (this.idxFile[2].canWrite() || !this.txtFile[2].canWrite())) {
            return false;
        }
        return this.idxFile[1].canRead() || this.idxFile[2].canRead();
    }

    public void create(String path) {
        this.idxFile[1] = new File(path + File.separator + "ot" + ".vss");
        this.txtFile[1] = new File(path + File.separator + "ot");
        this.idxFile[2] = new File(path + File.separator + "nt" + ".vss");
        this.txtFile[2] = new File(path + File.separator + "nt");
    }

    public final void activate(Lock lock) {
        String fileMode;
        URI path = null;
        try {
            path = this.getExpandedDataPath();
        }
        catch (BookException e) {
            Reporter.informUser((Object)this, (LucidException)e);
            return;
        }
        URI otPath = NetUtil.lengthenURI((URI)path, (String)(File.separator + "ot"));
        this.txtFile[1] = new File(otPath.getPath());
        this.idxFile[1] = new File(otPath.getPath() + ".vss");
        URI ntPath = NetUtil.lengthenURI((URI)path, (String)(File.separator + "nt"));
        this.txtFile[2] = new File(ntPath.getPath());
        this.idxFile[2] = new File(ntPath.getPath() + ".vss");
        if (!this.txtFile[1].canRead() && !this.txtFile[2].canRead()) {
            Reporter.informUser((Object)this, (LucidException)new BookException((MsgBase)Msg.MISSING_FILE, new Object[]{path}));
            return;
        }
        String string = fileMode = this.isWritable() ? "rw" : "r";
        if (this.idxFile[1].canRead()) {
            try {
                this.idxRaf[1] = new RandomAccessFile(this.idxFile[1], fileMode);
                this.txtRaf[1] = new RandomAccessFile(this.txtFile[1], fileMode);
            }
            catch (FileNotFoundException ex) {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)ex);
                }
                log.error("Could not open OT", (Throwable)ex);
                this.idxRaf[1] = null;
                this.txtRaf[1] = null;
            }
        }
        if (this.idxFile[2].canRead()) {
            try {
                this.idxRaf[2] = new RandomAccessFile(this.idxFile[2], fileMode);
                this.txtRaf[2] = new RandomAccessFile(this.txtFile[2], fileMode);
            }
            catch (FileNotFoundException ex) {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)ex);
                }
                log.error("Could not open NT", (Throwable)ex);
                this.idxRaf[2] = null;
                this.txtRaf[2] = null;
            }
        }
        this.active = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deactivate(Lock lock) {
        try {
            this.idxRaf[1].close();
            this.txtRaf[1].close();
            this.idxRaf[2].close();
            this.txtRaf[2].close();
        }
        catch (IOException ex) {
            log.error("Failed to close files", (Throwable)ex);
        }
        finally {
            this.idxRaf[1] = null;
            this.txtRaf[1] = null;
            this.idxRaf[2] = null;
            this.txtRaf[2] = null;
        }
        this.active = false;
    }

    protected final void checkActive() {
        if (!this.active) {
            Activator.activate((Activatable)this);
        }
    }

    private DataIndex getIndex(RandomAccessFile raf, long entry) throws IOException {
        byte[] buffer = SwordUtil.readRAF(raf, entry * (long)this.entrysize, this.entrysize);
        if (buffer == null || buffer.length == 0) {
            return new DataIndex(0, 0);
        }
        int entryOffset = SwordUtil.decodeLittleEndian32(buffer, 0);
        int entrySize = -1;
        switch (this.datasize) {
            case 2: {
                entrySize = SwordUtil.decodeLittleEndian16(buffer, 4);
                break;
            }
            case 4: {
                entrySize = SwordUtil.decodeLittleEndian32(buffer, 4);
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError(this.datasize);
                }
                break;
            }
        }
        return new DataIndex(entryOffset, entrySize);
    }

    private String getEntry(String name, int testament, long index) throws IOException {
        DataIndex dataIndex = this.getIndex(this.idxRaf[testament], index);
        int size = dataIndex.getSize();
        if (size == 0) {
            return "";
        }
        if (size < 0) {
            log.error("In " + this.getBookMetaData().getInitials() + ": Verse " + name + " has a bad index size of " + size);
            return "";
        }
        byte[] data = SwordUtil.readRAF(this.txtRaf[testament], dataIndex.getOffset(), size);
        this.decipher(data);
        return SwordUtil.decode(name, data, this.getBookMetaData().getBookCharset());
    }

    static {
        $assertionsDisabled = !RawBackend.class.desiredAssertionStatus();
        log = Logger.getLogger((Class)RawBackend.class);
    }
}

