/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.crosswire.common.activate.Activatable;
import org.crosswire.common.activate.Activator;
import org.crosswire.common.util.CollectionUtil;
import org.crosswire.common.util.EventListenerList;
import org.crosswire.common.util.Iterable;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.LucidException;
import org.crosswire.common.util.MsgBase;
import org.crosswire.common.util.PluginUtil;
import org.crosswire.common.util.Reporter;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookDriver;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.BookFilter;
import org.crosswire.jsword.book.BookFilterIterator;
import org.crosswire.jsword.book.BookFilters;
import org.crosswire.jsword.book.BookList;
import org.crosswire.jsword.book.BookMetaData;
import org.crosswire.jsword.book.BookSet;
import org.crosswire.jsword.book.BooksEvent;
import org.crosswire.jsword.book.BooksListener;
import org.crosswire.jsword.book.Msg;

public final class Books
implements BookList {
    private BookSet books = new BookSet();
    private Set drivers = new HashSet();
    private EventListenerList listeners = new EventListenerList();
    private boolean threaded = false;
    private static final Logger log = Logger.getLogger((Class)Books.class);
    private static final Books instance = new Books();

    private Books() {
        this.initialize(this.threaded);
    }

    public static Books installed() {
        return instance;
    }

    public synchronized List getBooks() {
        return new BookSet((Collection)this.books);
    }

    public synchronized Book getBook(String name) {
        Book book;
        if (name == null) {
            return null;
        }
        Iterator iter = this.books.iterator();
        while (iter.hasNext()) {
            book = (Book)iter.next();
            if (!name.equals(book.getName())) continue;
            return book;
        }
        iter = this.books.iterator();
        while (iter.hasNext()) {
            book = (Book)iter.next();
            if (!name.equalsIgnoreCase(book.getName())) continue;
            return book;
        }
        iter = this.books.iterator();
        while (iter.hasNext()) {
            book = (Book)iter.next();
            BookMetaData bmd = book.getBookMetaData();
            if (!name.equals(bmd.getInitials())) continue;
            return book;
        }
        iter = this.books.iterator();
        while (iter.hasNext()) {
            book = (Book)iter.next();
            if (!name.equalsIgnoreCase(book.getInitials())) continue;
            return book;
        }
        return null;
    }

    public synchronized List getBooks(BookFilter filter) {
        List temp = CollectionUtil.createList((Iterable)new BookFilterIterator(this.getBooks(), filter));
        return new BookSet((Collection)temp);
    }

    public int getMaxLength(String propertyKey) {
        int max = -1;
        List bookList = this.getBooks();
        Iterator iter = bookList.iterator();
        while (iter.hasNext()) {
            Book book = (Book)iter.next();
            Object property = book.getProperty(propertyKey);
            if (property == null) continue;
            String value = property instanceof String ? (String)property : property.toString();
            max = Math.max(max, value.length());
        }
        return max;
    }

    public int getMaxLength(String propertyKey, BookFilter filter) {
        int max = -1;
        List bookList = this.getBooks(filter);
        Iterator iter = bookList.iterator();
        while (iter.hasNext()) {
            Book book = (Book)iter.next();
            Object property = book.getProperty(propertyKey);
            if (property == null) continue;
            String value = property instanceof String ? (String)property : property.toString();
            max = Math.max(max, value.length());
        }
        return max;
    }

    public synchronized void addBooksListener(BooksListener li) {
        this.listeners.add(BooksListener.class, (EventListener)li);
    }

    public synchronized void removeBooksListener(BooksListener li) {
        this.listeners.remove(BooksListener.class, (EventListener)li);
    }

    protected synchronized void fireBooksChanged(Object source, Book book, boolean added) {
        Object[] contents = this.listeners.getListenerList();
        BooksEvent ev = null;
        for (int i = contents.length - 2; i >= 0; i -= 2) {
            if (contents[i] != (class$org$crosswire$jsword$book$BooksListener == null ? Books.class$("org.crosswire.jsword.book.BooksListener") : class$org$crosswire$jsword$book$BooksListener)) continue;
            if (ev == null) {
                ev = new BooksEvent(source, book, added);
            }
            if (added) {
                ((BooksListener)contents[i + 1]).bookAdded(ev);
                continue;
            }
            ((BooksListener)contents[i + 1]).bookRemoved(ev);
        }
    }

    public synchronized void addBook(Book book) {
        this.books.add(book);
        this.fireBooksChanged(instance, book, true);
    }

    public synchronized void removeBook(Book book) throws BookException {
        Activator.deactivate((Activatable)book);
        boolean removed = this.books.remove(book);
        if (!removed) {
            throw new BookException(Msg.BOOK_NOREMOVE);
        }
        this.fireBooksChanged(instance, book, true);
    }

    public synchronized void registerDriver(BookDriver driver) throws BookException {
        log.debug("begin registering driver: " + driver.getClass().getName());
        this.drivers.add(driver);
        Book[] bookArray = driver.getBooks();
        Set current = CollectionUtil.createSet((Iterable)new BookFilterIterator(this.getBooks(), BookFilters.getBooksByDriver(driver)));
        for (int j = 0; j < bookArray.length; ++j) {
            Book b = bookArray[j];
            if (current.contains(b)) {
                current.remove(b);
                continue;
            }
            this.addBook(bookArray[j]);
        }
        Iterator iter = current.iterator();
        while (iter.hasNext()) {
            Book book = (Book)iter.next();
            this.removeBook(book);
        }
        log.debug("end registering driver: " + driver.getClass().getName());
    }

    public synchronized void unregisterDriver(BookDriver driver) throws BookException {
        log.debug("begin un-registering driver: " + driver.getClass().getName());
        Book[] bookArray = driver.getBooks();
        for (int j = 0; j < bookArray.length; ++j) {
            this.removeBook(bookArray[j]);
        }
        if (!this.drivers.remove(driver)) {
            throw new BookException((MsgBase)Msg.DRIVER_NOREMOVE, new Object[]{driver.getClass().getName()});
        }
        log.debug("end un-registering driver: " + driver.getClass().getName());
    }

    public synchronized BookDriver[] getDriversByClass(Class type) {
        ArrayList<BookDriver> matches = new ArrayList<BookDriver>();
        Iterator iter = this.drivers.iterator();
        while (iter.hasNext()) {
            BookDriver driver = (BookDriver)iter.next();
            if (driver.getClass() != type) continue;
            matches.add(driver);
        }
        return matches.toArray(new BookDriver[matches.size()]);
    }

    public synchronized BookDriver[] getDrivers() {
        return this.drivers.toArray(new BookDriver[this.drivers.size()]);
    }

    public synchronized BookDriver[] getWritableDrivers() {
        int i = 0;
        Iterator iter = this.drivers.iterator();
        while (iter.hasNext()) {
            BookDriver driver = (BookDriver)iter.next();
            if (!driver.isWritable()) continue;
            ++i;
        }
        BookDriver[] reply = new BookDriver[i];
        i = 0;
        iter = this.drivers.iterator();
        while (iter.hasNext()) {
            BookDriver driver = (BookDriver)iter.next();
            if (!driver.isWritable()) continue;
            reply[i++] = driver;
        }
        return reply;
    }

    private void initialize(boolean doThreading) {
        if (doThreading) {
            Runnable runner = new Runnable(){

                public void run() {
                    Books.this.autoRegister();
                }
            };
            Thread init = new Thread(runner, "book-driver-registration");
            init.setPriority(1);
            init.start();
        } else {
            this.autoRegister();
        }
    }

    protected void autoRegister() {
        Class[] types = PluginUtil.getImplementors((Class)BookDriver.class);
        log.debug("begin auto-registering " + types.length + " drivers:");
        for (int i = 0; i < types.length; ++i) {
            try {
                Method driverInstance = types[i].getMethod("instance", new Class[0]);
                BookDriver driver = (BookDriver)driverInstance.invoke(null, new Object[0]);
                this.registerDriver(driver);
                continue;
            }
            catch (NoSuchMethodException e) {
                Reporter.informUser((Object)(class$org$crosswire$jsword$book$Books == null ? Books.class$("org.crosswire.jsword.book.Books") : class$org$crosswire$jsword$book$Books), (Throwable)e);
                continue;
            }
            catch (IllegalArgumentException e) {
                Reporter.informUser((Object)(class$org$crosswire$jsword$book$Books == null ? Books.class$("org.crosswire.jsword.book.Books") : class$org$crosswire$jsword$book$Books), (Throwable)e);
                continue;
            }
            catch (IllegalAccessException e) {
                Reporter.informUser((Object)(class$org$crosswire$jsword$book$Books == null ? Books.class$("org.crosswire.jsword.book.Books") : class$org$crosswire$jsword$book$Books), (Throwable)e);
                continue;
            }
            catch (InvocationTargetException e) {
                Reporter.informUser((Object)(class$org$crosswire$jsword$book$Books == null ? Books.class$("org.crosswire.jsword.book.Books") : class$org$crosswire$jsword$book$Books), (Throwable)e);
                continue;
            }
            catch (BookException e) {
                Reporter.informUser((Object)(class$org$crosswire$jsword$book$Books == null ? Books.class$("org.crosswire.jsword.book.Books") : class$org$crosswire$jsword$book$Books), (LucidException)e);
            }
        }
    }
}

