/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.swing;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class AltFixedSplitPane
extends JSplitPane {
    private static final Dimension DOT = new Dimension(0, 0);
    private boolean firstValidate = true;
    private boolean hasProportionalLocation;
    private double proportionalLocation;
    public static final String PROPERTYNAME_VISIBLE_DIVIDER_BORDER = "visibleDividerBorder";
    private static final Border EMPTY_BORDER = new EmptyBorder(0, 0, 0, 0);
    private boolean visibleDividerBorder;
    private static final long serialVersionUID = 3761687909593789241L;

    public AltFixedSplitPane() {
    }

    public AltFixedSplitPane(boolean visibleDividerBorder) {
        this();
        this.visibleDividerBorder = visibleDividerBorder;
        this.setBorder(EMPTY_BORDER);
    }

    public AltFixedSplitPane(int arg0) {
        super(arg0);
    }

    public AltFixedSplitPane(int arg0, boolean arg1) {
        super(arg0, arg1);
    }

    public AltFixedSplitPane(int arg0, Component arg1, Component arg2) {
        super(arg0, arg1, arg2);
    }

    public AltFixedSplitPane(int arg0, boolean arg1, Component arg2, Component arg3) {
        super(arg0, arg1, arg2, arg3);
    }

    public void setComponentOrientation(ComponentOrientation o) {
        boolean isLtoR = this.getComponentOrientation().isLeftToRight();
        if (this.getOrientation() == 0) {
            return;
        }
        if (o.isLeftToRight() != isLtoR) {
            Component left = this.getLeftComponent();
            Component right = this.getRightComponent();
            this.setRightComponent(null);
            this.setLeftComponent(right);
            this.setRightComponent(left);
            this.setResizeWeight(isLtoR ? 1.0 - this.getResizeWeight() : this.getResizeWeight());
            if (this.hasProportionalLocation) {
                this.setDividerLocation(isLtoR ? 1.0 - this.proportionalLocation : this.proportionalLocation);
            }
        }
        super.setComponentOrientation(o);
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        if (comp instanceof JComponent) {
            ((JComponent)comp).setPreferredSize(DOT);
        }
        Object realConstraints = constraints;
        if (!this.getComponentOrientation().isLeftToRight()) {
            realConstraints = constraints != null && constraints.equals("right") ? "left" : "right";
        }
        super.addImpl(comp, realConstraints, index);
    }

    public void setBottomComponent(Component comp) {
        if (comp instanceof JComponent) {
            ((JComponent)comp).setPreferredSize(DOT);
        }
        super.setBottomComponent(comp);
    }

    public void setLeftComponent(Component comp) {
        if (comp instanceof JComponent) {
            ((JComponent)comp).setPreferredSize(DOT);
        }
        if (this.getComponentOrientation().isLeftToRight()) {
            super.setLeftComponent(comp);
        } else {
            super.setRightComponent(comp);
        }
    }

    public void setRightComponent(Component comp) {
        if (comp instanceof JComponent) {
            ((JComponent)comp).setPreferredSize(DOT);
        }
        if (this.getComponentOrientation().isLeftToRight()) {
            super.setRightComponent(comp);
        } else {
            super.setLeftComponent(comp);
        }
    }

    public void setTopComponent(Component comp) {
        if (comp instanceof JComponent) {
            ((JComponent)comp).setPreferredSize(DOT);
        }
        super.setTopComponent(comp);
    }

    public void validate() {
        if (this.firstValidate) {
            this.firstValidate = false;
            if (this.hasProportionalLocation) {
                this.setDividerLocation(this.proportionalLocation);
            }
        }
        super.validate();
    }

    public void setDividerLocation(double newProportionalLoc) {
        double realProportionalLoc = newProportionalLoc;
        if (this.getComponentOrientation().isLeftToRight()) {
            realProportionalLoc = 1.0 - realProportionalLoc;
        }
        if (!this.firstValidate) {
            this.hasProportionalLocation = true;
            this.proportionalLocation = realProportionalLoc;
        } else {
            super.setDividerLocation(realProportionalLoc);
        }
    }

    public void setResizeWeight(double newResizeWeight) {
        double realResizeWeight = newResizeWeight;
        if (this.getComponentOrientation().isLeftToRight()) {
            realResizeWeight = 1.0 - realResizeWeight;
        }
        super.setResizeWeight(realResizeWeight);
    }

    public boolean isVisibleDividerBorder() {
        return this.visibleDividerBorder;
    }

    public void setVisibleDividerBorder(boolean newVisibility) {
        boolean oldVisibility = this.isVisibleDividerBorder();
        if (oldVisibility == newVisibility) {
            return;
        }
        this.visibleDividerBorder = newVisibility;
        this.firePropertyChange(PROPERTYNAME_VISIBLE_DIVIDER_BORDER, oldVisibility, newVisibility);
    }

    public void updateUI() {
        SplitPaneUI splitPaneUI;
        super.updateUI();
        if (!this.visibleDividerBorder && (splitPaneUI = this.getUI()) instanceof BasicSplitPaneUI) {
            BasicSplitPaneUI basicUI = (BasicSplitPaneUI)splitPaneUI;
            basicUI.getDivider().setBorder(EMPTY_BORDER);
        }
    }
}

