/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.passage;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.crosswire.jsword.passage.AbstractPassage;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.NoSuchVerseException;
import org.crosswire.jsword.passage.Verse;

public class DistinctPassage
extends AbstractPassage {
    static final long serialVersionUID = 817374460730441662L;
    private transient SortedSet store = new TreeSet();

    protected DistinctPassage() {
    }

    protected DistinctPassage(String refs) throws NoSuchVerseException {
        super(refs);
        this.store = Collections.synchronizedSortedSet(new TreeSet());
        this.addVerses(refs);
    }

    public Object clone() {
        DistinctPassage copy = (DistinctPassage)super.clone();
        copy.store = new TreeSet();
        copy.store.addAll(this.store);
        return copy;
    }

    public Iterator iterator() {
        return this.store.iterator();
    }

    public boolean isEmpty() {
        return this.store.isEmpty();
    }

    public int countVerses() {
        return this.store.size();
    }

    public boolean contains(Key obj) {
        Iterator iter = obj.iterator();
        while (iter.hasNext()) {
            if (this.store.contains(iter.next())) continue;
            return false;
        }
        return true;
    }

    public void add(Key obj) {
        this.optimizeWrites();
        Verse firstVerse = null;
        Verse lastVerse = null;
        Iterator iter = obj.iterator();
        while (iter.hasNext()) {
            lastVerse = (Verse)iter.next();
            if (firstVerse == null) {
                firstVerse = lastVerse;
            }
            this.store.add(lastVerse);
        }
        if (this.suppressEvents == 0) {
            this.fireIntervalAdded(this, firstVerse, lastVerse);
        }
    }

    public void remove(Key obj) {
        this.optimizeWrites();
        Verse firstVerse = null;
        Verse lastVerse = null;
        Iterator iter = obj.iterator();
        while (iter.hasNext()) {
            lastVerse = (Verse)iter.next();
            if (firstVerse == null) {
                firstVerse = lastVerse;
            }
            this.store.remove(lastVerse);
        }
        if (this.suppressEvents == 0) {
            this.fireIntervalAdded(this, firstVerse, lastVerse);
        }
    }

    public void clear() {
        this.optimizeWrites();
        this.store.clear();
        this.fireIntervalRemoved(this, null, null);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.writeObjectSupport(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.optimizeWrites();
        this.store = new TreeSet();
        in.defaultReadObject();
        this.readObjectSupport(in);
    }
}

