/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.crosswire.common.diff.Difference;
import org.crosswire.common.diff.EditType;
import org.crosswire.common.util.Logger;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.BookMetaData;
import org.crosswire.jsword.book.Msg;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.KeyFactory;
import org.crosswire.jsword.passage.NoSuchKeyException;
import org.crosswire.jsword.passage.NoSuchVerseException;
import org.crosswire.jsword.passage.PassageKeyFactory;
import org.crosswire.jsword.passage.Verse;
import org.crosswire.jsword.passage.VerseFactory;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Parent;
import org.jdom.Text;

public final class OSISUtil {
    public static final String HI_ACROSTIC = "acrostic";
    public static final String HI_BOLD = "bold";
    public static final String HI_EMPHASIS = "emphasis";
    public static final String HI_ILLUMINATED = "illuminated";
    public static final String HI_ITALIC = "italic";
    public static final String HI_LINETHROUGH = "line-through";
    public static final String HI_NORMAL = "normal";
    public static final String HI_SMALL_CAPS = "small-caps";
    public static final String HI_SUB = "sub";
    public static final String HI_SUPER = "super";
    public static final String HI_UNDERLINE = "underline";
    public static final String HI_X_CAPS = "x-caps";
    public static final String HI_X_BIG = "x-big";
    public static final String HI_X_SMALL = "x-small";
    public static final String HI_X_TT = "x-tt";
    public static final String SEG_JUSTIFYRIGHT = "text-align: right;";
    public static final String SEG_CENTER = "text-align: center;";
    public static final String DIV_PRE = "x-pre";
    public static final String SEG_COLORPREFIX = "color: ";
    public static final String SEG_SIZEPREFIX = "font-size: ";
    public static final String TYPE_X_PREFIX = "x-";
    public static final String NOTETYPE_STUDY = "x-StudyNote";
    public static final String NOTETYPE_REFERENCE = "crossReference";
    public static final String VARIANT_TYPE = "x-variant";
    public static final String VARIANT_CLASS = "x-class";
    public static final String GENERATED_CONTENT = "x-gen";
    public static final String POS_TYPE = "x-pos";
    public static final String DEF_TYPE = "x-def";
    public static final String LEMMA_STRONGS = "strong:";
    public static final String MORPH_ROBINSONS = "robinson:";
    public static final String MORPH_STRONGS = "x-StrongsMorph:T";
    public static final String Q_BLOCK = "blockquote";
    public static final String Q_CITATION = "citation";
    public static final String Q_EMBEDDED = "embedded";
    public static final String LIST_ORDERED = "x-ordered";
    public static final String LIST_UNORDERED = "x-unordered";
    public static final String TABLE_ROLE_LABEL = "label";
    public static final String CELL_ALIGN_LEFT = "left";
    public static final String CELL_ALIGN_RIGHT = "right";
    public static final String CELL_ALIGN_CENTER = "center";
    public static final String CELL_ALIGN_JUSTIFY = "justify";
    public static final String CELL_ALIGN_START = "start";
    public static final String CELL_ALIGN_END = "end";
    public static final String OSIS_ELEMENT_TITLE = "title";
    public static final String OSIS_ELEMENT_TABLE = "table";
    public static final String OSIS_ELEMENT_SPEECH = "speech";
    public static final String OSIS_ELEMENT_SPEAKER = "speaker";
    public static final String OSIS_ELEMENT_ROW = "row";
    public static final String OSIS_ELEMENT_REFERENCE = "reference";
    public static final String OSIS_ELEMENT_NOTE = "note";
    public static final String OSIS_ELEMENT_NAME = "name";
    public static final String OSIS_ELEMENT_Q = "q";
    public static final String OSIS_ELEMENT_LIST = "list";
    public static final String OSIS_ELEMENT_P = "p";
    public static final String OSIS_ELEMENT_ITEM = "item";
    public static final String OSIS_ELEMENT_FIGURE = "figure";
    public static final String OSIS_ELEMENT_FOREIGN = "foreign";
    public static final String OSIS_ELEMENT_W = "w";
    public static final String OSIS_ELEMENT_CHAPTER = "chapter";
    public static final String OSIS_ELEMENT_VERSE = "verse";
    public static final String OSIS_ELEMENT_CELL = "cell";
    public static final String OSIS_ELEMENT_DIV = "div";
    public static final String OSIS_ELEMENT_OSIS = "osis";
    public static final String OSIS_ELEMENT_WORK = "work";
    public static final String OSIS_ELEMENT_HEADER = "header";
    public static final String OSIS_ELEMENT_OSISTEXT = "osisText";
    public static final String OSIS_ELEMENT_SEG = "seg";
    public static final String OSIS_ELEMENT_LG = "lg";
    public static final String OSIS_ELEMENT_L = "l";
    public static final String OSIS_ELEMENT_LB = "lb";
    public static final String OSIS_ELEMENT_HI = "hi";
    public static final String ATTRIBUTE_TEXT_OSISIDWORK = "osisIDWork";
    public static final String ATTRIBUTE_WORK_OSISWORK = "osisWork";
    public static final String OSIS_ATTR_OSISID = "osisID";
    public static final String OSIS_ATTR_SID = "sID";
    public static final String OSIS_ATTR_EID = "eID";
    public static final String ATTRIBUTE_W_LEMMA = "lemma";
    public static final String ATTRIBUTE_FIGURE_SRC = "src";
    public static final String ATTRIBUTE_TABLE_ROLE = "role";
    public static final String ATTRIBUTE_CELL_ALIGN = "align";
    public static final String OSIS_ATTR_TYPE = "type";
    public static final String OSIS_ATTR_CANONICAL = "canonical";
    public static final String OSIS_ATTR_SUBTYPE = "subType";
    public static final String OSIS_ATTR_REF = "osisRef";
    public static final String OSIS_ATTR_LEVEL = "level";
    public static final String ATTRIBUTE_SPEAKER_WHO = "who";
    public static final String ATTRIBUTE_W_MORPH = "morph";
    public static final String ATTRIBUTE_OSISTEXT_OSISIDWORK = "osisIDWork";
    public static final String OSIS_ATTR_LANG = "lang";
    public static final String ATTRIBUTE_DIV_BOOK = "book";
    private static final String OSISID_PREFIX_BIBLE = "Bible.";
    private static final Set EXTRA_BIBLICAL_ELEMENTS;
    private static final Logger log;
    private static OSISFactory factory;
    private static String strongsNumber;
    private static Pattern strongsNumberPattern;
    static final /* synthetic */ boolean $assertionsDisabled;

    private OSISUtil() {
    }

    public static OSISFactory factory() {
        return factory;
    }

    public static List getFragment(Element root) {
        Content firstChild;
        Element content = root;
        if (OSIS_ELEMENT_OSIS.equals(root.getName())) {
            content = root.getChild(OSIS_ELEMENT_OSISTEXT);
        }
        if (OSIS_ELEMENT_OSISTEXT.equals(root.getName())) {
            content = root.getChild(OSIS_ELEMENT_DIV);
        }
        if (content != null && content.getContentSize() == 1 && (firstChild = content.getContent(0)) instanceof Element && OSIS_ELEMENT_DIV.equals(((Element)firstChild).getName())) {
            content = (Element)firstChild;
        }
        if (!$assertionsDisabled && content == null) {
            throw new AssertionError();
        }
        return content.getContent();
    }

    public static String getCanonicalText(Element root) {
        StringBuffer buffer = new StringBuffer();
        List frag = OSISUtil.getFragment(root);
        Iterator dit = frag.iterator();
        String sID = null;
        Object data = null;
        Element ele = null;
        while (dit.hasNext()) {
            data = dit.next();
            if (data instanceof Element) {
                ele = data;
                if (!OSISUtil.isCanonical((Content)ele)) continue;
                if (ele.getName().equals(OSIS_ELEMENT_VERSE)) {
                    sID = ele.getAttributeValue(OSIS_ATTR_SID);
                }
                if (sID != null) {
                    OSISUtil.getCanonicalContent(ele, sID, dit, buffer);
                    continue;
                }
                OSISUtil.getCanonicalContent(ele, null, ele.getContent().iterator(), buffer);
                continue;
            }
            if (!(data instanceof Text)) continue;
            buffer.append(((Text)data).getText());
        }
        return buffer.toString().trim();
    }

    public static String getPlainText(Element root) {
        return OSISUtil.getTextContent(OSISUtil.getFragment(root));
    }

    public static String getStrongsNumbers(Element root) {
        StringBuffer buffer = new StringBuffer();
        Iterator contentIter = OSISUtil.getDeepContent(root, OSIS_ELEMENT_W).iterator();
        while (contentIter.hasNext()) {
            Element ele = (Element)contentIter.next();
            String attr = ele.getAttributeValue(ATTRIBUTE_W_LEMMA);
            if (attr == null) continue;
            if (buffer.length() > 0) {
                buffer.append(' ');
            }
            buffer.append(attr);
        }
        String lemmas = buffer.toString();
        int len = buffer.length();
        if (len > 0) {
            buffer.delete(0, len);
        }
        Matcher matcher = strongsNumberPattern.matcher(lemmas);
        while (matcher.find()) {
            String strongType = matcher.group(1);
            String strongsNum = matcher.group(2);
            if (buffer.length() > 0) {
                buffer.append(' ');
            }
            buffer.append(strongType);
            buffer.append(strongsNum);
        }
        return buffer.toString().trim();
    }

    public static String getReferences(Element root) {
        KeyFactory keyf = PassageKeyFactory.instance();
        Key collector = keyf.createEmptyKeyList();
        Iterator contentIter = OSISUtil.getDeepContent(root, OSIS_ELEMENT_REFERENCE).iterator();
        while (contentIter.hasNext()) {
            Element ele = (Element)contentIter.next();
            String attr = ele.getAttributeValue(OSIS_ATTR_REF);
            if (attr == null) continue;
            try {
                Key key = keyf.getKey(attr);
                collector.addAll(key);
            }
            catch (NoSuchKeyException e) {
                log.warn("Unable to parse: " + attr, (Throwable)((Object)e));
            }
        }
        return collector.getOsisID();
    }

    public static String getNotes(Element root) {
        StringBuffer buffer = new StringBuffer();
        Iterator contentIter = OSISUtil.getDeepContent(root, OSIS_ELEMENT_NOTE).iterator();
        while (contentIter.hasNext()) {
            Element ele = (Element)contentIter.next();
            String attr = ele.getAttributeValue(OSIS_ATTR_TYPE);
            if (attr != null && attr.equals(NOTETYPE_REFERENCE)) continue;
            if (buffer.length() > 0) {
                buffer.append(' ');
            }
            buffer.append(OSISUtil.getTextContent(ele.getContent()));
        }
        return buffer.toString();
    }

    public static String getHeadings(Element root) {
        StringBuffer buffer = new StringBuffer();
        Iterator contentIter = OSISUtil.getDeepContent(root, OSIS_ELEMENT_TITLE).iterator();
        while (contentIter.hasNext()) {
            Element ele = (Element)contentIter.next();
            OSISUtil.getCanonicalContent(ele, null, ele.getContent().iterator(), buffer);
        }
        return buffer.toString();
    }

    private static void getCanonicalContent(Element parent, String sID, Iterator iter, StringBuffer buffer) {
        if (!OSISUtil.isCanonical((Content)parent)) {
            return;
        }
        Object data = null;
        Element ele = null;
        String eleName = null;
        String eID = null;
        while (iter.hasNext()) {
            data = iter.next();
            if (data instanceof Element) {
                ele = data;
                eleName = ele.getName();
                eID = ele.getAttributeValue(OSIS_ATTR_SID);
                if (eID != null && eID.equals(sID) && eleName.equals(parent.getName())) break;
                OSISUtil.getCanonicalContent(ele, sID, ele.getContent().iterator(), buffer);
                continue;
            }
            if (!(data instanceof Text)) continue;
            buffer.append(((Text)data).getText());
        }
    }

    private static boolean isCanonical(Content content) {
        Element element;
        boolean result = true;
        if (content instanceof Element && EXTRA_BIBLICAL_ELEMENTS.contains((element = (Element)content).getName())) {
            String canonical = element.getAttributeValue(OSIS_ATTR_CANONICAL);
            result = Boolean.valueOf(canonical);
        }
        return result;
    }

    private static String getTextContent(List fragment) {
        StringBuffer buffer = new StringBuffer();
        Iterator contentIter = fragment.iterator();
        while (contentIter.hasNext()) {
            Content next = (Content)contentIter.next();
            OSISUtil.recurseElement(next, buffer);
        }
        return buffer.toString();
    }

    public static Collection getDeepContent(Element div, String name) {
        ArrayList reply = new ArrayList();
        OSISUtil.recurseDeepContent(div, name, reply);
        return reply;
    }

    public static Verse getVerse(Element ele) throws BookException {
        if (ele.getName().equals(OSIS_ELEMENT_VERSE)) {
            String osisid = ele.getAttributeValue(OSIS_ATTR_OSISID);
            try {
                return VerseFactory.fromString(osisid);
            }
            catch (NoSuchVerseException ex) {
                throw new BookException(Msg.OSIS_BADID, (Throwable)((Object)ex), new Object[]{osisid});
            }
        }
        Parent parent = ele.getParent();
        if (parent instanceof Element) {
            return OSISUtil.getVerse((Element)parent);
        }
        throw new BookException(Msg.MISSING_VERSE);
    }

    public static Element createOsisFramework(BookMetaData bmd) {
        Element osis = OSISUtil.factory().createOsis();
        String osisid = bmd.getInitials();
        Element work = OSISUtil.factory().createWork();
        work.setAttribute(ATTRIBUTE_WORK_OSISWORK, osisid);
        Element header = OSISUtil.factory().createHeader();
        header.addContent((Content)work);
        Element text = OSISUtil.factory().createOsisText();
        text.setAttribute("osisIDWork", OSISID_PREFIX_BIBLE + osisid);
        text.addContent((Content)header);
        osis.addContent((Content)text);
        return osis;
    }

    public static List diffToOsis(List diffs) {
        Element div = OSISUtil.factory().createDiv();
        for (int x = 0; x < diffs.size(); ++x) {
            Element hi;
            Difference diff = (Difference)diffs.get(x);
            EditType editType = diff.getEditType();
            Text text = factory.createText(diff.getText());
            if (EditType.DELETE.equals(editType)) {
                hi = OSISUtil.factory().createHI();
                hi.setAttribute(OSIS_ATTR_TYPE, HI_LINETHROUGH);
                hi.addContent((Content)text);
                div.addContent((Content)hi);
                continue;
            }
            if (EditType.INSERT.equals(editType)) {
                hi = OSISUtil.factory().createHI();
                hi.setAttribute(OSIS_ATTR_TYPE, HI_UNDERLINE);
                hi.addContent((Content)text);
                div.addContent((Content)hi);
                continue;
            }
            div.addContent((Content)text);
        }
        return div.cloneContent();
    }

    public static List rtfToOsis(String rtf) {
        Element div = OSISUtil.factory().createDiv();
        Stack<Element> stack = new Stack<Element>();
        stack.push(div);
        int strlen = rtf.length();
        StringBuffer text = new StringBuffer(strlen);
        int i = 0;
        for (i = 0; i < strlen; ++i) {
            Element hiElement;
            Element currentElement;
            Element currentElement2;
            char curChar = rtf.charAt(i);
            if (curChar != '\\') {
                text.append(curChar);
                continue;
            }
            if (rtf.startsWith("\\pard", i)) {
                currentElement2 = (Element)stack.pop();
                currentElement2.addContent(text.toString());
                text.delete(0, text.length());
                stack.clear();
                stack.push(div);
                i += i + 5 < strlen && rtf.charAt(i + 5) == ' ' ? 5 : 4;
                continue;
            }
            if (rtf.startsWith("\\par", i)) {
                currentElement2 = (Element)stack.peek();
                currentElement2.addContent(text.toString());
                text.delete(0, text.length());
                currentElement2.addContent((Content)factory.createLB());
                i += i + 4 < strlen && rtf.charAt(i + 4) == ' ' ? 4 : 3;
                continue;
            }
            if (rtf.startsWith("\\qc", i)) {
                Element centerDiv = factory.createDiv();
                centerDiv.setAttribute(OSIS_ATTR_TYPE, "x-center");
                currentElement = (Element)stack.peek();
                currentElement.addContent(text.toString());
                text.delete(0, text.length());
                currentElement.addContent((Content)centerDiv);
                stack.push(centerDiv);
                i += i + 3 < strlen && rtf.charAt(i + 3) == ' ' ? 3 : 2;
                continue;
            }
            if (rtf.startsWith("\\u", i)) {
                char curDigit;
                StringBuffer buf = new StringBuffer();
                i += 2;
                while (i < strlen && ((curDigit = rtf.charAt(i)) == '-' || Character.isDigit(curDigit))) {
                    buf.append(curDigit);
                    ++i;
                }
                int value = Integer.parseInt(buf.toString());
                if (value < 0) {
                    value += 65536;
                }
                text.append((char)value);
                continue;
            }
            if (rtf.startsWith("\\i0", i) || rtf.startsWith("\\b0", i)) {
                currentElement2 = (Element)stack.pop();
                currentElement2.addContent(text.toString());
                text.delete(0, text.length());
                i += i + 3 < strlen && rtf.charAt(i + 3) == ' ' ? 3 : 2;
                continue;
            }
            if (rtf.startsWith(" ", i) || rtf.startsWith("\n", i)) {
                ++i;
                continue;
            }
            if (rtf.startsWith("\\i", i)) {
                hiElement = factory.createHI();
                hiElement.setAttribute(OSIS_ATTR_TYPE, HI_ITALIC);
                currentElement = (Element)stack.peek();
                currentElement.addContent(text.toString());
                text.delete(0, text.length());
                currentElement.addContent((Content)hiElement);
                stack.push(hiElement);
                i += i + 2 < strlen && rtf.charAt(i + 2) == ' ' ? 2 : 1;
                continue;
            }
            if (!rtf.startsWith("\\b", i)) continue;
            hiElement = factory.createHI();
            hiElement.setAttribute(OSIS_ATTR_TYPE, HI_BOLD);
            currentElement = (Element)stack.peek();
            currentElement.addContent(text.toString());
            text.delete(0, text.length());
            currentElement.addContent((Content)hiElement);
            stack.push(hiElement);
            i += i + 2 < strlen && rtf.charAt(i + 2) == ' ' ? 2 : 1;
        }
        return div.cloneContent();
    }

    private static void recurseDeepContent(Element start, String name, List reply) {
        if (start.getName().equals(name)) {
            reply.add(start);
        }
        Object data = null;
        Element ele = null;
        Iterator contentIter = start.getContent().iterator();
        while (contentIter.hasNext()) {
            data = contentIter.next();
            if (!(data instanceof Element)) continue;
            ele = data;
            OSISUtil.recurseDeepContent(ele, name, reply);
        }
    }

    private static void recurseElement(Object sub, StringBuffer buffer) {
        if (sub instanceof Text) {
            buffer.append(((Text)sub).getText());
        } else if (sub instanceof Element) {
            OSISUtil.recurseChildren((Element)sub, buffer);
        } else {
            log.error("unknown type: " + sub.getClass().getName());
        }
    }

    private static void recurseChildren(Element ele, StringBuffer buffer) {
        Iterator contentIter = ele.getContent().iterator();
        while (contentIter.hasNext()) {
            Object sub = contentIter.next();
            OSISUtil.recurseElement(sub, buffer);
        }
    }

    static {
        $assertionsDisabled = !OSISUtil.class.desiredAssertionStatus();
        EXTRA_BIBLICAL_ELEMENTS = new HashSet<String>(Arrays.asList(OSIS_ELEMENT_NOTE, OSIS_ELEMENT_TITLE, OSIS_ELEMENT_REFERENCE));
        log = Logger.getLogger((Class)OSISUtil.class);
        factory = new OSISFactory();
        strongsNumber = "strong:([GH])0*([0-9]+)";
        strongsNumberPattern = Pattern.compile(strongsNumber);
    }

    public static class OSISFactory {
        public Element createSeg() {
            return new Element(OSISUtil.OSIS_ELEMENT_SEG);
        }

        public Element createOsisText() {
            return new Element(OSISUtil.OSIS_ELEMENT_OSISTEXT);
        }

        public Element createHeader() {
            return new Element(OSISUtil.OSIS_ELEMENT_HEADER);
        }

        public Element createWork() {
            return new Element(OSISUtil.OSIS_ELEMENT_WORK);
        }

        public Element createOsis() {
            return new Element(OSISUtil.OSIS_ELEMENT_OSIS);
        }

        public Element createDiv() {
            return new Element(OSISUtil.OSIS_ELEMENT_DIV);
        }

        public Element createCell() {
            return new Element(OSISUtil.OSIS_ELEMENT_CELL);
        }

        public Element createHeaderCell() {
            Element ele = new Element(OSISUtil.OSIS_ELEMENT_CELL);
            ele.setAttribute(OSISUtil.ATTRIBUTE_TABLE_ROLE, OSISUtil.TABLE_ROLE_LABEL);
            ele.setAttribute(OSISUtil.ATTRIBUTE_CELL_ALIGN, OSISUtil.CELL_ALIGN_CENTER);
            return ele;
        }

        public Element createVerse() {
            return new Element(OSISUtil.OSIS_ELEMENT_VERSE);
        }

        public Element createW() {
            return new Element(OSISUtil.OSIS_ELEMENT_W);
        }

        public Element createFigure() {
            return new Element(OSISUtil.OSIS_ELEMENT_FIGURE);
        }

        public Element createForeign() {
            return new Element(OSISUtil.OSIS_ELEMENT_FOREIGN);
        }

        public Element createItem() {
            return new Element(OSISUtil.OSIS_ELEMENT_ITEM);
        }

        public Element createP() {
            return new Element(OSISUtil.OSIS_ELEMENT_P);
        }

        public Element createList() {
            return new Element(OSISUtil.OSIS_ELEMENT_LIST);
        }

        public Element createQ() {
            return new Element(OSISUtil.OSIS_ELEMENT_Q);
        }

        public Element createName() {
            return new Element(OSISUtil.OSIS_ELEMENT_NAME);
        }

        public Element createNote() {
            return new Element(OSISUtil.OSIS_ELEMENT_NOTE);
        }

        public Element createReference() {
            return new Element(OSISUtil.OSIS_ELEMENT_REFERENCE);
        }

        public Element createRow() {
            return new Element(OSISUtil.OSIS_ELEMENT_ROW);
        }

        public Element createSpeaker() {
            return new Element(OSISUtil.OSIS_ELEMENT_SPEAKER);
        }

        public Element createSpeech() {
            return new Element(OSISUtil.OSIS_ELEMENT_SPEECH);
        }

        public Element createTable() {
            return new Element(OSISUtil.OSIS_ELEMENT_TABLE);
        }

        public Element createTitle() {
            return new Element(OSISUtil.OSIS_ELEMENT_TITLE);
        }

        public Element createLG() {
            return new Element(OSISUtil.OSIS_ELEMENT_LG);
        }

        public Element createL() {
            return new Element(OSISUtil.OSIS_ELEMENT_L);
        }

        public Element createLB() {
            return new Element(OSISUtil.OSIS_ELEMENT_LB);
        }

        public Element createHI() {
            return new Element(OSISUtil.OSIS_ELEMENT_HI);
        }

        public Text createText(String text) {
            return new Text(text);
        }
    }
}

