/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.crosswire.common.util.CWClassLoader;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.NetUtil;
import org.crosswire.common.util.OSType;

public final class CWProject {
    private static final String DIR_NETCACHE = "netcache";
    private URI[] homes;
    private URI writeHome;
    private URI readHome;
    private static String homeProperty = "jsword.home";
    private static String homeDirectory = ".jsword";
    private static String homeAltDirectory = "JSword";
    private static CWProject instance = new CWProject();
    private static final Logger log = Logger.getLogger(CWProject.class);

    public static CWProject instance() {
        return instance;
    }

    public void setHome(String homeProperty, String homeDir, String altHomeDir) {
        CWProject.homeProperty = homeProperty;
        homeDirectory = homeDir;
        homeAltDirectory = altHomeDir;
        this.establishProjectHome();
    }

    public URI getWritableProjectDir() {
        this.establishProjectHome();
        return this.writeHome;
    }

    public URI[] getProjectResourceDirs() {
        this.establishProjectHome();
        return this.homes;
    }

    public URI getDeprecatedWritableProjectDir() {
        return OSType.DEFAULT.getUserAreaFolder(homeDirectory, homeAltDirectory);
    }

    public URI getWritablePropertiesURI(String subject) {
        return NetUtil.lengthenURI(this.getWritableProjectDir(), subject + ".properties");
    }

    public URI getWriteableProjectSubdir(String subject, boolean create) throws IOException {
        URI temp = NetUtil.lengthenURI(this.getWritableProjectDir(), subject);
        if (create && !NetUtil.isDirectory(temp)) {
            NetUtil.makeDirectory(temp);
        }
        return temp;
    }

    private CWProject() {
    }

    private void establishProjectHome() {
        String cwHome;
        if (this.writeHome == null && this.readHome == null && (cwHome = System.getProperty(homeProperty)) != null) {
            URI home = NetUtil.getURI(new File(cwHome));
            if (NetUtil.canWrite(home)) {
                this.writeHome = home;
            } else if (NetUtil.canRead(home)) {
                this.readHome = home;
            }
        }
        if (this.writeHome == null) {
            URI path = OSType.getOSType().getUserAreaFolder(homeDirectory, homeAltDirectory);
            URI oldPath = this.getDeprecatedWritableProjectDir();
            this.writeHome = this.migrateUserProjectDir(oldPath, path);
        }
        if (this.homes == null) {
            this.homes = this.readHome == null ? new URI[]{this.writeHome} : new URI[]{this.writeHome, this.readHome};
            CWClassLoader.setHome(this.getProjectResourceDirs());
            try {
                URI uricache = this.getWriteableProjectSubdir(DIR_NETCACHE, true);
                File filecache = new File(uricache.getPath());
                NetUtil.setURICacheDir(filecache);
            }
            catch (IOException ex) {
                log.warn("Failed to get directory for NetUtil.setURICacheDir()", ex);
            }
        }
    }

    private URI migrateUserProjectDir(URI oldPath, URI newPath) {
        if (oldPath.toString().equals(newPath.toString())) {
            return newPath;
        }
        if (NetUtil.isDirectory(oldPath)) {
            File oldDir = new File(oldPath.getPath());
            File newDir = new File(newPath.getPath());
            oldDir.renameTo(newDir);
            if (NetUtil.isDirectory(newPath)) {
                return newPath;
            }
            return oldPath;
        }
        return newPath;
    }
}

