/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.diff;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.crosswire.common.diff.Difference;

public class LineMap {
    private String sourceMap;
    private String targetMap;
    private List lines = new ArrayList();

    public LineMap(String source, String target) {
        this.lines.add("");
        HashMap linehash = new HashMap();
        this.sourceMap = this.linesToCharsMunge(source, this.lines, linehash);
        this.targetMap = this.linesToCharsMunge(target, this.lines, linehash);
    }

    public void restore(List diffs) {
        StringBuffer text = new StringBuffer();
        for (int x = 0; x < diffs.size(); ++x) {
            Difference diff = (Difference)diffs.get(x);
            String chars = diff.getText();
            text.delete(0, text.length());
            for (int y = 0; y < chars.length(); ++y) {
                text.append(this.lines.get(chars.charAt(y)));
            }
            diff.setText(text.toString());
        }
    }

    public String getSourceMap() {
        return this.sourceMap;
    }

    public String getTargetMap() {
        return this.targetMap;
    }

    public List getLines() {
        return this.lines;
    }

    private String linesToCharsMunge(String text, List linearray, Map linehash) {
        StringBuffer buf = new StringBuffer();
        String work = text;
        while (work.length() != 0) {
            int i = work.indexOf(10);
            if (i == -1) {
                i = work.length() - 1;
            }
            String line = work.substring(0, i + 1);
            work = work.substring(i + 1);
            if (linehash.containsKey(line)) {
                Integer charInt = (Integer)linehash.get(line);
                buf.append(String.valueOf((char)charInt.intValue()));
                continue;
            }
            linearray.add(line);
            linehash.put(line, new Integer(linearray.size() - 1));
            buf.append(String.valueOf((char)(linearray.size() - 1)));
        }
        return buf.toString();
    }
}

