/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.progress.swing;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.crosswire.common.icu.NumberShaper;
import org.crosswire.common.progress.Job;
import org.crosswire.common.progress.JobManager;
import org.crosswire.common.progress.Progress;
import org.crosswire.common.progress.WorkEvent;
import org.crosswire.common.progress.WorkListener;
import org.crosswire.common.progress.swing.JobCancelListener;
import org.crosswire.common.swing.ActionFactory;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.common.util.Logger;

public class JobsProgressBar
extends JPanel
implements WorkListener {
    protected Map jobs;
    private List positions;
    private Font font;
    private NumberShaper shaper = new NumberShaper();
    private ActionFactory actions;
    private static final String STOP = "Stop";
    private static final Logger log = Logger.getLogger((Class)JobsProgressBar.class);
    private static final long serialVersionUID = 3257563988660663606L;

    public JobsProgressBar(boolean small) {
        this.jobs = new HashMap();
        this.positions = new ArrayList();
        this.shaper = new NumberShaper();
        this.actions = new ActionFactory(JobsProgressBar.class, this);
        if (small) {
            this.font = new Font("SansSerif", 0, 10);
        }
        JobManager.addWorkListener((WorkListener)this);
        Set current = JobManager.getJobs();
        Iterator it = current.iterator();
        while (it.hasNext()) {
            Job job = (Job)it.next();
            this.addJob((Progress)job);
        }
        this.setLayout(new GridLayout(1, 0, 2, 0));
        GuiUtil.applyDefaultOrientation(this);
    }

    public synchronized JButton createCancelButton(Progress job) {
        JButton cancelButton = this.actions.createActionIcon(STOP, new JobCancelListener(job));
        return cancelButton;
    }

    public synchronized void workProgressed(final WorkEvent ev) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Progress job = ev.getJob();
                if (!JobsProgressBar.this.jobs.containsKey(job)) {
                    JobsProgressBar.this.addJob(job);
                }
                JobsProgressBar.this.updateJob(job);
                if (job.isFinished()) {
                    JobsProgressBar.this.removeJob(job);
                }
            }
        });
    }

    public void workStateChanged(WorkEvent ev) {
        Job job = (Job)ev.getSource();
        JobData jobdata = (JobData)this.jobs.get(job);
        jobdata.workStateChanged(ev);
    }

    final synchronized void addJob(Progress job) {
        ((Job)job).addWorkListener((WorkListener)this);
        int i = this.findEmptyPosition();
        log.debug("adding job to panel at " + i + ": " + job.getJobName());
        JProgressBar progress = new JProgressBar();
        progress.setStringPainted(true);
        progress.setToolTipText(job.getJobName());
        progress.setBorder(null);
        progress.setBackground(this.getBackground());
        progress.setForeground(this.getForeground());
        if (this.font != null) {
            progress.setFont(this.font);
        }
        GuiUtil.applyDefaultOrientation(progress);
        JobData jobdata = new JobData(this, job, i, progress);
        this.jobs.put(job, jobdata);
        if (i >= this.positions.size()) {
            this.positions.add(jobdata);
        } else {
            this.positions.set(i, jobdata);
        }
        this.add(jobdata.getComponent(), i);
        GuiUtil.refresh(this);
        GuiUtil.applyDefaultOrientation(this);
    }

    protected synchronized void updateJob(Progress job) {
        JobData jobdata = (JobData)this.jobs.get(job);
        int percent = job.getWork();
        StringBuffer buf = new StringBuffer(job.getSectionName());
        buf.append(": ");
        buf.append(this.shaper.shape(Integer.toString(percent)));
        buf.append('%');
        jobdata.getProgress().setString(buf.toString());
        jobdata.getProgress().setValue(percent);
    }

    protected synchronized void removeJob(Progress job) {
        ((Job)job).removeWorkListener((WorkListener)this);
        JobData jobdata = (JobData)this.jobs.get(job);
        this.positions.set(jobdata.getIndex(), null);
        this.jobs.remove(job);
        log.debug("removing job from panel: " + jobdata.getJob().getJobName());
        this.remove(jobdata.getComponent());
        GuiUtil.refresh(this);
        jobdata.invalidate();
    }

    private int findEmptyPosition() {
        int i;
        for (i = 0; i < this.positions.size() && this.positions.get(i) != null; ++i) {
        }
        return i;
    }

    private static class JobData
    implements WorkListener {
        private JobsProgressBar bar;
        private Progress job;
        private int index;
        private JProgressBar progress;
        private Component comp;
        private JButton cancelButton;

        JobData(JobsProgressBar bar, Progress job, int index, JProgressBar progress) {
            this.bar = bar;
            this.job = job;
            this.index = index;
            this.progress = progress;
            this.comp = this.decorateProgressBar();
        }

        void invalidate() {
            this.job = null;
            this.progress = null;
            this.index = -1;
        }

        Progress getJob() {
            return this.job;
        }

        JProgressBar getProgress() {
            return this.progress;
        }

        public Component getComponent() {
            return this.comp;
        }

        public JButton getCancelButton() {
            if (this.cancelButton == null) {
                this.cancelButton = this.bar.createCancelButton(this.job);
            }
            return this.cancelButton;
        }

        int getIndex() {
            return this.index;
        }

        public void workStateChanged(WorkEvent evt) {
            if (this.cancelButton != null) {
                this.cancelButton.setEnabled(this.job.isCancelable());
            }
        }

        public void workProgressed(WorkEvent ev) {
        }

        private Component decorateProgressBar() {
            if (!this.job.isCancelable()) {
                return this.progress;
            }
            JPanel panel = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridwidth = 1;
            gbc.fill = 0;
            panel.add((Component)this.bar.createCancelButton(this.job), gbc);
            gbc.weightx = 1.0;
            gbc.gridwidth = 0;
            gbc.fill = 2;
            panel.add((Component)this.progress, gbc);
            GuiUtil.applyDefaultOrientation(panel);
            return panel;
        }
    }
}

