/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.text.Collator;
import java.util.Locale;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.ExtendedFieldCache;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.FieldCacheImpl;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreDocComparator;
import org.apache.lucene.search.SortComparatorSource;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.PriorityQueue;

public class FieldSortedHitQueue
extends PriorityQueue {
    protected ScoreDocComparator[] comparators;
    protected SortField[] fields;
    protected float maxscore = Float.NEGATIVE_INFINITY;
    static final FieldCacheImpl.Cache Comparators = new FieldCacheImpl.Cache(){

        protected Object createValue(IndexReader reader, Object entryKey) throws IOException {
            ScoreDocComparator comparator;
            FieldCacheImpl.Entry entry = (FieldCacheImpl.Entry)entryKey;
            String fieldname = entry.field;
            int type = entry.type;
            Locale locale = entry.locale;
            SortComparatorSource factory = (SortComparatorSource)entry.custom;
            switch (type) {
                case 2: {
                    comparator = FieldSortedHitQueue.comparatorAuto(reader, fieldname);
                    break;
                }
                case 4: {
                    comparator = FieldSortedHitQueue.comparatorInt(reader, fieldname);
                    break;
                }
                case 5: {
                    comparator = FieldSortedHitQueue.comparatorFloat(reader, fieldname);
                    break;
                }
                case 6: {
                    comparator = FieldSortedHitQueue.comparatorLong(reader, fieldname);
                    break;
                }
                case 7: {
                    comparator = FieldSortedHitQueue.comparatorDouble(reader, fieldname);
                    break;
                }
                case 3: {
                    if (locale != null) {
                        comparator = FieldSortedHitQueue.comparatorStringLocale(reader, fieldname, locale);
                        break;
                    }
                    comparator = FieldSortedHitQueue.comparatorString(reader, fieldname);
                    break;
                }
                case 9: {
                    comparator = factory.newComparator(reader, fieldname);
                    break;
                }
                default: {
                    throw new RuntimeException("unknown field type: " + type);
                }
            }
            return comparator;
        }
    };

    public FieldSortedHitQueue(IndexReader reader, SortField[] fields, int size) throws IOException {
        int n = fields.length;
        this.comparators = new ScoreDocComparator[n];
        this.fields = new SortField[n];
        for (int i = 0; i < n; ++i) {
            String fieldname = fields[i].getField();
            this.comparators[i] = FieldSortedHitQueue.getCachedComparator(reader, fieldname, fields[i].getType(), fields[i].getLocale(), fields[i].getFactory());
            this.fields[i] = this.comparators[i].sortType() == 3 ? new SortField(fieldname, fields[i].getLocale(), fields[i].getReverse()) : new SortField(fieldname, this.comparators[i].sortType(), fields[i].getReverse());
        }
        this.initialize(size);
    }

    public float getMaxScore() {
        return this.maxscore;
    }

    private final void updateMaxScore(FieldDoc fdoc) {
        this.maxscore = Math.max(this.maxscore, fdoc.score);
    }

    public boolean insert(FieldDoc fdoc) {
        this.updateMaxScore(fdoc);
        return super.insert(fdoc);
    }

    public boolean insert(Object fdoc) {
        return this.insert((FieldDoc)fdoc);
    }

    public Object insertWithOverflow(Object element) {
        this.updateMaxScore((FieldDoc)element);
        return super.insertWithOverflow(element);
    }

    protected boolean lessThan(Object a, Object b) {
        ScoreDoc docA = (ScoreDoc)a;
        ScoreDoc docB = (ScoreDoc)b;
        int n = this.comparators.length;
        int c = 0;
        for (int i = 0; i < n && c == 0; ++i) {
            c = this.fields[i].reverse ? this.comparators[i].compare(docB, docA) : this.comparators[i].compare(docA, docB);
        }
        if (c == 0) {
            return docA.doc > docB.doc;
        }
        return c > 0;
    }

    FieldDoc fillFields(FieldDoc doc) {
        int n = this.comparators.length;
        Comparable[] fields = new Comparable[n];
        for (int i = 0; i < n; ++i) {
            fields[i] = this.comparators[i].sortValue(doc);
        }
        doc.fields = fields;
        return doc;
    }

    SortField[] getFields() {
        return this.fields;
    }

    static ScoreDocComparator getCachedComparator(IndexReader reader, String field, int type, Locale locale, SortComparatorSource factory) throws IOException {
        if (type == 1) {
            return ScoreDocComparator.INDEXORDER;
        }
        if (type == 0) {
            return ScoreDocComparator.RELEVANCE;
        }
        FieldCacheImpl.Entry entry = factory != null ? new FieldCacheImpl.Entry(field, factory) : new FieldCacheImpl.Entry(field, type, locale);
        return (ScoreDocComparator)Comparators.get(reader, entry);
    }

    static ScoreDocComparator comparatorInt(IndexReader reader, String fieldname) throws IOException {
        String field = fieldname.intern();
        final int[] fieldOrder = FieldCache.DEFAULT.getInts(reader, field);
        return new ScoreDocComparator(){

            public final int compare(ScoreDoc i, ScoreDoc j) {
                int fi = fieldOrder[i.doc];
                int fj = fieldOrder[j.doc];
                if (fi < fj) {
                    return -1;
                }
                if (fi > fj) {
                    return 1;
                }
                return 0;
            }

            public Comparable sortValue(ScoreDoc i) {
                return new Integer(fieldOrder[i.doc]);
            }

            public int sortType() {
                return 4;
            }
        };
    }

    static ScoreDocComparator comparatorLong(IndexReader reader, String fieldname) throws IOException {
        String field = fieldname.intern();
        final long[] fieldOrder = ExtendedFieldCache.EXT_DEFAULT.getLongs(reader, field);
        return new ScoreDocComparator(){

            public final int compare(ScoreDoc i, ScoreDoc j) {
                long li = fieldOrder[i.doc];
                long lj = fieldOrder[j.doc];
                if (li < lj) {
                    return -1;
                }
                if (li > lj) {
                    return 1;
                }
                return 0;
            }

            public Comparable sortValue(ScoreDoc i) {
                return new Long(fieldOrder[i.doc]);
            }

            public int sortType() {
                return 6;
            }
        };
    }

    static ScoreDocComparator comparatorFloat(IndexReader reader, String fieldname) throws IOException {
        String field = fieldname.intern();
        final float[] fieldOrder = FieldCache.DEFAULT.getFloats(reader, field);
        return new ScoreDocComparator(){

            public final int compare(ScoreDoc i, ScoreDoc j) {
                float fi = fieldOrder[i.doc];
                float fj = fieldOrder[j.doc];
                if (fi < fj) {
                    return -1;
                }
                if (fi > fj) {
                    return 1;
                }
                return 0;
            }

            public Comparable sortValue(ScoreDoc i) {
                return new Float(fieldOrder[i.doc]);
            }

            public int sortType() {
                return 5;
            }
        };
    }

    static ScoreDocComparator comparatorDouble(IndexReader reader, String fieldname) throws IOException {
        String field = fieldname.intern();
        final double[] fieldOrder = ExtendedFieldCache.EXT_DEFAULT.getDoubles(reader, field);
        return new ScoreDocComparator(){

            public final int compare(ScoreDoc i, ScoreDoc j) {
                double di = fieldOrder[i.doc];
                double dj = fieldOrder[j.doc];
                if (di < dj) {
                    return -1;
                }
                if (di > dj) {
                    return 1;
                }
                return 0;
            }

            public Comparable sortValue(ScoreDoc i) {
                return new Double(fieldOrder[i.doc]);
            }

            public int sortType() {
                return 7;
            }
        };
    }

    static ScoreDocComparator comparatorString(IndexReader reader, String fieldname) throws IOException {
        String field = fieldname.intern();
        final FieldCache.StringIndex index = FieldCache.DEFAULT.getStringIndex(reader, field);
        return new ScoreDocComparator(){

            public final int compare(ScoreDoc i, ScoreDoc j) {
                int fi = index.order[i.doc];
                int fj = index.order[j.doc];
                if (fi < fj) {
                    return -1;
                }
                if (fi > fj) {
                    return 1;
                }
                return 0;
            }

            public Comparable sortValue(ScoreDoc i) {
                return index.lookup[index.order[i.doc]];
            }

            public int sortType() {
                return 3;
            }
        };
    }

    static ScoreDocComparator comparatorStringLocale(IndexReader reader, String fieldname, Locale locale) throws IOException {
        final Collator collator = Collator.getInstance(locale);
        String field = fieldname.intern();
        final String[] index = FieldCache.DEFAULT.getStrings(reader, field);
        return new ScoreDocComparator(){

            public final int compare(ScoreDoc i, ScoreDoc j) {
                String is = index[i.doc];
                String js = index[j.doc];
                if (is == js) {
                    return 0;
                }
                if (is == null) {
                    return -1;
                }
                if (js == null) {
                    return 1;
                }
                return collator.compare(is, js);
            }

            public Comparable sortValue(ScoreDoc i) {
                return index[i.doc];
            }

            public int sortType() {
                return 3;
            }
        };
    }

    static ScoreDocComparator comparatorAuto(IndexReader reader, String fieldname) throws IOException {
        String field = fieldname.intern();
        Object lookupArray = ExtendedFieldCache.EXT_DEFAULT.getAuto(reader, field);
        if (lookupArray instanceof FieldCache.StringIndex) {
            return FieldSortedHitQueue.comparatorString(reader, field);
        }
        if (lookupArray instanceof int[]) {
            return FieldSortedHitQueue.comparatorInt(reader, field);
        }
        if (lookupArray instanceof long[]) {
            return FieldSortedHitQueue.comparatorLong(reader, field);
        }
        if (lookupArray instanceof float[]) {
            return FieldSortedHitQueue.comparatorFloat(reader, field);
        }
        if (lookupArray instanceof String[]) {
            return FieldSortedHitQueue.comparatorString(reader, field);
        }
        throw new RuntimeException("unknown data type in field '" + field + "'");
    }
}

