/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.util;

import java.awt.Font;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.MissingResourceException;
import javax.xml.transform.TransformerException;
import org.crosswire.bibledesktop.desktop.XSLTProperty;
import org.crosswire.common.swing.GuiConvert;
import org.crosswire.common.util.NetUtil;
import org.crosswire.common.util.ResourceUtil;
import org.crosswire.common.util.URIFilter;
import org.crosswire.common.xml.Converter;
import org.crosswire.common.xml.SAXEventProvider;
import org.crosswire.common.xml.TransformingSAXEventProvider;

public class ConfigurableSwingConverter
implements Converter {
    private static String font = "Serif-PLAIN-14";
    private static String style = "simple.xsl";

    public String[] getStyles() {
        try {
            String search = "xsl/cswing/index.txt";
            URL index = ResourceUtil.getResource((String)search);
            return NetUtil.listByIndexFile((URI)NetUtil.toURI((URL)index), (URIFilter)new XSLTFilter());
        }
        catch (IOException ex) {
            return new String[0];
        }
    }

    public SAXEventProvider convert(SAXEventProvider xmlsep) throws TransformerException {
        try {
            String path = "xsl/cswing/" + style;
            URL xslurl = ResourceUtil.getResource((String)path);
            TransformingSAXEventProvider tsep = new TransformingSAXEventProvider(NetUtil.toURI((URL)xslurl), xmlsep);
            return tsep;
        }
        catch (MissingResourceException ex) {
            throw new TransformerException(ex);
        }
    }

    public static String getFont() {
        return font;
    }

    public static Font toFont() {
        return GuiConvert.string2Font((String)font);
    }

    public static void setFont(String font) {
        ConfigurableSwingConverter.font = font;
        XSLTProperty.FONT.setState(font);
    }

    public static String getResourceName() {
        return style;
    }

    public static void setResourceName(String style) {
        ConfigurableSwingConverter.style = style;
    }

    static final class XSLTFilter
    implements URIFilter {
        XSLTFilter() {
        }

        public boolean accept(String name) {
            return name.endsWith(".xsl");
        }
    }
}

