/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.swing.desktop;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.plaf.TabbedPaneUI;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.common.swing.desktop.AbstractViewLayout;
import org.crosswire.common.swing.desktop.Clearable;
import org.crosswire.common.swing.desktop.TabPopupListener;

public class TDIViewLayout
extends AbstractViewLayout {
    private JTabbedPane tabs = new JTabbedPane();

    public TDIViewLayout() {
        if (UIManager.getDefaults().containsKey("BibleViewPane.TabbedPaneUI")) {
            this.tabs.setUI((TabbedPaneUI)UIManager.get("BibleViewPane.TabbedPaneUI"));
        }
        this.tabs.setMinimumSize(new Dimension(0, 0));
        GuiUtil.applyDefaultOrientation(this.tabs);
    }

    public void addView(Component component) {
        int viewCount = this.getViewCount();
        if (viewCount > 0) {
            if (viewCount == 1) {
                Component first = this.getView(0);
                this.getPanel().remove(first);
                this.tabs.add(first, this.getTitle(first));
                this.getPanel().add((Component)this.tabs, this.getConstraint());
            }
            this.tabs.add(component, this.getTitle(component));
            this.tabs.setSelectedComponent(component);
        } else {
            this.getPanel().add(component, this.getConstraint());
        }
        super.addView(component);
    }

    public void removeView(Component component) {
        int viewCount = this.getViewCount();
        if (viewCount == 1) {
            if (component instanceof Clearable) {
                ((Clearable)((Object)component)).clear();
            }
            return;
        }
        this.tabs.remove(component);
        if (viewCount == 2) {
            Component remaining = this.tabs.getComponentAt(0);
            this.tabs.removeTabAt(0);
            this.getPanel().remove(this.tabs);
            this.getPanel().add(remaining, this.getConstraint());
        }
        super.removeView(component);
    }

    protected void forceRemoveView(Component component) {
        int viewCount = this.getViewCount();
        if (viewCount == 1) {
            this.getPanel().remove(component);
        } else {
            this.tabs.remove(component);
            if (viewCount == 2) {
                Component remaining = this.tabs.getComponentAt(0);
                this.tabs.removeTabAt(0);
                this.getPanel().remove(this.tabs);
                this.getPanel().add(remaining, this.getConstraint());
            }
        }
        super.forceRemoveView(component);
    }

    public void updateTitle(Component component) {
        if (this.getViewCount() > 1) {
            int index = this.tabs.indexOfComponent(component);
            this.tabs.setTitleAt(index, this.getTitle(component));
        }
    }

    public Component getSelected() {
        if (this.getViewCount() == 1) {
            return this.getView(0);
        }
        return this.tabs.getSelectedComponent();
    }

    public void select(Component component) {
        if (this.getViewCount() > 1) {
            this.tabs.setSelectedComponent(component);
        }
    }

    public void addPopup(JPopupMenu popup) {
        TabPopupListener ml = new TabPopupListener(this.tabs, popup);
        this.tabs.addMouseListener(ml);
    }
}

