#include <string.h>
#include <utilstr.h>


/******************************************************************************
 * stdstr - Sets/gets a string
 *
 * ENT:	ipstr	- pointer to a string pointer to set if necessary
 *	istr	- string to set to *ipstr
 *			0 - only get
 *
 * RET:	*ipstr
 */

char *stdstr(char **ipstr, const char *istr)
{
	if (istr) {
		if (*ipstr)
			delete [] *ipstr;
		*ipstr = new char [ strlen(istr) + 1 ];
		strcpy(*ipstr, istr);
	}
	return *ipstr;
}


/******************************************************************************
 * strstrip - Removes leading and trailing spaces from a string
 *
 * ENT:	istr	- string pointer to strip
 *
 * RET:	*istr
 */

char *strstrip(char *istr) {
	char *tmp = istr;
	char *rtmp;

	if (strlen(istr) < 1)
		return istr;
	rtmp = istr + (strlen(istr) - 1);
	
	while (*rtmp == ' ') *(rtmp--) = 0;
	while (*tmp == ' ') tmp++;
	memmove(istr, tmp, (rtmp - tmp) + 1);
	istr[(rtmp - tmp) + 1] = 0;

	return istr;
}

