// --------------------------------------------------------------
// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif


// Things for Sword
#include <stdio.h>
#include <iostream.h>
#include <versekey.h>
#include <rawtext.h>
#include <zcom.h>
#include <rawcom.h>
#include <rawgbf.h>
#include <stdlib.h>
#include <rawcom.h>
#include <rawld.h>
#include <regex.h>

// troy ----------
#include <swmgr.h>
// troy ----------


// I added
#include <stl.h>


#include "wx/notebook.h"
#include "wx/imaglist.h"
#include "wx/toolbar.h"
#include "gui_sword.h"


#ifdef __WXGTK__
#include "mondrian.xpm"
#include "bitmaps/new.xpm"
#include "bitmaps/open.xpm"
#include "bitmaps/save.xpm"
#include "bitmaps/copy.xpm"
#include "bitmaps/cut.xpm"

// #include "bitmaps/paste.xpm"

#include "bitmaps/print.xpm"
#include "bitmaps/preview.xpm"
#include "bitmaps/help.xpm"
#endif

#include "jptr.h"


int ID_CHOICE = 300;

// ===============================================================================
// Global Declarations
// ===============================================================================
class ttextVec : public vector<clJPTR<wxTextCtrl> >{  };
class tpanelVec : public vector<clJPTR<wxPanel> >{  };

class globals {
   private:
      static int id_counter;

   public:
      int get_id() {
	 return (id_counter ++ );
      }
};

int globals::id_counter = 10;
globals	gPool;


IMPLEMENT_APP(MyApp)

// =============================================
// CLASS: cNewNote
//
//	Contain all information for a particular
//	notebook control.
//
// =============================================
template< class tType >
   class cNewNote {
   public:
      class tVec : public vector< clJPTR<tType> >
      {
      };

      private:
	 ttextVec		m_vpTextCtrl;
	 tpanelVec		m_vpPanel;

	 private:
	    clJPTR<wxNotebook>	m_notebook;
	    tVec	    	m_vBookList;

	    public:

	       cNewNote()
	       {
	    }

      void Init( wxPanel* pMainPanel )
      {
	 assert( m_vBookList.size() > 0 && "use AddPage First!" );

	 // Create a new NOTEBOOK item
	 m_notebook =  new wxNotebook( pMainPanel, gPool.get_id() );

	 // Add all the pages
	 make_panels ();

	 // Layout NoteBook in Main Panel
	 wxLayoutConstraints *pLayout = new wxLayoutConstraints;
	 pLayout->left.SameAs       ( pMainPanel, wxLeft );
	 pLayout->top.SameAs        ( pMainPanel, wxTop );
	 pLayout->right.SameAs      ( pMainPanel, wxRight);
	 pLayout->bottom.SameAs     ( pMainPanel, wxBottom);
	 m_notebook -> SetConstraints( pLayout );


	 // Create Initial Verse and Populate notebook texts.
	 VerseKey	oKey;
	 oKey = "Genesis 1:1";
	 oKey.Persist(0);

	 // Update all commentaries and bibles
	 NewVerse( oKey );
      }

      // Create a note book tab, including
      // panel, name of tab, and text area.
      //
// troy ----------
//      make_panels()
      void make_panels()
// troy ----------
      {
	 tVec& oList = m_vBookList;
	 tVec::const_iterator iWalk;

	 // For all books in our list do ...
	 for( iWalk = oList.begin(); iWalk != oList.end(); iWalk ++ )
	 {
	    // Create a new Panel
	    m_vpPanel.push_back( new wxPanel( m_notebook.ptr() ) );
	    m_vpPanel.back() -> SetAutoLayout( TRUE );

	    // Create a Text control for our panel
	    m_vpTextCtrl.push_back( new wxTextCtrl( (m_vpPanel.back()).ptr(),
	       gPool.get_id(), "",
	       wxPoint(-1,-1), wxSize(-1,-1), wxTE_MULTILINE ));

	    // Remove right to edit
	    m_vpTextCtrl.back() -> SetEditable( FALSE );

	    // Set layout for this panel
	    wxLayoutConstraints *pLayout = new wxLayoutConstraints;
	    pLayout->left.SameAs       ( (m_vpPanel.back()).ptr(), wxLeft );
	    pLayout->top.SameAs        ( (m_vpPanel.back()).ptr(), wxTop );
	    pLayout->right.SameAs      ( (m_vpPanel.back()).ptr(), wxRight);
	    pLayout->bottom.SameAs     ( (m_vpPanel.back()).ptr(), wxBottom);
	    m_vpTextCtrl.back() -> SetConstraints(pLayout);

	    // SET: Tab Name
	    m_notebook->AddPage( (m_vpPanel.back()).ptr(), (*iWalk)->Name(NULL), FALSE);
	 }
      }

      // Adds a book I want to reference in my NoteBook.
// troy ----------
//      AddBook( tType* pABook )
      void AddBook( tType* pABook )
// troy ----------
      {
	 m_vBookList.push_back( pABook );
      }


      // ---------------------------------------------------------
      //  NewVerse
      //
      //
// troy ----------
//      NewVerse( VerseKey& oKey )
      void NewVerse( VerseKey& oKey )
// troy ----------
      {
	 tVec::iterator	iWalk;

	 // For every book in my list of books
	 // set this verse
	 for( iWalk = m_vBookList.begin(); 
            iWalk != m_vBookList.end();
            iWalk ++ )
	 {
	    (*iWalk) -> SetKey( oKey );
	 }

	 ttextVec::iterator	iText;
	 tVec::iterator		iBooks = m_vBookList.begin();

	 // For every book, update verse info in text control.
	 for( iText = m_vpTextCtrl.begin();
	    iText != m_vpTextCtrl.end();
	    iText ++, iBooks ++ )
	 {
	    (*iText) -> SetValue( wxString( * ((*iBooks).ptr())  ));
	 }
      }


      // ---------------------------------------------------------
      // UpdateSearch
      //	Given a word, update all windows to reflect
      //	that word.
      //	NOTE: This may only be need by the Definition
      //	Windows.
      //

      void UpdateSearch( const wxString sWord )
      {
	 SWListKey		oList;
	 tVec::iterator		iWalk;
	 ttextVec::iterator	iText = m_vpTextCtrl.begin();
	 char			szBuff[5000] = {  0  };



	 for( iWalk = m_vBookList.begin();
	    iWalk != m_vBookList.end();
	    iWalk ++ )
	 {
	    // For all the matches do:
	    for( SWListKey oListKey = (*iWalk) -> Search(  sWord.c_str(), REG_ICASE );
	       !oListKey.Error();
	       oListKey++ )
	    {
	       strcat( szBuff,  (const char *) oListKey );
	       strcat( szBuff, "\n\n" );
	    }

	    // Update Text of Notebook
	    (*iText) -> SetValue( wxString( szBuff ) );
	 }
	 return;
      }
};




// --------------------------------------------------------
// CLASS: CHEADLINE
//
//

class cHeadLine
{
   public:
      clJPTR<wxComboBox>	m_pBible;
      clJPTR<wxComboBox>	m_pChapter;
      clJPTR<wxComboBox>	m_pVerse;
   private:
      clJPTR<wxButton>		m_pButton;
      
      
   private: // member functions
      // ----------------------------------------------------------
      // Find Book info in one of our 2 book lists.
      // ---------------------------------------------------------
      struct sbook* FindBook( const wxString& sBook )
      {
      	 static const VerseKey oStep;
         
         
	 for(int i = 0; i < 2; i ++ )
	 {
	    for( int j = 0; j < oStep.BMAX[i]; j ++ )
	    {
	       if ( wxStringEq(sBook, wxString(oStep.books[i][j].name)) )
	       {
		  return &oStep.books[i][j];
	       }
	    }
	 }
         return ( NULL );
      }

   public:
      cHeadLine(  wxPanel* pPanel)
      {
	 static wxString	choices[ 200 ];
	 static VerseKey	oStep;
	 int       		k = 0;

	 // Initialize STRINGS of books of bible
	 for( int i = 0; i < 2; i ++ )
	 {
	    for( int j = 0; j < oStep.BMAX[i]; j ++ )
	    {
	       choices[k++] = wxString( oStep.books[i][j].name );
	    }
	 }

	 // Create Bible Book Selector
	 m_pBible = new wxComboBox( pPanel ,
	    ID_CHOICE+1, choices[0], wxPoint(10,10),
	    wxSize(200,-1), k, choices );

	 m_pBible -> SetEditable( FALSE );

	 // Create Chapter Selector
	 m_pChapter = new wxComboBox( pPanel ,
	    ID_CHOICE+2, "", wxPoint(220,10),
	    wxSize(50,-1) );

	 m_pChapter -> SetEditable( FALSE );

	 // Create Verse Selector

	 m_pVerse = new wxComboBox( pPanel ,
	    ID_CHOICE+3, "", wxPoint(280,10),
	    wxSize(50,-1) );

	 m_pVerse -> SetEditable( FALSE );

	 // Create Button for Search for Verse NOW.
	 m_pButton = new wxButton( pPanel,
	    ID_CHOICE+4, "GO!", wxPoint( 340, 10),
	    wxSize( 60 , -1 ));

	 UpdateChapter( choices[0] );
         UpdateVerse( choices[0], 0 );
      }

   

      // -----------------------------------------------------
      // UpdateChapter
      //	Set all chapter numbers for the 1st chapter
      //	of this particular book.
      //
      //
// troy ----------
//      UpdateChapter( const wxString& sBook )
      void UpdateChapter( const wxString& sBook )
// troy ----------
      {
	 struct sbook*	pFound = NULL;
	 wxString	sTemp;

	 // Find Struct of Book Info
	 pFound = FindBook( sBook );
	 assert( pFound && "This should always find something!");

	 // Remove all elements from chapter control.
	 m_pChapter->Clear();

	 // Fill List of Chapters
	 for( int i = 0; i < pFound->chapmax; i ++ )
	 {
	    sTemp.Printf("%2d", i + 1 );
	    m_pChapter->Append( sTemp );
	 }
      }


      // -----------------------------------------------------
      // UpdateVerse
      //	Set all verses for the 1st verse of this
      //	particular chapter, in this particular
      //	book.
      //
      UpdateVerse( wxString sBook, const int iChapter )
      {
	 struct sbook*	pFound = NULL;

         // Find Struct of Book Info
	 pFound = FindBook( sBook );
	 assert( pFound && "This should always find something!");

	 wxString	sTemp;

	 m_pVerse -> Clear();
	 for( int i = 0; i < pFound->versemax[iChapter]; i ++ )
	 {
	    sTemp.Printf( "%d", i + 1 );
	    m_pVerse->Append( sTemp );
	 }
      }
};



// ===================================================================
// CLASS: CDEFHEADLINE
//	Contain Headliner information about Definition notebook.
//

int	WID_STATICTEXT	= 100;
int	WID_TEXT 	= WID_STATICTEXT + 1;


class cDefHeadLine
{
   public:
      clJPTR<wxTextCtrl>	m_pSearchCtrl;

   public:
      cDefHeadLine(wxPanel* pPanel)
      {

	 // Create Bible Book Selector
	 new wxStaticText( pPanel,
	    WID_STATICTEXT, "Dictionary Key:",
	    wxPoint( 10, 15), wxSize( 100, -1 ),
	    wxRAISED_BORDER);

	 m_pSearchCtrl = new wxTextCtrl( pPanel,
	    WID_TEXT, "", wxPoint(105,10),
	    wxSize(200,-1), wxTE_PROCESS_ENTER);
      }
};


// ===================================================================
// CLASS: MyFrame
//
// Define a new frame
class MyFrame: public wxFrame {
   public:
      wxPanel* m_pBiblePanel;
      wxPanel* m_pCommentPanel;
      wxPanel* m_pDefPanel;
      wxPanel* m_pHeadLine;
      wxPanel* m_pDefHeadLine;

      cHeadLine* m_pcHeadLine;
      cDefHeadLine* m_pcDefHeadLine;


/**********************************************
      cNewNote<RawGBF>*	m_pcNoteBible;
      cNewNote<RawCom>*	m_pcNoteCommentary;
      cNewNote<RawLD>* m_pcNoteDef;
**********************************************/
// troy ----------
      cNewNote<SWModule>*	m_pcNoteBible;
      cNewNote<SWModule>*	m_pcNoteCommentary;
      cNewNote<SWModule>*	m_pcNoteDef;
// troy ----------

   public:
      MyFrame(wxFrame *parent, wxWindowID id = -1, const wxString& title = "wxToolBar Sample",
	 const wxPoint& pos = wxDefaultPosition, const wxSize& size = wxDefaultSize,
	 long style = wxDEFAULT_FRAME_STYLE);
// troy ----------
	virtual ~MyFrame();
// troy ----------

   public:
      // Even Handlers
      void OnCloseWindow(wxCloseEvent& event);
      void OnQuit(wxCommandEvent& event);
      void OnAbout(wxCommandEvent& event);
      void OnToolLeftClick(wxCommandEvent& event);
      void OnToolEnter(wxCommandEvent& event);
      void OnBookUpdate( wxCommandEvent& event );
      void OnChapterUpdate( wxCommandEvent& event );
      void OnGoButton( wxCommandEvent& event );
      void OnDefinitionSearch( wxCommandEvent& event );

      DECLARE_EVENT_TABLE()

// troy ------------------
   public:
        SWMgr *mainMgr;
	char CreateTextPane(SWModule *mod, char *font = 0); char CreateCommentPane(SWModule *mod);
	char CreateLDPane(SWModule *mod);
// troy ------------------

};


// ++++++++++++++++++++++++++++++++++++++++++++


// The `main program' equivalent, creating the windows and returning the
// main frame
bool MyApp::OnInit(void)
{
   // CREATE Main Frame
   MyFrame* pFrame =
      new MyFrame((wxFrame *) NULL, -1,
      (const wxString) "Sword Project 1.0",
      wxPoint(100, 100), wxSize(650, 500));

   // CREATE Status Line
   pFrame -> CreateStatusBar();

   // SET: Auto Layout
   pFrame -> SetAutoLayout( TRUE );

   // SET: Icon
   pFrame->SetIcon( wxIcon(mondrian_xpm) );

   // CREATE File Menu
   wxMenu *fileMenu = new wxMenu;

   fileMenu->Append(wxID_EXIT, "E&xit");

   // CREATE Help Menu
   wxMenu *helpMenu = new wxMenu;
   helpMenu->Append(wxID_HELP, "&About");

   // CREATE Menu Bar
   wxMenuBar* menuBar = new wxMenuBar;

   menuBar->Append(fileMenu, "&File");
   menuBar->Append(helpMenu, "&Help");

   // ASSOCIATE: Menubar and Frame
   pFrame->SetMenuBar(menuBar);

   // CREATE: toolbar
   pFrame->CreateToolBar(wxNO_BORDER|wxHORIZONTAL|wxTB_FLAT, ID_TOOLBAR);

   // INITIALIZE: toolbar
   InitToolbar(pFrame->GetToolBar());

   // Text Message
   pFrame->SetStatusText("Alpha $Revision: 1.8 $:Linux Version:Sword Development Team.");

   // Add Panel Info ==============================================

   // CREATE: Bible All Major Panels
   pFrame->m_pBiblePanel = 	new wxPanel(pFrame, 0, 0, 10, 10, wxTAB_TRAVERSAL);
   pFrame->m_pCommentPanel =	new wxPanel(pFrame, 0, 0, 10, 10, wxTAB_TRAVERSAL);
   pFrame->m_pDefPanel =	new wxPanel(pFrame, 0, 0, 10, 10, wxTAB_TRAVERSAL);
   pFrame->m_pHeadLine =	new wxPanel(pFrame, 0, 0, 10, 10, wxRAISED_BORDER);
   pFrame->m_pDefHeadLine = 	new wxPanel(pFrame, 0, 0, 10, 10, wxRAISED_BORDER);

   // pFrame->m_pDefPanel->SetBackgroundColour(wxColour(192, 192, 192));

   // Set constraints for panel subwindow
   wxLayoutConstraints *pLayout = new wxLayoutConstraints;

   // Set constraints for Head Line Window

   pLayout->left.SameAs       ( pFrame, wxLeft );
   pLayout->right.SameAs      ( pFrame, wxRight);
   pLayout->top.SameAs         ( pFrame, wxTop );
   pLayout->height.PercentOf  ( pFrame, wxHeight, 10 );

   pFrame-> m_pHeadLine ->SetConstraints( pLayout );

   // Bible Constraints
   pLayout = new wxLayoutConstraints;
   pLayout->left.SameAs       (pFrame, wxLeft);
   pLayout->right.PercentOf   (pFrame, wxWidth, 60);
   pLayout->top.SameAs        ( pFrame -> m_pHeadLine, wxBottom );
   pLayout->height.PercentOf  (pFrame, wxHeight, 50);

   pFrame-> m_pBiblePanel -> SetConstraints( pLayout );

   // Commentary Constraints
   pLayout = new wxLayoutConstraints;

   pLayout->left.SameAs       ( pFrame->m_pBiblePanel, wxRight );
   pLayout->right.SameAs      ( pFrame, wxRight );
   pLayout->top.SameAs        ( pFrame -> m_pHeadLine, wxBottom );
   pLayout->height.PercentOf  ( pFrame, wxHeight, 50 );

   pFrame-> m_pCommentPanel -> SetConstraints( pLayout );

   // Set constraints for Definition Search
   pLayout = new wxLayoutConstraints;

   pLayout->left.SameAs       ( pFrame, wxLeft );
   pLayout->right.SameAs      ( pFrame, wxRight);
   pLayout->top.SameAs         ( pFrame->m_pBiblePanel, wxBottom );
   pLayout->height.PercentOf  ( pFrame, wxHeight, 10 );

   pFrame -> m_pDefHeadLine -> SetConstraints( pLayout );

   // Definition Window
   pLayout = new wxLayoutConstraints;
   pLayout->left.SameAs       ( pFrame, wxLeft );
   pLayout->right.SameAs      ( pFrame, wxRight);
   pLayout->top.SameAs         ( pFrame->m_pDefHeadLine, wxBottom );
   pLayout->bottom.SameAs     ( pFrame, wxBottom);

   pFrame-> m_pDefPanel ->SetConstraints( pLayout );



   // =====================================================
   // Hard Coded
   pFrame -> m_pcHeadLine = new cHeadLine( pFrame -> m_pHeadLine );
   pFrame -> m_pcDefHeadLine = new cDefHeadLine( pFrame -> m_pDefHeadLine );



// troy ----------
	pFrame -> m_pcNoteBible = new cNewNote<SWModule>;
	pFrame -> m_pcNoteCommentary = new cNewNote<SWModule>;
	pFrame -> m_pcNoteDef = new cNewNote<SWModule>;

	ModMap::iterator it;
	SectionMap::iterator sit;
	ConfigEntMap::iterator eit;
	char *font;

	pFrame->mainMgr = new SWMgr();
	for (it = pFrame->mainMgr->Modules.begin(); it != pFrame->mainMgr->Modules.end(); it++) {
		if (!strcmp((*it).second->Type(), "Biblical Texts")) {
			font = 0;
			if ((sit = pFrame->mainMgr->config->Sections.find((*it).second->Name())) != pFrame->mainMgr->config->Sections.end()) {
				if ((eit = (*sit).second.find("Font")) != (*sit).second.end()) {
					font = (char *)(*eit).second.c_str();
				}
			}
			pFrame->CreateTextPane((*it).second, font);
		}
		if (!strcmp((*it).second->Type(), "Commentaries"))
			pFrame->CreateCommentPane((*it).second);
		if (!strcmp((*it).second->Type(), "Lexicons / Dictionaries"))
			pFrame->CreateLDPane((*it).second);
	}
// troy ----------


/**************************************************************************
   pFrame -> m_pcNoteBible = new cNewNote<RawGBF>;

   pFrame -> m_pcNoteBible -> AddBook( 
      new RawGBF("/home/lcortes/SWORD/sword/texts/modules/texts/rawgbf/nasb/", 
      "NASB", "New American Standard Bible"));
      
  pFrame -> m_pcNoteBible -> AddBook( 
      new RawGBF("/home/lcortes/SWORD/sword/texts/modules/texts/rawgbf/spanishrva/", 
      "SRVA", "Spanish Reina Valeria"));      
   // Attempt to set a verse

   pFrame -> m_pcNoteCommentary = new cNewNote<RawCom>;

   pFrame -> m_pcNoteCommentary -> AddBook( 
      new RawCom("/home/lcortes/SWORD/sword/texts/modules/comments/rawcom/rwp/", 
      "RWP", "RWP Commentary"));
   pFrame -> m_pcNoteCommentary -> AddBook( 
      new RawCom("/home/lcortes/SWORD/sword/texts/modules/comments/rawcom/mhc/", 
      "MHC", "Matthew Henry's Commentary on the Whole Bible"));


   pFrame -> m_pcNoteDef = new cNewNote<RawLD>;

   pFrame -> m_pcNoteDef -> AddBook( 
      new RawLD("../../../texts/modules/lexdict/rawld/eastons/", 
      "Eastons", "Eastons Dictionary"));     
  pFrame -> m_pcNoteDef -> AddBook( 
      new RawLD("/home/lcortes/SWORD/sword/texts/modules/lexdict/rawld/naves/", 
      "Naves", "Naves Dictionary"));
  pFrame -> m_pcNoteDef -> AddBook( 
      new RawLD("/home/lcortes/SWORD/sword/texts/modules/lexdict/rawld/vines/", 
      "Vines", "Vines Dictionary"));            

*************************************************************************/

   pFrame -> m_pcNoteBible -> Init( pFrame -> m_pBiblePanel );
   pFrame -> m_pcNoteCommentary -> Init( pFrame -> m_pCommentPanel );
   pFrame -> m_pcNoteDef -> Init( pFrame -> m_pDefPanel );

   // Force a resize. This should probably be replaced by a call to a wxFrame
   // function that lays out default decorations and the remaining content window.

   // pFrame->OnSize(wxSizeEvent(wxSize(-1, -1), pFrame->GetId()) );
   pFrame->Show(TRUE);

   // =================================================

   SetTopWindow( pFrame );
   return TRUE;
}


// troy ----------
/******************************************************************************
 * CreateTextPane - creates a new pane in the tabsheet for a Bible Text
 *
 * mod	- Bible text module to associate with this panel
 * font	- font to use for displaying this module (default = 0)
 *
 * RETURN: error status
 */

char MyFrame::CreateTextPane(SWModule *mod, char *font) {

	// need to make use of font for displaying Greek MSS

	m_pcNoteBible->AddBook(mod);      
	return 0;
}


/******************************************************************************
 * CreateCommentPane - creates a new pane in the tabsheet for a Bible
 * 			Commentary
 *
 * mod	- Bible commentary module to associate with this panel
 *
 * RETURN: error status
 */

char MyFrame::CreateCommentPane(SWModule *mod) {
	m_pcNoteCommentary->AddBook(mod);
	return 0;
}


/******************************************************************************
 * CreateLDPane - creates a new pane in the tabsheet for a Bible
 * 			Lexicon or Dictionary
 *
 * mod	- Bible text module to associate with this panel
 *
 * RETURN: error status
 */

char MyFrame::CreateLDPane(SWModule *mod) {
	m_pcNoteDef->AddBook(mod);
	return 0;
}

// troy ----------





bool MyApp::InitToolbar(wxToolBar* toolBar)
{
   toolBar->SetMargins(5, 5);

   // Set up toolbar
   wxBitmap* toolBarBitmaps[8];

   toolBarBitmaps[0] = new wxBitmap( new_xpm );
   toolBarBitmaps[1] = new wxBitmap( open_xpm );
   toolBarBitmaps[2] = new wxBitmap( save_xpm );
   toolBarBitmaps[3] = new wxBitmap( copy_xpm );
   toolBarBitmaps[4] = new wxBitmap( cut_xpm );
   //  toolBarBitmaps[5] = new wxBitmap( paste_xpm );
   toolBarBitmaps[5] = new wxBitmap( preview_xpm );
   toolBarBitmaps[6] = new wxBitmap( print_xpm );
   toolBarBitmaps[7] = new wxBitmap( help_xpm );

   int width = 16;
   int currentX = 5;

   toolBar->AddTool(wxID_NEW, *(toolBarBitmaps[0]), wxNullBitmap, FALSE, (float)currentX, -1, (wxObject *) NULL, "New file");
   currentX += width + 5;
   toolBar->AddTool(wxID_OPEN, *(toolBarBitmaps[1]), wxNullBitmap, FALSE, (float)currentX, -1, (wxObject *) NULL, "Open file");
   currentX += width + 5;
   toolBar->AddTool(wxID_SAVE, *(toolBarBitmaps[2]), wxNullBitmap, FALSE, (float)currentX, -1, (wxObject *) NULL, "Save file");
   currentX += width + 5;
   toolBar->AddSeparator();
   toolBar->AddTool(wxID_COPY, *(toolBarBitmaps[3]), wxNullBitmap, FALSE, (float)currentX, -1, (wxObject *) NULL, "Copy");
   currentX += width + 5;
   toolBar->AddTool(wxID_CUT, *(toolBarBitmaps[4]), wxNullBitmap, FALSE, (float)currentX, -1, (wxObject *) NULL, "Cut");
   currentX += width + 5;
   toolBar->AddTool(wxID_PASTE, *(toolBarBitmaps[5]), wxNullBitmap, FALSE, (float)currentX, -1, (wxObject *) NULL, "Paste");
   currentX += width + 5;
   toolBar->AddSeparator();
   toolBar->AddTool(wxID_PRINT, *(toolBarBitmaps[6]), wxNullBitmap, FALSE, (float)currentX, -1, (wxObject *) NULL, "Print");
   currentX += width + 5;
   toolBar->AddSeparator();
   toolBar->AddTool(wxID_HELP, *(toolBarBitmaps[7]), wxNullBitmap, FALSE, currentX, -1, (wxObject *) NULL, "Help");

   toolBar->Realize();

   // Can delete the bitmaps since they're reference counted
   int i;
   for (i = 0; i < 8; i++)
      delete toolBarBitmaps[i];

   return TRUE;
}

// wxID_HELP will be processed for the 'About' menu and the toolbar help button.

BEGIN_EVENT_TABLE(MyFrame, wxFrame)
   EVT_MENU(wxID_EXIT, MyFrame::OnQuit)
   EVT_MENU(wxID_HELP, MyFrame::OnAbout)
   EVT_CLOSE(MyFrame::OnCloseWindow)
   EVT_TOOL_RANGE(wxID_OPEN, wxID_PASTE, MyFrame::OnToolLeftClick)
   EVT_TOOL_ENTER(ID_TOOLBAR, MyFrame::OnToolEnter)
   EVT_CHOICE(ID_CHOICE+1, MyFrame::OnBookUpdate)
   EVT_CHOICE(ID_CHOICE+2, MyFrame::OnChapterUpdate)
   EVT_BUTTON(ID_CHOICE+4, MyFrame::OnGoButton)

// REQUIREMENT: On enter on text to search
EVT_TEXT(WID_TEXT, MyFrame::OnDefinitionSearch )

// End
END_EVENT_TABLE()

// Define my frame constructor
MyFrame::MyFrame(wxFrame* parent, wxWindowID id, const wxString& title, const wxPoint& pos,
   const wxSize& size, long style):
   wxFrame(parent, id, title, pos, size, style)
   {
      //      m_textWindow = new wxTextCtrl(this, -1, "", wxPoint(0, 0), wxSize(-1, -1), wxTE_MULTILINE);
// troy ----------
      mainMgr = 0;
// troy ----------
   }

// troy ----------
MyFrame::~MyFrame() {
	if (mainMgr)
		delete mainMgr;
}
// troy ----------

void MyFrame::OnQuit(wxCommandEvent& WXUNUSED(event))
{
   Close(TRUE);
}

void MyFrame::OnAbout(wxCommandEvent& WXUNUSED(event))
{
   static char * szMess =
   {
      "Sword Project 1.0\n"
	 "Linux Version\n"
	 "Sword Development Team\n"
	 "LC\n"
};


(void)wxMessageBox( szMess , "About Sword");
}

// Define the behaviour for the frame closing
// - must delete all frames except for the main one.
void MyFrame::OnCloseWindow(wxCloseEvent& WXUNUSED(event))
{
   Destroy();
}

void MyFrame::OnToolLeftClick(wxCommandEvent& event)
{
   wxString str;
   str.Printf("Clicked on tool %d", event.GetId());
   SetStatusText(str);
}

void MyFrame::OnToolEnter(wxCommandEvent& event)
{
   if (event.GetSelection() > -1)
   {
      wxString str;
      str.Printf("This is tool number %d", event.GetSelection());
      SetStatusText(str);
   }
   else
      SetStatusText("");
}


// ============================================================================
// OnBookUpdate
// When the book changes we do 3 things.
// 1.  Reset verse and chapter to 1 ( all books have 1 chapter 1 verse ).
// 2.  Update the valid list of Chapters 1..ChapterMax for this book
// 3.  Update the verse list for the first chapter (1..verse max for this chapter).
//
void MyFrame::OnBookUpdate( wxCommandEvent& event )
{
   if (event.GetSelection() > -1)
   {

      if (m_pcHeadLine)
      {
         // Get book name.
	 wxString sBook = m_pcHeadLine ->m_pBible->GetString( event.GetSelection() );

         // Update chapter (automagically calls OnChapterUpdate )
	 m_pcHeadLine -> UpdateChapter( sBook );
      }
   }
}

// ===============================================================
// On chapter change we need to do
// 1.  Update Verse information for this chapter.
//
void MyFrame::OnChapterUpdate( wxCommandEvent& event )
{
   if (event.GetSelection() > -1 )
   {

      if (m_pcHeadLine)
      {
         // Get Book and current chapter
	 wxString sBook = m_pcHeadLine -> m_pBible -> GetValue();
	 int  iChapter = event.GetSelection();

	 m_pcHeadLine -> UpdateVerse( sBook, iChapter );
      }
   }
}

void MyFrame::OnGoButton( wxCommandEvent& event )
{
   VerseKey oKey;
   wxString sNewVerse;

   assert( m_pcHeadLine );
   assert( m_pcNoteBible );
   assert( m_pcNoteCommentary );


   if ( m_pcHeadLine )
   {
      // Get Selection Data
      wxString sTemp	= m_pcHeadLine ->m_pBible-> GetValue();
      int  iChapter	= atoi(m_pcHeadLine -> m_pChapter -> GetValue());
      int  iVerse	= atoi(m_pcHeadLine -> m_pVerse -> GetValue());

      sNewVerse.Printf( "%s %d:%d", sTemp.c_str(), iChapter, iVerse );

      // Set new verse into key
      oKey = sNewVerse;
      oKey.Persist(1);

      // Update current verse
      SetStatusText( sNewVerse );

      // Update all commentaries and bibles
      m_pcNoteBible -> NewVerse( oKey );
      m_pcNoteCommentary -> NewVerse( oKey );
   }
}


// ----------------------------------------------------
// OnDefinitionSearch
//	Search for definition of the word in the
//	text area.  Use the definition NOTEBOOK object.
//
//

void MyFrame::OnDefinitionSearch(  wxCommandEvent& event )
{
   if (m_pcDefHeadLine)
   {
      wxString sDefinition = wxString( "Searching for: ") 
         + m_pcDefHeadLine -> m_pSearchCtrl -> GetValue();
      SetStatusText( sDefinition );
 
 m_pcNoteDef -> UpdateSearch( sDefinition );
      
   }
}
