/******************************************************************************
 *  rawld.cpp - code for class 'RawLD'- a module that reads raw lexicon and
 *				dictionary files: *.dat *.idx
 */


#include <ctype.h>
#include <stdio.h>
#include <fcntl.h>

#ifndef __GNUC__
#include <io.h>
#else
#include <unistd.h>
#endif

#include <string.h>
#include <utilfuns.h>
#include <rawstr.h>
#include <rawld.h>


 /******************************************************************************
 * RawLD Constructor - Initializes data for instance of RawLD
 *
 * ENT:	ipath	- path and filename of files (no extension)
 *		iname	- Internal name for module
 *		idesc	- Name to display to user for module
 *		idisp	- Display object to use for displaying
 */

RawLD::RawLD(const char *ipath, const char *iname, const char *idesc, SWDisp *idisp) : RawStr(ipath), SWLD(iname, idesc, idisp)
{
}


/******************************************************************************
 * RawLD Destructor - Cleans up instance of RawLD
 */

RawLD::~RawLD()
{
}


/******************************************************************************
 * RawLD::operator char *	- Returns the correct entry when char * cast
 *							is requested
 *
 * RET: string buffer with entry
 */

RawLD::operator char*()
{
	long  start;
	short size;
	char *idxbuf;
	char padbuf[10];
	const char *buf;

	size = 0;
	for (buf = *key; *buf; buf++) {
		if (!isdigit(*buf))
			break;
		else size++;
	}

	if ((size == strlen(*key)) && size) {
		sprintf(padbuf, "%.5d", atoi(*key));
		buf = padbuf;
	}
	else buf = *key;
		
	
	findoffset(buf, &start, &size);

	if (entrybuf)
		delete [] entrybuf;
	entrybuf = new char [ size * 2 ];
	idxbuf   = new char [ size + 1 ];

	gettext(start, size + 1, idxbuf, entrybuf);
	if (!key->Persist())			// If we have our own key
		*key = idxbuf;				// reset it to entry index buffer
		
	stdstr(&entkeytxt, idxbuf);	// set entry key text that module 'snapped' to.
					
	preptext(entrybuf);
	RenderText(entrybuf, size * 2);

	delete [] idxbuf;

	return entrybuf;
}
