/******************************************************************************
 *  swkey.h   - code for base class 'swkey'.  swkey is the basis for all
 *	        types of keys for indexing into modules (e.g. verse, word,
 *		place, etc.)
 */

#ifndef SWKEY_H
#define SWKEY_H

#define KEYERR_OUTOFBOUNDS 1

// For use with = operator to position key.

class POSITION {
	char pos;
public:
	POSITION(char ipos) { pos = ipos; }
	operator char() { return pos; }
};

#define POS_TOP ((char)1)
#define POS_BOTTOM ((char)2)

#define TOP POSITION(1)
#define BOTTOM POSITION(2)

class SWKey {
protected:
	char *keytext;
	char persist;
	char error;
public:
	SWKey(const char *ikey = 0);
	virtual ~SWKey();


	char Persist() const;
	char Persist(char ikey);

	virtual char Error();
	virtual SWKey &operator =(const char *ikey);
	virtual SWKey &operator =(SWKey &ikey);
	virtual operator const char*();

	virtual char operator ==(SWKey &ikey);
	virtual char operator  >(SWKey &ikey);
	virtual char operator  <(SWKey &ikey);
	virtual char operator >=(SWKey &ikey) { return ((*this > ikey) || (*this == ikey)); }
	virtual char operator <=(SWKey &ikey) { return ((*this < ikey) || (*this == ikey)); }
	virtual SWKey &operator =(POSITION);
	virtual SWKey &operator -=(int);
	virtual SWKey &operator +=(int);
	virtual SWKey &operator ++(int) { return *this += 1; }
	virtual SWKey &operator --(int) { return *this -= 1; }
};


#endif
