/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.crosswire.common.util.CallContext;
import org.crosswire.common.util.NetUtil;

public final class CWClassLoader
extends ClassLoader {
    private Class owner;
    private static URI[] homes;

    CWClassLoader(Class resourceOwner) {
        this.owner = resourceOwner;
    }

    CWClassLoader() {
        this.owner = CallContext.getCallingClass();
    }

    public static CWClassLoader instance(Class resourceOwner) {
        return (CWClassLoader)AccessController.doPrivileged(new PrivilegedLoader(resourceOwner));
    }

    public static CWClassLoader instance() {
        Class resourceOwner = CallContext.getCallingClass();
        return CWClassLoader.instance(resourceOwner);
    }

    public URL findResource(String search) {
        URI homeResource;
        String newsearch;
        URL resource = null;
        if (search == null || search.length() == 0) {
            return resource;
        }
        if (search.charAt(0) != '/') {
            resource = this.findResource('/' + search);
        }
        if (resource == null && !search.equals(newsearch = this.adjustPackageSearch(search))) {
            resource = this.findResource(newsearch);
        }
        if (resource == null && !search.equals(newsearch = this.adjustPathSearch(search))) {
            resource = this.findResource(newsearch);
        }
        if (resource == null && (homeResource = CWClassLoader.findHomeResource(search)) != null) {
            resource = NetUtil.toURL(homeResource);
        }
        if (resource == null) {
            resource = this.owner.getResource(search);
        }
        if (resource == null) {
            resource = this.getClassLoader().getResource(search);
        }
        if (resource == null) {
            resource = ClassLoader.getSystemResource(search);
        }
        if (resource == null) {
            resource = super.findResource(search);
        }
        return resource;
    }

    private String adjustPackageSearch(String aSearch) {
        String search = aSearch;
        if (search.indexOf(47, 1) == -1) {
            String className = this.owner.getName();
            String pkgPrefix = className.substring(0, className.lastIndexOf(46) + 1);
            if (search.charAt(0) == '/') {
                String part = search.substring(1);
                if (!part.startsWith(pkgPrefix)) {
                    search = '/' + pkgPrefix + part;
                }
            } else if (!search.startsWith(pkgPrefix)) {
                search = pkgPrefix + search;
            }
        }
        return search;
    }

    private String adjustPathSearch(String aSearch) {
        String search = aSearch;
        if (search.indexOf(47, 1) != -1) {
            search = search.charAt(0) == '/' ? '/' + search.substring(1).replace('/', '.') : search.replace('/', '.');
        }
        return search;
    }

    public ClassLoader getClassLoader() {
        ClassLoader loader = CWClassLoader.pickLoader(Thread.currentThread().getContextClassLoader(), this.owner.getClassLoader());
        return CWClassLoader.pickLoader(loader, ClassLoader.getSystemClassLoader());
    }

    private static ClassLoader pickLoader(ClassLoader loader1, ClassLoader loader2) {
        ClassLoader loader = loader2;
        if (loader1 != loader2) {
            loader = loader1;
            if (loader1 == null) {
                loader = loader2;
            } else {
                for (ClassLoader curloader = loader2; curloader != null; curloader = curloader.getParent()) {
                    if (curloader != loader1) continue;
                    loader = loader2;
                    break;
                }
            }
        }
        return loader;
    }

    public static synchronized URI getHome(int i) {
        if (i > 0 && i < homes.length) {
            return homes[i];
        }
        return null;
    }

    public static synchronized void setHome(URI[] newHomes) {
        homes = new URI[newHomes.length];
        System.arraycopy(newHomes, 0, homes, 0, newHomes.length);
    }

    public static URI findHomeResource(String search) {
        if (homes == null) {
            return null;
        }
        for (int i = 0; i < homes.length; ++i) {
            URI homeURI = homes[i];
            URI override = NetUtil.lengthenURI(homeURI, search);
            if (!NetUtil.canRead(override)) continue;
            return override;
        }
        return null;
    }

    private static class PrivilegedLoader
    implements PrivilegedAction {
        private Class owningClass;

        public PrivilegedLoader(Class resourceOwner) {
            this.owningClass = resourceOwner;
        }

        public PrivilegedLoader() {
            this.owningClass = CallContext.getCallingClass();
        }

        public Object run() {
            return new CWClassLoader(this.owningClass);
        }
    }
}

