/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.progress;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import org.crosswire.common.progress.JobManager;
import org.crosswire.common.progress.Progress;
import org.crosswire.common.progress.UserMsg;
import org.crosswire.common.progress.WorkEvent;
import org.crosswire.common.progress.WorkListener;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.NetUtil;

public final class Job
implements Progress {
    private int totalWork;
    private boolean cancelable;
    private boolean finished;
    private int work;
    private long sectionEnd;
    private long sectionStart;
    private int percentEnd;
    private String jobName;
    private Thread workerThread;
    private String sectionName;
    private long start;
    private Map current;
    private Map predicted;
    private int predictedLength;
    private URI predictURI;
    private Timer updater;
    private List listeners;
    private static final Logger log = Logger.getLogger(Job.class);

    protected Job(String description, URI predictURI, Thread worker, int totalWork) {
        this.predictURI = predictURI;
        this.workerThread = worker;
        this.listeners = new ArrayList();
        this.start = -1L;
        this.predictedLength = -1;
        this.beginJob(description, totalWork);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginJob(String name, int workToDo) {
        if (this.finished) {
            return;
        }
        Job job = this;
        synchronized (job) {
            this.totalWork = workToDo;
            this.sectionName = name;
            this.jobName = name;
            this.work = 0;
            this.finished = false;
            boolean bl = this.cancelable = this.workerThread != null;
            if (this.totalWork == -1) {
                this.updater = new Timer();
                this.updater.schedule((TimerTask)new PredictTask(), 0L, 100L);
            }
            if (this.predictURI != null) {
                this.loadPredictions();
            }
            this.current = new HashMap();
            this.start = System.currentTimeMillis();
        }
        JobManager.fireWorkProgressed(this);
    }

    public synchronized int getTotalWork() {
        return this.totalWork;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSectionName(String statedesc) {
        if (this.finished) {
            return;
        }
        boolean doUpdate = false;
        Job job = this;
        synchronized (job) {
            this.sectionName = statedesc;
            boolean bl = doUpdate = this.updater != null;
            if (doUpdate) {
                if (this.predictedLength != 0) {
                    this.setWork(100 * this.getAgeFromMap(this.predicted, statedesc) / this.predictedLength);
                } else {
                    this.setWork(0);
                }
            }
            this.predictSection(statedesc);
            this.current.put(statedesc, new Integer((int)(System.currentTimeMillis() - this.start)));
        }
        if (doUpdate) {
            JobManager.fireWorkProgressed(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWork(int work) {
        if (this.finished) {
            return;
        }
        Job job = this;
        synchronized (job) {
            if (this.work == work) {
                return;
            }
            this.work = work;
            this.predictSection(this.sectionName);
            this.current.put(this.sectionName, new Integer((int)(System.currentTimeMillis() - this.start)));
        }
        JobManager.fireWorkProgressed(this);
    }

    public void setProgress(int work, String statedesc) {
        this.setSectionName(statedesc);
        this.setWork(work);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() {
        Job job = this;
        synchronized (job) {
            this.finished = true;
            this.sectionName = UserMsg.DONE.toString();
            this.work = 100;
            if (this.updater != null) {
                this.updater.cancel();
                this.updater = null;
            }
            this.current.put(this.sectionName, new Integer((int)(System.currentTimeMillis() - this.start)));
        }
        JobManager.fireWorkProgressed(this);
        job = this;
        synchronized (job) {
            if (this.predictURI != null) {
                this.savePredictions();
            }
        }
    }

    public synchronized String getSectionName() {
        return this.sectionName;
    }

    public void cancel() {
        if (!this.finished) {
            this.ignoreTimings();
            this.done();
            if (this.workerThread != null) {
                this.workerThread.interrupt();
            }
        }
    }

    public boolean isCancelable() {
        return this.cancelable;
    }

    public void setCancelable(boolean newInterruptable) {
        if (this.workerThread == null || this.finished) {
            return;
        }
        this.cancelable = newInterruptable;
        this.fireStateChanged();
    }

    public boolean isFinished() {
        return this.finished;
    }

    public synchronized int getWork() {
        return this.work;
    }

    public synchronized String getJobName() {
        return this.jobName;
    }

    private synchronized void ignoreTimings() {
        this.predictURI = null;
    }

    public synchronized void addWorkListener(WorkListener li) {
        ArrayList<WorkListener> temp = new ArrayList<WorkListener>();
        temp.addAll(this.listeners);
        if (!temp.contains(li)) {
            temp.add(li);
            this.listeners = temp;
        }
    }

    public synchronized void removeWorkListener(WorkListener li) {
        if (this.listeners.contains(li)) {
            ArrayList temp = new ArrayList();
            temp.addAll(this.listeners);
            temp.remove(li);
            this.listeners = temp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireStateChanged() {
        WorkEvent ev = new WorkEvent(this);
        ArrayList temp = new ArrayList();
        Job job = this;
        synchronized (job) {
            if (this.listeners != null) {
                temp.addAll(this.listeners);
            }
        }
        int count = temp.size();
        for (int i = 0; i < count; ++i) {
            ((WorkListener)temp.get(i)).workStateChanged(ev);
        }
    }

    private synchronized int getAgeFromMap(Map props, String message) {
        if (props == null) {
            return 0;
        }
        Integer time = (Integer)props.get(message);
        if (time != null) {
            return time;
        }
        return 0;
    }

    protected synchronized void guessProgress() {
        long now = System.currentTimeMillis();
        if (now < this.sectionStart) {
            log.warn("now before started: now=" + new Date(now) + " started=" + new Date(this.sectionStart));
            return;
        }
        if (now == this.sectionStart) {
            return;
        }
        if (now > this.sectionEnd) {
            this.work = this.percentEnd;
            return;
        }
        int sectlen = (int)(this.sectionEnd - this.sectionStart);
        int sectpc = (int)(100L * (now - this.sectionStart) / (long)sectlen);
        int boost = sectpc * (this.percentEnd - this.work) / 100;
        int total = this.work + boost;
        this.work = total = total <= 100 ? total : 100;
    }

    private synchronized void predictSection(String message) {
        this.sectionStart = System.currentTimeMillis();
        if (this.predicted == null || this.predictedLength == 0) {
            this.sectionEnd = 10000L;
            this.percentEnd = 10;
            return;
        }
        int predsectstart = this.getAgeFromMap(this.predicted, this.sectionName);
        int predsectend = Integer.MAX_VALUE;
        Iterator iter = this.predicted.keySet().iterator();
        while (iter.hasNext()) {
            String title = (String)iter.next();
            int age = (Integer)this.predicted.get(title);
            if (age <= predsectstart || age >= predsectend) continue;
            predsectend = age;
        }
        int predsecttime = predsectend - predsectstart;
        this.sectionEnd = this.sectionStart + (long)predsecttime;
        int pcstart = 100 * predsectstart / this.predictedLength;
        int pcend = 100 * predsectend / this.predictedLength;
        int pcdiff = pcend - pcstart;
        this.percentEnd = this.work + pcdiff;
        log.debug("Predicting " + predsecttime + "ms (" + this.work + '-' + this.percentEnd + "%) for section " + message);
    }

    private synchronized void loadPredictions() {
        try {
            this.predicted = new HashMap();
            Properties temp = NetUtil.loadProperties(this.predictURI);
            Iterator<Object> iter = temp.keySet().iterator();
            while (iter.hasNext()) {
                String title = (String)iter.next();
                String timestr = temp.getProperty(title);
                try {
                    Integer time = new Integer(timestr);
                    this.predicted.put(title, time);
                    int age = time;
                    if (age <= this.predictedLength) continue;
                    this.predictedLength = age;
                }
                catch (NumberFormatException ex) {
                    log.error("Time format error", ex);
                }
            }
        }
        catch (IOException ex) {
            log.debug("Failed to load prediction times - guessing");
        }
    }

    private synchronized void savePredictions() {
        long end = this.start;
        Iterator iter = this.current.keySet().iterator();
        while (iter.hasNext()) {
            String message = (String)iter.next();
            int age = this.getAgeFromMap(this.current, message);
            if ((long)age <= end) continue;
            end = age;
        }
        Properties predictions = new Properties();
        iter = this.current.keySet().iterator();
        while (iter.hasNext()) {
            String message = (String)iter.next();
            int age = this.getAgeFromMap(this.current, message);
            predictions.setProperty(message, Integer.toString(age));
        }
        try {
            NetUtil.storeProperties(predictions, this.predictURI, "Predicted Startup Times");
        }
        catch (IOException ex) {
            log.error("Failed to save prediction times", ex);
        }
    }

    final class PredictTask
    extends TimerTask {
        private static final long serialVersionUID = 3256721784160924983L;

        PredictTask() {
        }

        public void run() {
            Job.this.guessProgress();
            JobManager.fireWorkProgressed(Job.this);
        }
    }
}

