/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.options;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.crosswire.common.options.Option;

public class OptionList {
    private Map shortOptions;
    private Map longOptions = new LinkedHashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    public OptionList() {
        this.shortOptions = new LinkedHashMap();
    }

    public void add(Option option) {
        char shortName = option.getShortName();
        String longName = option.getLongName();
        if (shortName != '\u0000') {
            String optionName = Character.toString(shortName);
            if (!$assertionsDisabled && this.shortOptions.containsKey(optionName)) {
                throw new AssertionError((Object)(optionName + " already present"));
            }
            this.shortOptions.put(optionName, option);
        }
        if (longName != null) {
            if (!$assertionsDisabled && this.longOptions.containsKey(longName)) {
                throw new AssertionError((Object)(longName + " already present"));
            }
            this.longOptions.put(longName, option);
        }
    }

    public List getLongOptions(String key) {
        ArrayList matches = new ArrayList();
        if (this.longOptions.containsKey(key)) {
            matches.add(this.longOptions.get(key));
        }
        Iterator iter = this.longOptions.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String entryKey = (String)entry.getKey();
            Object entryValue = entry.getValue();
            if (!entryKey.startsWith(key) || matches.contains(entryValue)) continue;
            matches.add(entryValue);
        }
        return matches;
    }

    public Option getShortOption(char key) {
        Character keyChar = new Character(key);
        Option match = null;
        if (this.shortOptions.containsKey(keyChar)) {
            match = (Option)this.shortOptions.get(keyChar);
        }
        return match;
    }

    public List getOptions(String key) {
        Option match;
        ArrayList<Option> matches = new ArrayList<Option>();
        if (key.length() == 1 && (match = this.getShortOption(key.charAt(0))) != null) {
            matches.add(match);
        }
        Iterator iter = this.getLongOptions(key).iterator();
        while (iter.hasNext()) {
            Option match2 = (Option)iter.next();
            if (matches.contains(match2)) continue;
            matches.add(match2);
        }
        return matches;
    }

    static {
        $assertionsDisabled = !OptionList.class.desiredAssertionStatus();
    }
}

