/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.options;

import org.crosswire.common.options.ArgumentType;
import org.crosswire.common.options.DataType;

public class Option {
    private String description;
    private char shortName;
    private String longName;
    private DataType dataType;
    private ArgumentType argumentType;
    private String defaultValue;

    public Option(String description, char shortName) {
        this(description, ArgumentType.NO_ARGUMENT, DataType.BOOLEAN, shortName, null, null);
    }

    public Option(String description, String longName) {
        this(description, ArgumentType.NO_ARGUMENT, DataType.BOOLEAN, '\u0000', longName, null);
    }

    public Option(String description, char shortName, String longName) {
        this(description, ArgumentType.NO_ARGUMENT, DataType.BOOLEAN, shortName, longName, null);
    }

    public Option(String description, char shortName, String longName, String defaultValue) {
        this(description, ArgumentType.NO_ARGUMENT, DataType.BOOLEAN, shortName, longName, defaultValue);
    }

    public Option(String description, ArgumentType argumentType, DataType dataType, char shortName) {
        this(description, argumentType, dataType, shortName, null, null);
    }

    public Option(String description, ArgumentType argumentType, DataType dataType, String longName) {
        this(description, argumentType, dataType, '\u0000', longName, null);
    }

    public Option(String description, ArgumentType argumentType, DataType dataType, char shortName, String longName) {
        this(description, argumentType, dataType, shortName, longName, null);
    }

    public Option(String description, ArgumentType argumentType, DataType dataType, char shortName, String longName, String defaultValue) {
        this.description = description;
        this.argumentType = argumentType;
        this.dataType = dataType;
        this.shortName = shortName;
        this.longName = longName;
        this.defaultValue = defaultValue;
    }

    public String getDescription() {
        return this.description;
    }

    public char getShortName() {
        return this.shortName;
    }

    public String getLongName() {
        return this.longName;
    }

    public ArgumentType getArgumentType() {
        return this.argumentType;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }
}

