/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.compress;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.crosswire.common.compress.AbstractCompressor;

public class Zip
extends AbstractCompressor {
    public Zip(InputStream input) {
        super(input);
    }

    public ByteArrayOutputStream compress() throws IOException {
        BufferedInputStream in = new BufferedInputStream(this.input);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DeflaterOutputStream out = new DeflaterOutputStream((OutputStream)bos, new Deflater(), 2048);
        byte[] buf = new byte[2048];
        int count = in.read(buf);
        while (count != -1) {
            out.write(buf, 0, count);
            count = in.read(buf);
        }
        in.close();
        out.flush();
        out.close();
        return bos;
    }

    public ByteArrayOutputStream uncompress() throws IOException {
        return this.uncompress(2048);
    }

    public ByteArrayOutputStream uncompress(int expectedLength) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        BufferedOutputStream out = new BufferedOutputStream(bos, expectedLength);
        InflaterInputStream in = new InflaterInputStream(this.input, new Inflater(), expectedLength);
        byte[] buf = new byte[expectedLength];
        int count = in.read(buf);
        while (count != -1) {
            out.write(buf, 0, count);
            count = in.read(buf);
        }
        in.close();
        out.flush();
        out.close();
        return bos;
    }
}

