/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.passage;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.crosswire.jsword.passage.Key;

public class KeyIterator
implements Iterator {
    private Stack stack = new Stack();

    public KeyIterator(Key key) {
        this.stack.push(new Locator(key));
    }

    protected void prepare() {
        if (this.stack.size() == 0) {
            return;
        }
        Locator peek = (Locator)this.stack.peek();
        if (peek.getParent().getChildCount() > peek.getPosition()) {
            return;
        }
        this.stack.pop();
        this.prepare();
    }

    public boolean hasNext() {
        this.prepare();
        return this.stack.size() != 0;
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Locator peek = (Locator)this.stack.peek();
        int childNum = peek.getPosition();
        peek.setPosition(childNum + 1);
        if (childNum == -1) {
            return peek.getParent();
        }
        this.stack.push(new Locator(peek.getParent().get(childNum)));
        return this.next();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static class Locator {
        private Key parent;
        private int position;

        public Locator(Key parent) {
            this.parent = parent;
            this.position = -1;
        }

        public Key getParent() {
            return this.parent;
        }

        public void setParent(Key parent) {
            this.parent = parent;
        }

        public int getPosition() {
            return this.position;
        }

        public void setPosition(int position) {
            this.position = position;
        }
    }
}

