/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.index.lucene.analysis;

import java.io.IOException;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.DataPolice;
import org.crosswire.jsword.book.study.StrongsNumber;
import org.crosswire.jsword.index.lucene.analysis.AbstractBookTokenFilter;

public class StrongsNumberFilter
extends AbstractBookTokenFilter {
    private Token lastToken;
    private StrongsNumber number;

    public StrongsNumberFilter(TokenStream in) {
        this(null, in);
    }

    public StrongsNumberFilter(Book book, TokenStream in) {
        super(book, in);
    }

    public final Token next(Token result) throws IOException {
        Token token = result;
        if (this.lastToken == null) {
            if ((token = this.input.next(token)) == null) {
                return null;
            }
            try {
                char[] buf = result.termBuffer();
                String tokenText = new String(buf, 0, result.termLength());
                this.number = new StrongsNumber(tokenText);
                String s = this.number.getStrongsNumber();
                if (!s.equals(tokenText)) {
                    result.setTermBuffer(s.toCharArray(), 0, s.length());
                }
                if (this.number.isPart()) {
                    this.lastToken = result;
                }
            }
            catch (BookException e) {
                DataPolice.report(e.getDetailedMessage());
            }
        } else {
            token = this.lastToken;
            this.lastToken = null;
            String s = this.number.getFullStrongsNumber();
            result.setTermBuffer(s.toCharArray(), 0, s.length());
        }
        return token;
    }
}

