/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.bridge;

import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.Books;
import org.crosswire.jsword.index.IndexManager;
import org.crosswire.jsword.index.IndexManagerFactory;
import org.crosswire.jsword.index.IndexStatusEvent;
import org.crosswire.jsword.index.IndexStatusListener;

public class BookIndexer {
    private Book book;
    private IndexManager indexManager;
    private IndexStatusListener isl;
    private boolean done;

    public BookIndexer(Book book) {
        this.book = book;
        this.done = true;
        this.indexManager = IndexManagerFactory.getIndexManager();
        this.isl = new StatusListener(this);
    }

    public boolean isIndexed() {
        return this.done && this.indexManager.isIndexed(this.book);
    }

    public void deleteIndex() throws BookException {
        if (this.done) {
            this.done = false;
            this.book.addIndexStatusListener(this.isl);
            this.indexManager.deleteIndex(this.book);
            while (!this.done) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.book.removeIndexStatusListener(this.isl);
        }
    }

    public void createIndex() throws BookException {
        if (this.done) {
            this.done = false;
            this.book.addIndexStatusListener(this.isl);
            if (this.isIndexed()) {
                this.deleteIndex();
            }
            this.indexManager.scheduleIndexCreation(this.book);
            while (!this.done) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.book.removeIndexStatusListener(this.isl);
        }
    }

    protected void setDone(boolean state) {
        this.done = state;
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            BookIndexer.usage();
            return;
        }
        System.err.println("BookIndexer " + args[0] + " " + args[1]);
        String operation = args[0];
        Book b = Books.installed().getBook(args[1]);
        if (b == null) {
            System.err.println("Book not found");
            return;
        }
        BookIndexer indexer = new BookIndexer(b);
        if (operation.equalsIgnoreCase("create")) {
            try {
                indexer.createIndex();
            }
            catch (BookException e) {
                System.err.println("Unable to re-index book.");
                e.printStackTrace();
            }
        } else if (operation.equalsIgnoreCase("delete")) {
            try {
                indexer.deleteIndex();
            }
            catch (BookException e) {
                System.err.println("Unable to delete index for book.");
                e.printStackTrace();
            }
        } else if (operation.equalsIgnoreCase("check")) {
            System.err.println(indexer.isIndexed());
        } else {
            BookIndexer.usage();
        }
    }

    public static void usage() {
        System.err.println("Usage: BookIndexer operation book");
    }

    public static final class StatusListener
    implements IndexStatusListener {
        private BookIndexer indexer;

        public StatusListener(BookIndexer indexer) {
            this.indexer = indexer;
        }

        public void statusChanged(IndexStatusEvent ev) {
            this.indexer.setDone(true);
        }
    }
}

