/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URI;
import org.crosswire.common.activate.Activatable;
import org.crosswire.common.activate.Activator;
import org.crosswire.common.activate.Lock;
import org.crosswire.common.compress.CompressorType;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.NetUtil;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.sword.AbstractBackend;
import org.crosswire.jsword.book.sword.BlockType;
import org.crosswire.jsword.book.sword.ConfigEntryType;
import org.crosswire.jsword.book.sword.SwordBookMetaData;
import org.crosswire.jsword.book.sword.SwordConstants;
import org.crosswire.jsword.book.sword.SwordUtil;
import org.crosswire.jsword.book.sword.UserMsg;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.KeyUtil;
import org.crosswire.jsword.passage.Verse;

public class ZVerseBackend
extends AbstractBackend {
    private static final String SUFFIX_COMP = "v";
    private static final String SUFFIX_INDEX = "s";
    private static final String SUFFIX_PART1 = "z";
    private static final String SUFFIX_TEXT = "z";
    private BlockType blockType;
    private int lastTestament = -1;
    private long lastBlockNum = -1L;
    private byte[] lastUncompressed;
    private boolean active;
    private static final Logger log;
    private RandomAccessFile[] idxRaf = new RandomAccessFile[3];
    private RandomAccessFile[] textRaf = new RandomAccessFile[3];
    private RandomAccessFile[] compRaf = new RandomAccessFile[3];
    private File[] idxFile = new File[3];
    private File[] textFile = new File[3];
    private File[] compFile = new File[3];
    private static final int COMP_ENTRY_SIZE = 10;
    private static final int IDX_ENTRY_SIZE = 12;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ZVerseBackend(SwordBookMetaData sbmd, BlockType blockType) {
        super(sbmd);
        this.blockType = blockType;
    }

    public final void activate(Lock lock) {
        try {
            if (this.idxFile[1] == null) {
                URI path = this.getExpandedDataPath();
                String otAllButLast = NetUtil.lengthenURI((URI)path, (String)(File.separator + "ot" + '.' + this.blockType.getIndicator() + "z")).getPath();
                this.idxFile[1] = new File(otAllButLast + SUFFIX_INDEX);
                this.textFile[1] = new File(otAllButLast + "z");
                this.compFile[1] = new File(otAllButLast + SUFFIX_COMP);
                String ntAllButLast = NetUtil.lengthenURI((URI)path, (String)(File.separator + "nt" + '.' + this.blockType.getIndicator() + "z")).getPath();
                this.idxFile[2] = new File(ntAllButLast + SUFFIX_INDEX);
                this.textFile[2] = new File(ntAllButLast + "z");
                this.compFile[2] = new File(ntAllButLast + SUFFIX_COMP);
            }
        }
        catch (BookException e) {
            this.idxFile[1] = null;
            this.textFile[1] = null;
            this.compFile[1] = null;
            this.idxFile[2] = null;
            this.textFile[2] = null;
            this.compFile[2] = null;
            return;
        }
        if (this.idxFile[1].canRead()) {
            try {
                this.idxRaf[1] = new RandomAccessFile(this.idxFile[1], "r");
                this.textRaf[1] = new RandomAccessFile(this.textFile[1], "r");
                this.compRaf[1] = new RandomAccessFile(this.compFile[1], "r");
            }
            catch (FileNotFoundException ex) {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)ex);
                }
                log.error("Could not open OT", (Throwable)ex);
                this.idxRaf[1] = null;
                this.textRaf[1] = null;
                this.compRaf[1] = null;
            }
        }
        if (this.idxFile[2].canRead()) {
            try {
                this.idxRaf[2] = new RandomAccessFile(this.idxFile[2], "r");
                this.textRaf[2] = new RandomAccessFile(this.textFile[2], "r");
                this.compRaf[2] = new RandomAccessFile(this.compFile[2], "r");
            }
            catch (FileNotFoundException ex) {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)ex);
                }
                log.error("Could not open NT", (Throwable)ex);
                this.idxRaf[2] = null;
                this.textRaf[2] = null;
                this.compRaf[2] = null;
            }
        }
        this.active = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deactivate(Lock lock) {
        if (this.idxRaf[2] != null) {
            try {
                this.idxRaf[2].close();
                this.textRaf[2].close();
                this.compRaf[2].close();
            }
            catch (IOException ex) {
                log.error("failed to close nt files", (Throwable)ex);
            }
            finally {
                this.idxRaf[2] = null;
                this.textRaf[2] = null;
                this.compRaf[2] = null;
            }
        }
        if (this.idxRaf[1] != null) {
            try {
                this.idxRaf[1].close();
                this.textRaf[1].close();
                this.compRaf[1].close();
            }
            catch (IOException ex) {
                log.error("failed to close ot files", (Throwable)ex);
            }
            finally {
                this.idxRaf[1] = null;
                this.textRaf[1] = null;
                this.compRaf[1] = null;
            }
        }
        this.active = false;
    }

    public boolean contains(Key key) {
        this.checkActive();
        Verse verse = KeyUtil.getVerse(key);
        try {
            int testament = SwordConstants.getTestament(verse);
            long index = SwordConstants.getIndex(verse);
            if (this.compRaf[testament] == null) {
                return false;
            }
            byte[] temp = SwordUtil.readRAF(this.compRaf[testament], index * 10L, 10);
            if (temp == null || temp.length == 0) {
                return false;
            }
            int verseSize = SwordUtil.decodeLittleEndian16(temp, 8);
            return verseSize > 0;
        }
        catch (IOException e) {
            return false;
        }
    }

    public String getRawText(Key key) throws BookException {
        this.checkActive();
        SwordBookMetaData sbmd = this.getBookMetaData();
        String charset = sbmd.getBookCharset();
        String compressType = (String)sbmd.getProperty(ConfigEntryType.COMPRESS_TYPE);
        Verse verse = KeyUtil.getVerse(key);
        try {
            int testament = SwordConstants.getTestament(verse);
            long index = SwordConstants.getIndex(verse);
            if (this.compRaf[testament] == null) {
                return "";
            }
            byte[] temp = SwordUtil.readRAF(this.compRaf[testament], index * 10L, 10);
            if (temp == null || temp.length == 0) {
                return "";
            }
            long blockNum = SwordUtil.decodeLittleEndian32(temp, 0);
            int verseStart = SwordUtil.decodeLittleEndian32(temp, 4);
            int verseSize = SwordUtil.decodeLittleEndian16(temp, 8);
            byte[] uncompressed = null;
            if (blockNum == this.lastBlockNum && testament == this.lastTestament) {
                uncompressed = this.lastUncompressed;
            } else {
                temp = SwordUtil.readRAF(this.idxRaf[testament], blockNum * 12L, 12);
                if (temp == null || temp.length == 0) {
                    return "";
                }
                int blockStart = SwordUtil.decodeLittleEndian32(temp, 0);
                int blockSize = SwordUtil.decodeLittleEndian32(temp, 4);
                int uncompressedSize = SwordUtil.decodeLittleEndian32(temp, 8);
                byte[] data = SwordUtil.readRAF(this.textRaf[testament], blockStart, blockSize);
                this.decipher(data);
                uncompressed = CompressorType.fromString((String)compressType).getCompressor(data).uncompress(uncompressedSize).toByteArray();
                this.lastBlockNum = blockNum;
                this.lastTestament = testament;
                this.lastUncompressed = uncompressed;
            }
            byte[] chopped = new byte[verseSize];
            System.arraycopy(uncompressed, verseStart, chopped, 0, verseSize);
            return SwordUtil.decode(key.getName(), chopped, charset);
        }
        catch (IOException e) {
            throw new BookException(UserMsg.READ_FAIL, e, new Object[]{verse.getName()});
        }
    }

    protected final void checkActive() {
        if (!this.active) {
            Activator.activate((Activatable)this);
        }
    }

    static {
        $assertionsDisabled = !ZVerseBackend.class.desiredAssertionStatus();
        log = Logger.getLogger((Class)ZVerseBackend.class);
    }
}

