/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book;

import java.io.Serializable;
import org.crosswire.common.util.MsgBase;
import org.crosswire.jsword.book.UserMsg;

public final class BookCategory
implements Serializable,
Comparable {
    public static final BookCategory BIBLE = new BookCategory("Biblical Texts", UserMsg.BIBLE);
    public static final BookCategory DICTIONARY = new BookCategory("Lexicons / Dictionaries", UserMsg.DICTIONARY);
    public static final BookCategory COMMENTARY = new BookCategory("Commentaries", UserMsg.COMMENTARY);
    public static final BookCategory DAILY_DEVOTIONS = new BookCategory("Daily Devotional", UserMsg.READINGS);
    public static final BookCategory GLOSSARY = new BookCategory("Glossaries", UserMsg.GLOSSARIES);
    public static final BookCategory QUESTIONABLE = new BookCategory("Cults / Unorthodox / Questionable Material", UserMsg.UNORTHODOX);
    public static final BookCategory ESSAYS = new BookCategory("Essays", UserMsg.ESSAYS);
    public static final BookCategory IMAGES = new BookCategory("Images", UserMsg.IMAGES);
    public static final BookCategory MAPS = new BookCategory("Maps", UserMsg.MAPS);
    public static final BookCategory GENERAL_BOOK = new BookCategory("Generic Books", UserMsg.GENERAL);
    public static final BookCategory OTHER = new BookCategory("Other", UserMsg.OTHER);
    private transient String name;
    private transient MsgBase externalName;
    private static int nextObj;
    private final int obj = nextObj++;
    private static final BookCategory[] VALUES;
    private static final long serialVersionUID = 3256727260177708345L;

    private BookCategory(String name, MsgBase externalName) {
        this.name = name;
        this.externalName = externalName;
    }

    public static BookCategory fromString(String name) {
        for (int i = 0; i < VALUES.length; ++i) {
            BookCategory o = VALUES[i];
            if (!o.name.equalsIgnoreCase(name)) continue;
            return o;
        }
        return OTHER;
    }

    public static BookCategory fromExternalString(String name) {
        for (int i = 0; i < VALUES.length; ++i) {
            BookCategory o = VALUES[i];
            if (!o.externalName.toString().equalsIgnoreCase(name)) continue;
            return o;
        }
        return OTHER;
    }

    public static BookCategory fromInteger(int i) {
        return VALUES[i];
    }

    public int compareTo(Object o) {
        BookCategory that = (BookCategory)o;
        return this.name.compareTo(that.name);
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.externalName.toString();
    }

    Object readResolve() {
        return VALUES[this.obj];
    }

    static {
        VALUES = new BookCategory[]{BIBLE, DICTIONARY, COMMENTARY, DAILY_DEVOTIONS, GLOSSARY, QUESTIONABLE, ESSAYS, IMAGES, MAPS, GENERAL_BOOK, OTHER};
    }
}

