/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.swing.desktop;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.io.IOException;
import java.net.URI;
import java.util.Properties;
import org.crosswire.common.util.CWProject;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.NetUtil;
import org.crosswire.common.util.ResourceUtil;
import org.crosswire.common.util.StringUtil;

public class LayoutPersistence {
    private static final Logger log = Logger.getLogger((Class)LayoutPersistence.class);
    private Properties settings;
    private static final int STATE = 0;
    private static final int WIDTH = 1;
    private static final int HEIGHT = 2;
    private static final int LOCATION_X = 3;
    private static final int LOCATION_Y = 4;
    private static LayoutPersistence instance = new LayoutPersistence();

    private LayoutPersistence() {
        try {
            this.settings = ResourceUtil.getProperties(this.getClass());
        }
        catch (IOException e) {
            this.settings = new Properties();
        }
    }

    public static LayoutPersistence instance() {
        return instance;
    }

    public synchronized boolean isLayoutPersisted(Window window) {
        return this.settings.containsKey(window.getName());
    }

    public synchronized void saveLayout(Window window) {
        int state = 0;
        if (window instanceof Frame) {
            Frame frame = (Frame)window;
            state = frame.getExtendedState();
        }
        this.settings.setProperty(window.getName(), StringUtil.join((Object[])new String[]{Integer.toString(state), Integer.toString(window.getWidth()), Integer.toString(window.getHeight()), Integer.toString(window.getX()), Integer.toString(window.getY())}, (String)"_"));
        try {
            URI outputURI = CWProject.instance().getWritablePropertiesURI(this.getClass().getName());
            NetUtil.storeProperties((Properties)this.settings, (URI)outputURI, (String)"Persistent Window properties");
        }
        catch (IOException ex) {
            log.error(ex.getLocalizedMessage(), (Throwable)ex);
        }
    }

    public synchronized void restoreLayout(Window window) {
        String[] parts = StringUtil.split((String)this.settings.getProperty(window.getName()), (char)'_');
        if (parts == null || parts.length == 0) {
            return;
        }
        if (window instanceof Frame) {
            Frame frame = (Frame)window;
            frame.setExtendedState(Integer.parseInt(parts[0]));
        }
        window.setSize(new Dimension(Integer.parseInt(parts[1]), Integer.parseInt(parts[2])));
        window.setLocation(new Point(Integer.parseInt(parts[3]), Integer.parseInt(parts[4])));
    }
}

