/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import org.crosswire.common.util.ResourceUtil;
import org.crosswire.common.util.RowProcessor;

public class TabbedFileReader {
    private TabbedFileReader() {
    }

    public static void read(String fileName, int columns, RowProcessor lp) throws IOException {
        String line;
        URL fileURL = ResourceUtil.getResource(fileName);
        FileReader reader = null;
        try {
            reader = new FileReader(fileURL.getFile());
        }
        catch (IOException ex1) {
            reader = new FileReader(fileName);
        }
        BufferedReader in = new BufferedReader(reader);
        Object[] row = new Object[columns];
        while ((line = in.readLine()) != null) {
            int previousLoc = 0;
            int lastColumn = columns - 1;
            for (int col = 0; col < lastColumn; ++col) {
                int loc = line.indexOf(9, previousLoc);
                if (loc == -1) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                row[col] = line.substring(previousLoc, loc);
                previousLoc = loc + 1;
            }
            row[lastColumn] = line.substring(previousLoc);
            lp.process(row);
        }
        in.close();
    }
}

