/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.crosswire.common.util.Filter;

public class SortedListSet
extends ArrayList
implements Set {
    private static final long serialVersionUID = 3258413945407484212L;

    public SortedListSet() {
    }

    public SortedListSet(int initialCapacity) {
        super(initialCapacity);
    }

    public SortedListSet(Collection c) {
        this(c.size());
        this.addAll(c);
    }

    public void add(int index, Object element) {
        this.add(element);
    }

    public boolean add(Object o) {
        int pos = Collections.binarySearch(this, o);
        if (pos < 0) {
            super.add(-pos - 1, o);
            return true;
        }
        return false;
    }

    public boolean addAll(Collection c) {
        boolean added = false;
        Iterator bmdIter = c.iterator();
        while (bmdIter.hasNext()) {
            if (!this.add(bmdIter.next())) continue;
            added = true;
        }
        return added;
    }

    public boolean addAll(int index, Collection c) {
        return this.addAll(c);
    }

    public Object set(int index, Object element) {
        Object item = this.remove(index);
        this.add(element);
        return item;
    }

    public SortedListSet filter(Filter filter) {
        SortedListSet listSet = (SortedListSet)this.clone();
        Iterator iter = listSet.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (filter.test(obj)) continue;
            iter.remove();
        }
        return listSet;
    }
}

