/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import java.util.AbstractList;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import org.crosswire.common.util.Logger;

public class RobustList
extends AbstractList
implements List {
    protected Entry head;
    protected Entry foot;
    protected int size;
    protected static final Logger log = Logger.getLogger(RobustList.class);

    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    public int size() {
        return this.size;
    }

    public boolean add(Object o) {
        new Entry(o);
        return true;
    }

    public Object remove(int index) {
        Entry e = this.findEntry(index);
        e.remove();
        return e.object;
    }

    public boolean remove(Object o) {
        if (o == null) {
            Entry e = this.head;
            while (e != null) {
                if (e.object == null) {
                    e.remove();
                    return true;
                }
                e = e.next;
            }
        } else {
            Entry e = this.head;
            while (e != null) {
                if (o.equals(e.object)) {
                    e.remove();
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public void clear() {
        this.debug("pre-clear");
        this.head = null;
        this.foot = null;
        this.size = 0;
        this.debug("post-clear");
    }

    public Object get(int index) {
        return this.findEntry((int)index).object;
    }

    private Entry findEntry(int index) {
        Entry e;
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        if (index < this.size / 2) {
            e = this.head;
            for (int i = 0; i != index; ++i) {
                e = e.next;
            }
        } else {
            e = this.foot;
            for (int i = this.size - 1; i != index; --i) {
                e = e.prev;
            }
        }
        return e;
    }

    public int indexOf(Object o) {
        int index = 0;
        if (o == null) {
            Entry e = this.head;
            while (e != null) {
                if (e.object == null) {
                    return index;
                }
                e = e.next;
                ++index;
            }
        } else {
            Entry e = this.head;
            while (e != null) {
                if (o.equals(e.object)) {
                    return index;
                }
                e = e.next;
                ++index;
            }
        }
        return -1;
    }

    public Enumeration elements() {
        return new RobustListEnumeration(this.head);
    }

    protected void debug(String title) {
        log.debug(title);
        log.debug(" head =" + this.head);
        log.debug(" foot =" + this.foot);
        int i = 0;
        Entry e = this.head;
        while (e != null) {
            log.debug(" index=" + i);
            e.debug();
            e = e.next;
            ++i;
        }
    }

    private class Entry {
        protected Object object;
        protected Entry next;
        protected Entry prev;

        protected Entry(Object object) {
            this.object = object;
            this.next = null;
            this.prev = RobustList.this.foot;
            if (RobustList.this.head == null) {
                RobustList.this.head = this;
            }
            if (RobustList.this.foot != null) {
                RobustList.this.foot.next = this;
            }
            RobustList.this.foot = this;
            ++RobustList.this.size;
        }

        protected void remove() {
            if (this == RobustList.this.foot) {
                if (this.prev != null) {
                    this.prev.next = null;
                }
                RobustList.this.foot = this.prev;
            }
            if (this == RobustList.this.head) {
                if (this.next != null) {
                    this.next.prev = null;
                }
                RobustList.this.head = this.next;
            }
            if (this.prev != null) {
                this.prev.next = this.next;
            }
            if (this.next != null) {
                this.next.prev = this.prev;
            }
            --RobustList.this.size;
        }

        protected void debug() {
            log.debug("  prev=" + this.prev);
            log.debug("  this=" + this);
            log.debug("  next=" + this.next);
            log.debug("   obje=" + this.object);
        }
    }

    private static class RobustListEnumeration
    implements Enumeration {
        private Entry next;

        RobustListEnumeration(Entry head) {
            this.next = head;
        }

        public boolean hasMoreElements() {
            return this.next != null;
        }

        public Object nextElement() throws NoSuchElementException {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Object retcode = this.next.object;
            this.next = this.next.next;
            return retcode;
        }
    }
}

