/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.crosswire.common.util.LogConfig;

public final class Logger {
    private static final String ROOT_LOGGER = "";
    private static final String CLASS_NAME;
    private java.util.logging.Logger logger;

    public static Logger getLogger(Class clazz) {
        return new Logger(clazz);
    }

    public static void outputNothing() {
        java.util.logging.Logger.getLogger(ROOT_LOGGER).setLevel(Level.OFF);
    }

    public static void outputInfoMinimum() {
        java.util.logging.Logger.getLogger(ROOT_LOGGER).setLevel(Level.WARNING);
    }

    public static void outputEverything() {
        java.util.logging.Logger.getLogger(ROOT_LOGGER).setLevel(Level.FINEST);
    }

    private Logger(Class id) {
        this.logger = java.util.logging.Logger.getLogger(id.getName());
    }

    public void fatal(String message) {
        this.doLogging(Level.SEVERE, message, null);
    }

    public void fatal(String message, Throwable th) {
        this.doLogging(Level.SEVERE, message, th);
    }

    public void error(String message) {
        this.doLogging(Level.WARNING, message, null);
    }

    public void error(String message, Throwable th) {
        this.doLogging(Level.WARNING, message, th);
    }

    public void info(String message) {
        this.doLogging(Level.CONFIG, message, null);
    }

    public void info(String message, Throwable th) {
        this.doLogging(Level.CONFIG, message, th);
    }

    public void warn(String message) {
        this.doLogging(Level.INFO, message, null);
    }

    public void warn(String message, Throwable th) {
        this.doLogging(Level.INFO, message, th);
    }

    public void debug(String message) {
        this.logger.fine(message);
    }

    private void doLogging(Level level, String message, Throwable th) {
        StackTraceElement frame;
        String cname;
        int ix;
        String className = null;
        String methodName = null;
        int lineNumber = -1;
        StackTraceElement[] stack = new Throwable().getStackTrace();
        for (ix = 0; ix < stack.length && !(cname = (frame = stack[ix]).getClassName()).equals(CLASS_NAME); ++ix) {
        }
        while (ix < stack.length) {
            frame = stack[ix];
            cname = frame.getClassName();
            if (!cname.equals(CLASS_NAME)) {
                className = cname;
                methodName = frame.getMethodName();
                lineNumber = frame.getLineNumber();
                break;
            }
            ++ix;
        }
        LogRecord logRecord = new LogRecord(level, message);
        logRecord.setLoggerName(this.logger.getName());
        logRecord.setSourceClassName(className);
        logRecord.setSourceMethodName(methodName);
        logRecord.setThrown(th);
        logRecord.setSequenceNumber(lineNumber);
        this.logger.log(logRecord);
    }

    static {
        System.setProperty("java.util.logging.config.class", LogConfig.class.getName());
        CLASS_NAME = Logger.class.getName();
    }
}

